/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.batching.v2.AutoValue_BatchingSettings;
import com.google.common.base.Preconditions;

@BetaApi(value="The surface for batching is not stable yet and may change in the future.")
public abstract class BatchingSettings {
    public abstract int getElementCountThreshold();

    public abstract long getRequestByteThreshold();

    public static Builder newBuilder() {
        return new AutoValue_BatchingSettings.Builder();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder setElementCountThreshold(int var1);

        public abstract Builder setRequestByteThreshold(long var1);

        abstract BatchingSettings autoBuild();

        public BatchingSettings build() {
            BatchingSettings settings = this.autoBuild();
            Preconditions.checkState((settings.getElementCountThreshold() >= 0 ? 1 : 0) != 0, (Object)"elementCountThreshold cannot be negative");
            Preconditions.checkState((settings.getRequestByteThreshold() >= 0L ? 1 : 0) != 0, (Object)"requestByteThreshold cannot be negative");
            return settings;
        }
    }
}

