/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.listener;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.thumbnail.ThumbnailConstants;
import org.nuxeo.runtime.api.Framework;

public class CheckBlobUpdateListener
implements EventListener {
    private static final Logger log = LogManager.getLogger(CheckBlobUpdateListener.class);

    public void handleEvent(Event event) {
        EventContext ec = event.getContext();
        if (!(ec instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext context = (DocumentEventContext)ec;
        DocumentModel doc = context.getSourceDocument();
        if (!doc.hasSchema("file")) {
            return;
        }
        Property content = doc.getProperty("file:content");
        if ("documentCreated".equals(event.getName()) || content.isDirty() && !Boolean.TRUE.equals(ec.getProperty("thumbnailUpdated"))) {
            if ("beforeDocumentModification".equals(event.getName()) && doc.hasFacet("Thumbnail") && content.getValue() == null) {
                doc.setPropertyValue("thumb:thumbnail", null);
            }
            if (content.getValue() != null) {
                doc.addFacet("Thumbnail");
                if (Boolean.TRUE.equals(context.getProperty("disableThumbnailComputation"))) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = () -> ((DocumentModel)doc).getId();
                    log.trace("Thumbnail computation is disabled for document {}", supplierArray);
                    return;
                }
                ((EventService)Framework.getService(EventService.class)).fireEvent(ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name(), (EventContext)context);
            }
        }
    }
}

