/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.internal.ClassLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;

public class Introspector {
    private static final String attributeDescription = "Attribute exposed for management";
    private static final String operationDescription = "Operation exposed for management";
    private static final String constructorDescription = "Public constructor of the MBean";
    private static final String mbeanInfoDescription = "Information on the management interface of the MBean";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "Introspector");

    private Introspector() {
    }

    public static final boolean isDynamic(Class c) {
        return DynamicMBean.class.isAssignableFrom(c);
    }

    public static void testCreation(Class c) throws NotCompliantMBeanException {
        int mods = c.getModifiers();
        if (Modifier.isAbstract(mods) || Modifier.isInterface(mods)) {
            throw new NotCompliantMBeanException("MBean class must be concrete");
        }
        Constructor<?>[] consList = c.getConstructors();
        if (consList.length == 0) {
            throw new NotCompliantMBeanException("MBean class must have public constructor");
        }
    }

    public static MBeanInfo testCompliance(Class baseClass) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(baseClass)) {
            return null;
        }
        return Introspector.testCompliance(baseClass, null);
    }

    static MBeanInfo testCompliance(Class baseClass, Class mbeanInterface) throws NotCompliantMBeanException {
        if (baseClass.isInterface()) {
            throw new NotCompliantMBeanException(String.valueOf(baseClass.getName()) + " must be a class.");
        }
        if (mbeanInterface == null) {
            mbeanInterface = Introspector.getStandardMBeanInterface(baseClass);
        } else {
            if (!mbeanInterface.isAssignableFrom(baseClass)) {
                String msg = String.valueOf(baseClass.getName()) + " does not implement the " + mbeanInterface.getName() + " interface";
                throw new NotCompliantMBeanException(msg);
            }
            if (!mbeanInterface.isInterface()) {
                String msg = String.valueOf(baseClass.getName()) + ": " + mbeanInterface.getName() + " is not an interface";
                throw new NotCompliantMBeanException(msg);
            }
        }
        if (mbeanInterface == null) {
            String baseClassName = baseClass.getName();
            String msg = String.valueOf(baseClassName) + " does not implement the " + baseClassName + "MBean interface or the DynamicMBean interface";
            throw new NotCompliantMBeanException(msg);
        }
        int mods = mbeanInterface.getModifiers();
        if (!Modifier.isPublic(mods)) {
            throw new NotCompliantMBeanException(String.valueOf(mbeanInterface.getName()) + " implemented by " + baseClass.getName() + " must be public");
        }
        return Introspector.introspect(baseClass, mbeanInterface);
    }

    public static Class getMBeanInterface(Class baseClass) {
        if (Introspector.isDynamic(baseClass)) {
            return null;
        }
        return Introspector.getStandardMBeanInterface(baseClass);
    }

    static Class getStandardMBeanInterface(Class baseClass) {
        Class current = baseClass;
        Class mbeanInterface = null;
        while (current != null) {
            mbeanInterface = Introspector.findMBeanInterface(current, current.getName());
            if (mbeanInterface != null) break;
            current = current.getSuperclass();
        }
        return mbeanInterface;
    }

    private static Class findMBeanInterface(Class aClass, String aName) {
        Class current = aClass;
        while (current != null) {
            Class<?>[] interfaces = current.getInterfaces();
            int len = interfaces.length;
            int i = 0;
            while (i < len) {
                Class inter = Introspector.implementsMBean(interfaces[i], aName);
                if (inter != null) {
                    return inter;
                }
                ++i;
            }
            current = current.getSuperclass();
        }
        return null;
    }

    private static MBeanInfo introspect(Class baseClass, Class beanClass) throws NotCompliantMBeanException {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        Method[] methodList = beanClass.getMethods();
        int i = 0;
        while (i < methodList.length) {
            Method method = methodList[i];
            String name = method.getName();
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            try {
                MBeanAttributeInfo attr = name.startsWith("get") && !name.equals("get") && argCount == 0 && !resultType.equals(Void.TYPE) ? new MBeanAttributeInfo(name.substring(3), attributeDescription, method, null) : (name.startsWith("set") && !name.equals("set") && argCount == 1 && resultType.equals(Void.TYPE) ? new MBeanAttributeInfo(name.substring(3), attributeDescription, null, method) : (name.startsWith("is") && !name.equals("is") && argCount == 0 && resultType.equals(Boolean.TYPE) ? new MBeanAttributeInfo(name.substring(2), attributeDescription, method, null) : null));
                if (attr != null) {
                    if (Introspector.testConsistency(attributes, attr)) {
                        attributes.add(attr);
                    }
                } else {
                    MBeanOperationInfo oper = new MBeanOperationInfo(operationDescription, method);
                    operations.add(oper);
                }
            }
            catch (IntrospectionException e) {
                Introspector.error("introspect", e);
            }
            ++i;
        }
        return Introspector.constructResult(baseClass, attributes, operations);
    }

    private static boolean testConsistency(List attributes, MBeanAttributeInfo attr) throws NotCompliantMBeanException {
        for (MBeanAttributeInfo mb : attributes) {
            if (!mb.getName().equals(attr.getName())) continue;
            if (attr.isReadable() && mb.isReadable() && attr.isIs() != mb.isIs()) {
                String msg = "Conflicting getters for attribute " + mb.getName();
                throw new NotCompliantMBeanException(msg);
            }
            if (!mb.getType().equals(attr.getType())) {
                if (mb.isWritable() && attr.isWritable()) {
                    String msg = "Type mismatch between parameters of set" + mb.getName() + " methods";
                    throw new NotCompliantMBeanException(msg);
                }
                String msg = "Type mismatch between parameters of get or is" + mb.getName() + ", set" + mb.getName() + " methods";
                throw new NotCompliantMBeanException(msg);
            }
            if (attr.isReadable() && mb.isReadable()) {
                return false;
            }
            if (!attr.isWritable() || !mb.isWritable()) continue;
            return false;
        }
        return true;
    }

    static MBeanConstructorInfo[] getConstructors(Class baseClass) {
        Constructor<?>[] consList = baseClass.getConstructors();
        ArrayList<MBeanConstructorInfo> constructors = new ArrayList<MBeanConstructorInfo>();
        int i = 0;
        while (i < consList.length) {
            Constructor<?> constructor = consList[i];
            MBeanConstructorInfo mc = null;
            try {
                mc = new MBeanConstructorInfo(constructorDescription, constructor);
            }
            catch (Exception ex) {
                mc = null;
            }
            if (mc != null) {
                constructors.add(mc);
            }
            ++i;
        }
        MBeanConstructorInfo[] resultConstructors = new MBeanConstructorInfo[constructors.size()];
        constructors.toArray(resultConstructors);
        return resultConstructors;
    }

    private static MBeanInfo constructResult(Class baseClass, List attributes, List operations) {
        int len = attributes.size();
        MBeanAttributeInfo[] attrlist = new MBeanAttributeInfo[len];
        attributes.toArray(attrlist);
        ArrayList<MBeanAttributeInfo> mergedAttributes = new ArrayList<MBeanAttributeInfo>();
        int i = 0;
        while (i < len) {
            MBeanAttributeInfo bi = attrlist[i];
            if (bi != null) {
                MBeanAttributeInfo att = bi;
                int j = i + 1;
                while (j < len) {
                    MBeanAttributeInfo mi = attrlist[j];
                    if (mi != null && mi.getName().compareTo(bi.getName()) == 0) {
                        attrlist[j] = null;
                        att = new MBeanAttributeInfo(bi.getName(), bi.getType(), attributeDescription, true, true, bi.isIs());
                    }
                    ++j;
                }
                mergedAttributes.add(att);
            }
            ++i;
        }
        MBeanAttributeInfo[] resultAttributes = new MBeanAttributeInfo[mergedAttributes.size()];
        mergedAttributes.toArray(resultAttributes);
        MBeanOperationInfo[] resultOperations = new MBeanOperationInfo[operations.size()];
        operations.toArray(resultOperations);
        MBeanConstructorInfo[] resultConstructors = Introspector.getConstructors(baseClass);
        MBeanInfo resultMBeanInfo = new MBeanInfo(baseClass.getName(), mbeanInfoDescription, resultAttributes, resultConstructors, resultOperations, null);
        return resultMBeanInfo;
    }

    static Class implementsMBean(Class c, String clName) {
        if (c.getName().compareTo(String.valueOf(clName) + "MBean") == 0) {
            return c;
        }
        Class current = c;
        Class<?>[] interfaces = c.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            try {
                if (interfaces[i].getName().compareTo(String.valueOf(clName) + "MBean") == 0) {
                    return interfaces[i];
                }
            }
            catch (Exception e) {
                return null;
            }
            ++i;
        }
        return null;
    }

    private static void error(String method, Throwable t) {
        logger.error(method, t);
    }
}

