/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.admin.permissions.PurgeWorkStatus;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class PermissionsPurgeWork
extends TransientStoreWork {
    private static final Logger log = LogManager.getLogger(PermissionsPurgeWork.class);
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final String CATEGORY = "permissionsPurge";
    protected DocumentModel searchDocument;
    protected int batchSize = 20;

    public PermissionsPurgeWork(DocumentModel searchDocument) {
        this.searchDocument = searchDocument;
    }

    public String getTitle() {
        return String.format("Permissions purge for '%s' user and %s document ids", this.searchDocument.getPropertyValue("rs:ace_username"), StringUtils.join((Iterable)((List)((Object)this.searchDocument.getPropertyValue("rs:ecm_ancestorIds"))), (String)","));
    }

    public String getCategory() {
        return CATEGORY;
    }

    public void work() {
        TransientStore store = PermissionsPurgeWork.getStore();
        store.putParameter(this.id, "status", (Serializable)new PurgeWorkStatus(PurgeWorkStatus.State.RUNNING));
        this.setStatus("Purging");
        this.openSystemSession();
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        PageProviderDefinition def = pageProviderService.getPageProviderDefinition("permissions_purge");
        String query = NXQLQueryBuilder.getQuery((DocumentModel)this.searchDocument, (WhereClauseDefinition)def.getWhereClause(), null, (SortInfo[])new SortInfo[0]);
        ArrayList<String> docIds = new ArrayList<String>();
        try (IterableQueryResult result = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
            for (Map map : result) {
                docIds.add((String)map.get("ecm:uuid"));
            }
        }
        List usernames = (List)((Object)this.searchDocument.getPropertyValue("rs:ace_username"));
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = docIds::size;
        supplierArray[1] = () -> usernames;
        supplierArray[2] = () -> this.searchDocument.getPropertyValue("rs:ecm_ancestorIds");
        log.info("Purging permissions on {} documents for usernames: {} and ancestorIds: {}", supplierArray);
        int acpUpdatedCount = 0;
        for (String docId : docIds) {
            IdRef ref = new IdRef(docId);
            ACP acp = this.session.getACP((DocumentRef)ref);
            boolean changed = false;
            for (String username : usernames) {
                for (ACL acl : acp.getACLs()) {
                    for (ACE ace : acl) {
                        if (!username.equals(ace.getUsername())) continue;
                        GregorianCalendar now = new GregorianCalendar();
                        ace.setEnd((Calendar)now);
                        changed = true;
                    }
                }
            }
            try {
                if (!changed) continue;
                this.session.setACP((DocumentRef)ref, acp, true);
                if (++acpUpdatedCount % this.batchSize != 0) continue;
                this.commitOrRollbackTransaction();
                this.startTransaction();
            }
            catch (TransactionRuntimeException e) {
                if (e.getMessage().contains("Transaction timeout")) {
                    this.batchSize = 1;
                }
                throw e;
            }
        }
        this.setStatus(null);
    }

    public void cleanUp(boolean ok, Exception e) {
        try {
            super.cleanUp(ok, e);
        }
        finally {
            PermissionsPurgeWork.getStore().putParameter(this.id, "status", (Serializable)new PurgeWorkStatus(PurgeWorkStatus.State.COMPLETED));
        }
    }

    public String launch() {
        WorkManager works = (WorkManager)Framework.getService(WorkManager.class);
        TransientStore store = PermissionsPurgeWork.getStore();
        store.putParameter(this.id, "status", (Serializable)new PurgeWorkStatus(PurgeWorkStatus.State.SCHEDULED));
        works.schedule((Work)this);
        return this.id;
    }

    public int getRetryCount() {
        return 10;
    }

    static PurgeWorkStatus getStatus(String id) {
        TransientStore store = PermissionsPurgeWork.getStore();
        if (!store.exists(id)) {
            return null;
        }
        return (PurgeWorkStatus)store.getParameter(id, "status");
    }
}

