/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.runtime;

import java.util.List;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.admin.runtime.SimplifiedBundleInfo;

public class SimplifiedServerInfo {
    protected List<SimplifiedBundleInfo> bundleInfos;
    protected String runtimeVersion;
    protected List<String> warnings;
    protected List<String> errors;

    public List<SimplifiedBundleInfo> getBundleInfos() {
        return this.bundleInfos;
    }

    public void setBundleInfos(List<SimplifiedBundleInfo> bundleInfos) {
        this.bundleInfos = bundleInfos;
    }

    public String getApplicationName() {
        return PlatformVersionHelper.getApplicationName();
    }

    public String getApplicationVersion() {
        return PlatformVersionHelper.getApplicationVersion();
    }

    public String getDistributionName() {
        return PlatformVersionHelper.getDistributionName();
    }

    public String getDistributionVersion() {
        return PlatformVersionHelper.getDistributionVersion();
    }

    public String getDistributionHost() {
        return PlatformVersionHelper.getDistributionHost();
    }

    public String getDistributionDate() {
        return PlatformVersionHelper.getDistributionDate();
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public boolean hasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getApplicationName());
        sb.append("  ");
        sb.append(this.getApplicationVersion());
        sb.append("\n");
        sb.append("runtime :  ");
        sb.append(this.runtimeVersion);
        sb.append("\n");
        sb.append("warnings :  ");
        if (this.warnings == null || this.warnings.isEmpty()) {
            sb.append("none");
        } else {
            for (String warn : this.warnings) {
                sb.append("\n  ");
                sb.append(warn);
            }
        }
        sb.append("errors :  ");
        if (this.errors == null || this.errors.isEmpty()) {
            sb.append("none");
        } else {
            for (String error : this.errors) {
                sb.append("\n  ");
                sb.append(error);
            }
        }
        sb.append("\nbundles :  ");
        for (SimplifiedBundleInfo bi : this.bundleInfos) {
            sb.append("\n  ");
            sb.append(bi.getName());
            sb.append("    (");
            sb.append(bi.getVersion());
            sb.append(")");
        }
        return sb.toString();
    }
}

