/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.migrator;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractRepositoryMigrator
implements MigrationService.Migrator {
    private static final Logger log = LogManager.getLogger(AbstractRepositoryMigrator.class);
    @Deprecated(since="11.1", forRemoval=true)
    protected MigrationService.MigrationContext migrationContext;

    protected String probeRepository(String repositoryName) {
        return (String)TransactionHelper.runInTransaction(() -> (String)CoreInstance.doPrivileged((String)repositoryName, this::probeSession));
    }

    @Deprecated(since="11.1", forRemoval=true)
    protected void checkShutdownRequested() {
        this.checkShutdownRequested(this.migrationContext);
    }

    protected void checkShutdownRequested(MigrationService.MigrationContext migrationContext) {
        if (migrationContext.isShutdownRequested()) {
            throw new MigrationShutdownException();
        }
    }

    protected void reportProgress(String message, long num, long total) {
        log.debug("{}: {}/{}", (Object)message, (Object)num, (Object)total);
        this.migrationContext.reportProgress(message, num, total);
    }

    protected void reportProgress(String repositoryName, String message, long num, long total) {
        this.reportProgress(String.format("[%s] %s", repositoryName, message), num, total);
    }

    @Deprecated(since="11.1", forRemoval=true)
    protected void migrateRepository(String repositoryName) {
        TransactionHelper.runInTransaction(() -> CoreInstance.doPrivileged((String)repositoryName, session -> this.migrateSession((CoreSession)session)));
    }

    protected void migrateRepository(String step, MigrationService.MigrationContext migrationContext, String repositoryName) {
        TransactionHelper.runInTransaction(() -> CoreInstance.doPrivileged((String)repositoryName, session -> this.migrateSession(step, migrationContext, (CoreSession)session)));
    }

    protected abstract void migrateSession(String var1, MigrationService.MigrationContext var2, CoreSession var3);

    @Deprecated(since="11.1", forRemoval=true)
    protected <T> void processBatched(int batchSize, Collection<T> collection, Consumer<T> consumer, String progressMessage) {
        this.processBatched(this.migrationContext, batchSize, collection, consumer, progressMessage);
    }

    protected <T> void processBatched(MigrationService.MigrationContext migrationContext, int batchSize, Collection<T> collection, Consumer<T> consumer, String progressMessage) {
        int size = collection.size();
        int i = -1;
        for (T element : collection) {
            consumer.accept(element);
            this.checkShutdownRequested(migrationContext);
            if (++i % batchSize != 0 && i != size - 1) continue;
            this.reportProgress(progressMessage, i + 1, size);
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected abstract String probeSession(CoreSession var1);

    @Deprecated(since="11.1", forRemoval=true)
    protected void migrateSession(CoreSession session) {
        this.migrateSession(null, this.migrationContext, session);
    }

    protected static class MigrationShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

