/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RepositoryService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.repository.RepositoryService");
    public static final String CLUSTER_START_DURATION_PROP = "org.nuxeo.repository.cluster.start.duration";
    public static final Duration CLUSTER_START_DURATION_DEFAULT = Duration.ofMinutes(1L);
    private static final Log log = LogFactory.getLog(RepositoryService.class);
    public static final String XP_REPOSITORY = "repository";
    private final Map<String, org.nuxeo.ecm.core.model.Repository> repositories = new ConcurrentHashMap<String, org.nuxeo.ecm.core.model.Repository>();

    public void shutdown() {
        log.info((Object)"Shutting down repository manager");
        this.repositories.values().forEach(org.nuxeo.ecm.core.model.Repository::shutdown);
        this.repositories.clear();
    }

    public int getApplicationStartedOrder() {
        return 100;
    }

    public void start(ComponentContext context) {
        TransactionHelper.runInTransaction(this::doCreateRepositories);
        Framework.getRuntime().getComponentManager().addListener(new ComponentManager.Listener(){

            public void afterStart(ComponentManager mgr, boolean isResume) {
                RepositoryService.this.initRepositories();
            }

            public void afterStop(ComponentManager mgr, boolean isStandby) {
                Framework.getRuntime().getComponentManager().removeListener((ComponentManager.Listener)this);
            }
        });
    }

    public void stop(ComponentContext context) {
        TransactionHelper.runInTransaction(this::shutdown);
    }

    public void initRepositories() {
        TransactionHelper.runInTransaction(this::doInitRepositories);
    }

    protected void doCreateRepositories() {
        this.repositories.clear();
        for (String repositoryName : this.getRepositoryNames()) {
            RepositoryFactory factory = this.getFactory(repositoryName);
            if (factory == null) continue;
            this.createRepository(repositoryName, factory);
        }
    }

    protected void createRepository(String repositoryName, RepositoryFactory factory) {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        String prop = Framework.getProperty((String)CLUSTER_START_DURATION_PROP);
        Duration duration = DurationUtils.parsePositive((String)prop, (Duration)CLUSTER_START_DURATION_DEFAULT);
        Duration pollDelay = Duration.ofSeconds(1L);
        clusterService.runAtomically("start-repository-" + repositoryName, duration, pollDelay, () -> {
            org.nuxeo.ecm.core.model.Repository repository = (org.nuxeo.ecm.core.model.Repository)factory.call();
            this.repositories.put(repositoryName, repository);
        });
    }

    protected void doInitRepositories() {
        RepositoryInitializationHandler handler = RepositoryInitializationHandler.getInstance();
        if (handler == null) {
            return;
        }
        for (String name : this.getRepositoryNames()) {
            this.initializeRepository(handler, name);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    protected void initializeRepository(final RepositoryInitializationHandler handler, String name) {
        new UnrestrictedSessionRunner(name){

            public void run() {
                handler.initializeRepository(this.session);
            }
        }.runUnrestricted();
    }

    public org.nuxeo.ecm.core.model.Repository getRepository(String repositoryName) {
        return this.repositories.get(repositoryName);
    }

    protected RepositoryFactory getFactory(String repositoryName) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (repositoryManager == null) {
            return null;
        }
        Repository repo = repositoryManager.getRepository(repositoryName);
        if (repo == null) {
            return null;
        }
        RepositoryFactory repositoryFactory = (RepositoryFactory)repo.getRepositoryFactory();
        if (repositoryFactory == null) {
            throw new NullPointerException("Missing repositoryFactory for repository: " + repositoryName);
        }
        return repositoryFactory;
    }

    public List<String> getRepositoryNames() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        return repositoryManager.getRepositoryNames();
    }

    public int getActiveSessionsCount() {
        return this.repositories.values().stream().mapToInt(org.nuxeo.ecm.core.model.Repository::getActiveSessionsCount).sum();
    }
}

