/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.platform.relations.api.DocumentRelationManager;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.GraphDescription;
import org.nuxeo.ecm.platform.relations.api.GraphFactory;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.ResourceAdapter;
import org.nuxeo.ecm.platform.relations.descriptors.GraphTypeDescriptor;
import org.nuxeo.ecm.platform.relations.descriptors.ResourceAdapterDescriptor;
import org.nuxeo.ecm.platform.relations.services.DocumentRelationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RelationService
extends DefaultComponent
implements RelationManager {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.relations.services.RelationService");
    private static final long serialVersionUID = -4778456059717447736L;
    private static final Log log = LogFactory.getLog(RelationService.class);
    protected final Map<String, Class<?>> graphTypes = new Hashtable();
    protected final Map<String, GraphDescription> graphDescriptions = new Hashtable<String, GraphDescription>();
    public final Map<String, GraphFactory> graphFactories;
    public final Map<String, Graph> graphRegistry = new Hashtable<String, Graph>();
    protected final Map<String, String> resourceAdapterRegistry;

    public RelationService() {
        this.graphFactories = new Hashtable<String, GraphFactory>();
        this.resourceAdapterRegistry = new Hashtable<String, String>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("graphtypes")) {
            this.registerGraphType(contribution);
        } else if (extensionPoint.equals("graphs")) {
            this.registerGraph(contribution);
        } else if (extensionPoint.equals("resourceadapters")) {
            this.registerResourceAdapter(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("graphtypes")) {
            this.unregisterGraphType(contribution);
        } else if (extensionPoint.equals("graphs")) {
            this.unregisterGraph(contribution);
        } else if (extensionPoint.equals("resourceadapters")) {
            this.unregisterResourceAdapter(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't unregister !", extensionPoint));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(RelationManager.class)) {
            return (T)((Object)this);
        }
        if (adapter.isAssignableFrom(DocumentRelationManager.class)) {
            return (T)new DocumentRelationService();
        }
        return null;
    }

    private void registerGraphType(Object contribution) {
        Class<?> klass;
        GraphTypeDescriptor graphTypeDescriptor = (GraphTypeDescriptor)contribution;
        String graphType = graphTypeDescriptor.getName();
        String className = graphTypeDescriptor.getClassName();
        if (this.graphTypes.containsKey(graphType)) {
            log.error((Object)String.format("Graph type %s already registered using %s", graphType, this.graphTypes.get(graphType)));
            return;
        }
        try {
            klass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Cannot register unknown class for graph type %s: %s", graphType, className), e);
        }
        if (!Graph.class.isAssignableFrom(klass) && !GraphFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Invalid graph class/factory type: " + className);
        }
        this.graphTypes.put(graphType, klass);
        log.info((Object)String.format("Registered graph type: %s (%s)", graphType, className));
    }

    private void unregisterGraphType(Object contrib) {
        GraphTypeDescriptor graphTypeExtension = (GraphTypeDescriptor)contrib;
        String graphType = graphTypeExtension.getName();
        ArrayList<GraphDescription> list = new ArrayList<GraphDescription>(this.graphDescriptions.values());
        for (GraphDescription graphDescription : list) {
            if (!graphType.equals(graphDescription.getGraphType())) continue;
            String name = graphDescription.getName();
            this.graphFactories.remove(name);
            this.graphRegistry.remove(name);
            this.graphDescriptions.remove(name);
            log.info((Object)("Unregistered graph: " + name));
        }
        this.graphTypes.remove(graphType);
        log.info((Object)("Unregistered graph type: " + graphType));
    }

    public List<String> getGraphTypes() {
        return new ArrayList<String>(this.graphTypes.keySet());
    }

    protected void registerGraph(Object contribution) {
        GraphDescription graphDescription = (GraphDescription)contribution;
        String name = graphDescription.getName();
        if (this.graphDescriptions.containsKey(name)) {
            log.info((Object)String.format("Overriding graph %s definition", name));
            this.graphDescriptions.remove(name);
        }
        this.graphDescriptions.put(name, graphDescription);
        log.info((Object)("Registered graph: " + name));
        this.graphRegistry.remove(name);
    }

    protected void unregisterGraph(Object contribution) {
        GraphDescription graphDescription = (GraphDescription)contribution;
        String name = graphDescription.getName();
        if (this.graphDescriptions.containsKey(name)) {
            this.graphFactories.remove(name);
            this.graphRegistry.remove(name);
            this.graphDescriptions.remove(name);
            log.info((Object)("Unregistered graph: " + name));
        }
    }

    private void registerResourceAdapter(Object contribution) {
        ResourceAdapterDescriptor adapter = (ResourceAdapterDescriptor)contribution;
        String ns = adapter.getNamespace();
        String adapterClassName = adapter.getClassName();
        if (this.resourceAdapterRegistry.containsKey(ns)) {
            log.info((Object)("Overriding resource adapter config for namespace " + ns));
        }
        this.resourceAdapterRegistry.put(ns, adapterClassName);
        log.info((Object)String.format("%s namespace registered using adapter %s", ns, adapterClassName));
    }

    private void unregisterResourceAdapter(Object contribution) {
        ResourceAdapterDescriptor adapter = (ResourceAdapterDescriptor)contribution;
        String ns = adapter.getNamespace();
        String adapterClassName = adapter.getClassName();
        String registered = this.resourceAdapterRegistry.get(ns);
        if (registered == null) {
            log.error((Object)String.format("Namespace %s not found", ns));
        } else if (!registered.equals(adapterClassName)) {
            log.error((Object)String.format("Namespace %s: wrong class %s", ns, registered));
        } else {
            this.resourceAdapterRegistry.remove(ns);
            log.info((Object)String.format("%s unregistered, was using %s", ns, adapterClassName));
        }
    }

    private ResourceAdapter getResourceAdapterForNamespace(String namespace) {
        String adapterClassName = this.resourceAdapterRegistry.get(namespace);
        if (adapterClassName == null) {
            log.error((Object)String.format("Cannot find adapter for namespace: %s", namespace));
            return null;
        }
        try {
            ResourceAdapter adapter = (ResourceAdapter)RelationService.class.getClassLoader().loadClass(adapterClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            adapter.setNamespace(namespace);
            return adapter;
        }
        catch (ReflectiveOperationException e) {
            String msg = String.format("Cannot instantiate generator with namespace '%s': %s", namespace, e);
            log.error((Object)msg);
            return null;
        }
    }

    public Graph getGraphByName(String name) {
        return this.getGraph(name, null);
    }

    public Graph getGraph(String name, CoreSession session) {
        GraphDescription graphDescription = this.graphDescriptions.get(name);
        if (graphDescription == null) {
            throw new RuntimeException("No such graph: " + name);
        }
        Graph graph = this.getGraphFromRegistries(graphDescription, session);
        if (graph != null) {
            return graph;
        }
        Class<?> klass = this.graphTypes.get(graphDescription.getGraphType());
        if (Graph.class.isAssignableFrom(klass)) {
            try {
                graph = (Graph)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.graphRegistry.put(name, graph);
        } else {
            GraphFactory factory;
            try {
                factory = (GraphFactory)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.graphFactories.put(name, factory);
        }
        return this.getGraphFromRegistries(graphDescription, session);
    }

    protected Graph getGraphFromRegistries(GraphDescription graphDescription, CoreSession session) {
        String name = graphDescription.getName();
        Graph graph = this.graphRegistry.get(name);
        if (graph != null) {
            graph.setDescription(graphDescription);
            return graph;
        }
        GraphFactory factory = this.graphFactories.get(name);
        if (factory != null) {
            return factory.createGraph(graphDescription, session);
        }
        return null;
    }

    protected Graph newGraph(String className) {
        try {
            Class<?> klass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            return (Graph)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Graph getTransientGraph(String type) {
        Class<?> klass = this.graphTypes.get(type);
        if (Graph.class.isAssignableFrom(klass)) {
            try {
                return (Graph)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Graph type cannot be transient: " + type);
    }

    public Resource getResource(String namespace, Serializable object, Map<String, Object> context) {
        ResourceAdapter adapter = this.getResourceAdapterForNamespace(namespace);
        if (adapter == null) {
            log.error((Object)("Cannot find adapter for namespace: " + namespace));
            return null;
        }
        return adapter.getResource(object, context);
    }

    public Set<Resource> getAllResources(Serializable object, Map<String, Object> context) {
        HashSet<Resource> res = new HashSet<Resource>();
        for (String ns : this.resourceAdapterRegistry.keySet()) {
            Class klass;
            ResourceAdapter adapter = this.getResourceAdapterForNamespace(ns);
            if (adapter == null || (klass = adapter.getKlass()) == null || !klass.isAssignableFrom(object.getClass())) continue;
            res.add(adapter.getResource(object, context));
        }
        return res;
    }

    public Serializable getResourceRepresentation(String namespace, Resource resource, Map<String, Object> context) {
        ResourceAdapter adapter = this.getResourceAdapterForNamespace(namespace);
        if (adapter == null) {
            log.error((Object)("Cannot find adapter for namespace: " + namespace));
            return null;
        }
        return adapter.getResourceRepresentation(resource, context);
    }

    public List<String> getGraphNames() {
        return new ArrayList<String>(this.graphDescriptions.keySet());
    }

    public void start(ComponentContext context) {
        RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
        if (repositoryService == null) {
            return;
        }
        log.info((Object)"Relation Service initialization");
        for (String graphName : this.graphDescriptions.keySet()) {
            GraphDescription desc = this.graphDescriptions.get(graphName);
            log.info((Object)("create RDF Graph " + graphName));
            if (desc.getGraphType().equalsIgnoreCase("jena")) {
                TransactionHelper.runWithoutTransaction(() -> {
                    Graph graph = this.getGraphByName(graphName);
                    graph.size();
                });
                continue;
            }
            TransactionHelper.runInTransaction(() -> {
                Graph graph = this.getGraphByName(graphName);
                graph.size();
            });
        }
    }
}

