/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.http.readonly.filter;

import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.elasticsearch.http.readonly.AbstractSearchRequestFilterImpl;

public class DefaultSearchRequestFilter
extends AbstractSearchRequestFilterImpl {
    @Override
    public String getPayload() throws JSONException {
        if (this.principal.isAdministrator()) {
            return this.payload;
        }
        if (this.filteredPayload == null) {
            JSONObject query;
            JSONObject payloadJson;
            String[] principals = SecurityService.getPrincipalsToCheck((NuxeoPrincipal)this.principal);
            if (this.payload.contains("\\")) {
                this.payload = this.payload.replaceAll("\\\\", "_@@_");
            }
            if ((payloadJson = new JSONObject(this.payload)).has("query")) {
                query = payloadJson.getJSONObject("query");
                payloadJson.remove("query");
            } else {
                query = new JSONObject("{\"match_all\":{}}");
            }
            JSONObject filter = new JSONObject().put("terms", (Object)new JSONObject().put("ecm:acl", (Object)principals));
            JSONObject newQuery = new JSONObject().put("bool", (Object)new JSONObject().put("must", (Object)query).put("filter", (Object)filter));
            payloadJson.put("query", (Object)newQuery);
            this.filteredPayload = payloadJson.toString();
            if (this.filteredPayload.contains("_@@_")) {
                this.filteredPayload = this.filteredPayload.replaceAll("_@@_", "\\\\");
            }
        }
        return this.filteredPayload;
    }
}

