/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.finder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractRootSectionsFinder
extends UnrestrictedSessionRunner
implements RootSectionFinder {
    public static final String SCHEMA_PUBLISHING = "publishing";
    public static final String SECTIONS_PROPERTY_NAME = "publish:sections";
    protected static Set<String> sectionRootTypes;
    protected static Set<String> sectionTypes;
    protected CoreSession userSession;
    protected List<String> unrestrictedSectionRootFromWorkspaceConfig;
    protected List<String> unrestrictedDefaultSectionRoot;
    protected DocumentModelList accessibleSectionRoots;
    protected DocumentModel currentDocument;
    protected static final Log log;

    protected abstract void computeUserSectionRoots(DocumentModel var1);

    protected abstract String buildQuery(String var1);

    protected abstract void computeUnrestrictedRoots(CoreSession var1);

    public AbstractRootSectionsFinder(CoreSession userSession) {
        super(userSession);
        this.userSession = userSession;
    }

    public void reset() {
        this.currentDocument = null;
    }

    public DocumentModelList getAccessibleSectionRoots(DocumentModel currentDoc) {
        if (this.currentDocument == null || !this.currentDocument.getRef().equals(currentDoc.getRef())) {
            this.computeUserSectionRoots(currentDoc);
        }
        return this.accessibleSectionRoots;
    }

    public DocumentModelList getSectionRootsForWorkspace(DocumentModel currentDoc, boolean addDefaultSectionRoots) {
        if (this.currentDocument == null || !this.currentDocument.getRef().equals(currentDoc.getRef())) {
            this.computeUserSectionRoots(currentDoc);
        }
        if (this.unrestrictedDefaultSectionRoot.isEmpty() && addDefaultSectionRoots) {
            DocumentModelList defaultSectionRoots = this.getDefaultSectionRoots(this.session);
            this.unrestrictedDefaultSectionRoot = new ArrayList<String>();
            for (DocumentModel root : defaultSectionRoots) {
                this.unrestrictedDefaultSectionRoot.add(root.getPathAsString());
            }
        }
        return this.getFiltredSectionRoots(this.unrestrictedSectionRootFromWorkspaceConfig, true);
    }

    public DocumentModelList getSectionRootsForWorkspace(DocumentModel currentDoc) {
        return this.getSectionRootsForWorkspace(currentDoc, false);
    }

    public DocumentModelList getDefaultSectionRoots(boolean onlyHeads, boolean addDefaultSectionRoots) {
        if (this.unrestrictedDefaultSectionRoot == null) {
            this.computeUserSectionRoots(null);
        }
        if (this.unrestrictedDefaultSectionRoot.isEmpty() && addDefaultSectionRoots) {
            DocumentModelList defaultSectionRoots = this.getDefaultSectionRoots(this.session);
            this.unrestrictedDefaultSectionRoot = new ArrayList<String>();
            for (DocumentModel root : defaultSectionRoots) {
                this.unrestrictedDefaultSectionRoot.add(root.getPathAsString());
            }
        }
        return this.getFiltredSectionRoots(this.unrestrictedDefaultSectionRoot, onlyHeads);
    }

    public DocumentModelList getDefaultSectionRoots(boolean onlyHeads) {
        return this.getDefaultSectionRoots(onlyHeads, false);
    }

    protected DocumentModelList getFiltredSectionRoots(List<String> rootPaths, boolean onlyHeads) {
        ArrayList<Object> filtredDocRef = new ArrayList<Object>();
        ArrayList<DocumentRef> trashedDocRef = new ArrayList<DocumentRef>();
        for (String rootPath : rootPaths) {
            PathRef rootRef = new PathRef(rootPath);
            if (this.userSession.hasPermission((DocumentRef)rootRef, "Read")) {
                filtredDocRef.add(rootRef);
                continue;
            }
            DocumentModelList accessibleSections = this.userSession.query(this.buildQuery(rootPath));
            for (DocumentModel section : accessibleSections) {
                if (onlyHeads && (filtredDocRef.contains(section.getParentRef()) || trashedDocRef.contains(section.getParentRef()))) {
                    trashedDocRef.add(section.getRef());
                    continue;
                }
                filtredDocRef.add(section.getRef());
            }
        }
        DocumentModelList documents = this.userSession.getDocuments(filtredDocRef.toArray(new DocumentRef[filtredDocRef.size()]));
        return this.filterDocuments(documents);
    }

    protected DocumentModelList filterDocuments(DocumentModelList docs) {
        DocumentModelListImpl filteredDocuments = new DocumentModelListImpl();
        FacetFilter facetFilter = new FacetFilter(Arrays.asList("Folderish"), Arrays.asList("HiddenInNavigation"));
        Filter & Serializable trashedFilter = (Filter & Serializable)docModel -> !docModel.isTrashed();
        CompoundFilter filter = new CompoundFilter(new Filter[]{facetFilter, trashedFilter});
        for (DocumentModel doc : docs) {
            if (!filter.accept(doc)) continue;
            filteredDocuments.add((Object)doc);
        }
        return filteredDocuments;
    }

    protected DocumentModelList getDefaultSectionRoots(CoreSession session) {
        DocumentModelListImpl sectionRoots = new DocumentModelListImpl();
        DocumentModelList domains = session.getChildren(session.getRootDocument().getRef(), "Domain");
        for (DocumentModel domain : domains) {
            for (String sectionRootNameType : this.getSectionRootTypes()) {
                DocumentModelList children = session.getChildren(domain.getRef(), sectionRootNameType);
                sectionRoots.addAll((Collection)children);
            }
        }
        return sectionRoots;
    }

    protected DocumentModelList getSectionRootsFromWorkspaceConfig(DocumentModel workspace, CoreSession session) {
        DocumentModelListImpl selectedSections = new DocumentModelListImpl();
        if (workspace.hasSchema(SCHEMA_PUBLISHING)) {
            String[] sectionIdsArray = (String[])workspace.getPropertyValue(SECTIONS_PROPERTY_NAME);
            List<Object> sectionIdsList = new ArrayList();
            if (sectionIdsArray != null && sectionIdsArray.length > 0) {
                sectionIdsList = Arrays.asList(sectionIdsArray);
            }
            if (sectionIdsList != null) {
                for (String currentSectionId : sectionIdsList) {
                    try {
                        DocumentModel sectionToAdd = session.getDocument((DocumentRef)new IdRef(currentSectionId));
                        selectedSections.add((Object)sectionToAdd);
                    }
                    catch (DocumentNotFoundException e) {
                        log.warn((Object)("Section with ID=" + currentSectionId + " not found for document with ID=" + workspace.getId()));
                    }
                }
            }
        }
        return selectedSections;
    }

    public void run() {
        this.computeUnrestrictedRoots(this.session);
    }

    protected Set<String> getSectionRootTypes() {
        if (sectionRootTypes == null && (sectionRootTypes = this.getTypeNamesForFacet("MasterPublishSpace")) == null) {
            sectionRootTypes = new HashSet<String>();
        }
        return sectionRootTypes;
    }

    protected Set<String> getTypeNamesForFacet(String facetName) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Set publishRoots = schemaManager.getDocumentTypeNamesForFacet(facetName);
        if (publishRoots == null || publishRoots.isEmpty()) {
            return null;
        }
        return publishRoots;
    }

    protected Set<String> getSectionTypes() {
        if (sectionTypes == null && (sectionTypes = this.getTypeNamesForFacet("MasterPublishSpace")) == null) {
            sectionTypes = new HashSet<String>();
        }
        return sectionTypes;
    }

    static {
        log = LogFactory.getLog(AbstractRootSectionsFinder.class);
    }
}

