/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.codec;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class DocumentFileCodec
extends AbstractDocumentViewCodec {
    public static final String FILE_PROPERTY_PATH_KEY = "FILE_PROPERTY_PATH";
    public static final String FILENAME_KEY = "FILENAME";
    public static final String URLPattern = "/(\\w+)/([a-zA-Z_0-9\\-]+)(/([a-zA-Z_0-9/:\\-\\.\\]\\[]*))+(/([^\\?]*))+(\\?)?(.*)?";

    public DocumentFileCodec() {
    }

    public DocumentFileCodec(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        String filepath = docView.getParameter(FILE_PROPERTY_PATH_KEY);
        String filename = docView.getParameter(FILENAME_KEY);
        if (docLoc != null && filepath != null && filename != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getPrefix());
            sb.append("/");
            sb.append(docLoc.getServerName());
            sb.append("/");
            sb.append(docLoc.getDocRef().toString());
            sb.append("/");
            sb.append(filepath);
            sb.append("/");
            sb.append(URIUtils.quoteURIPathToken((String)filename));
            String uri = sb.toString();
            HashMap<String, String> requestParams = new HashMap<String, String>(docView.getParameters());
            requestParams.remove(FILE_PROPERTY_PATH_KEY);
            requestParams.remove(FILENAME_KEY);
            return URIUtils.addParametersToURIQuery((String)uri, requestParams);
        }
        return null;
    }

    @Override
    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + URLPattern);
        Matcher m = pattern.matcher(url);
        if (m.matches() && m.groupCount() >= 4) {
            String query;
            Map requestParams;
            String server = m.group(1);
            String uuid = m.group(2);
            IdRef docRef = new IdRef(uuid);
            HashMap<String, String> params = new HashMap<String, String>();
            if (m.groupCount() >= 4) {
                String filePropertyPath = m.group(4);
                params.put(FILE_PROPERTY_PATH_KEY, filePropertyPath);
            }
            if (m.groupCount() >= 6) {
                String filename = m.group(6);
                try {
                    filename = URLDecoder.decode(filename, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    filename = StringUtils.toAscii((String)filename);
                }
                int jsessionidIndex = filename.indexOf(";jsessionid");
                if (jsessionidIndex != -1) {
                    filename = filename.substring(0, jsessionidIndex);
                }
                params.put(FILENAME_KEY, filename);
            }
            if (m.groupCount() >= 8 && (requestParams = URIUtils.getRequestParameters((String)(query = m.group(8)))) != null) {
                params.putAll(requestParams);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            return new DocumentViewImpl((DocumentLocation)docLoc, null, params);
        }
        return null;
    }

    public static String getFilename(DocumentModel doc, DocumentView docView) {
        String propertyPath;
        String propertyName;
        String filename = docView.getParameter(FILENAME_KEY);
        if (filename == null && (propertyName = DocumentModelUtils.decodePropertyName((String)(propertyPath = docView.getParameter(FILE_PROPERTY_PATH_KEY)))) != null) {
            filename = (String)DocumentModelUtils.getPropertyValue((DocumentModel)doc, (String)(propertyName + "/filename"));
        }
        return filename;
    }
}

