/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.collections;

import java.util.HashMap;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Collection.GetDocumentsFromCollection", category="Document", label="Get documents from collection", description="Get the list of documents visible by the currentUser in a collection. This is returning a list of documents.")
public class GetDocumentsFromCollectionOperation {
    public static final String ID = "Collection.GetDocumentsFromCollection";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;

    @OperationMethod
    public PaginableDocumentModelListImpl run(DocumentModel collection) throws OperationException {
        OperationChain chain = new OperationChain("operation");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("searchTerm", collection.getId());
        vars.put("providerName", "default_content_collection");
        OperationParameters oparams = new OperationParameters("Repository.PageProvider", vars);
        chain.add(oparams);
        return (PaginableDocumentModelListImpl)this.service.run(this.ctx, chain);
    }
}

