/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutTypeDefinitionComparator;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.export.LayoutTypeDefinitions;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;

public class LayoutTypeResource {
    protected final String category;
    protected LayoutStore service;
    protected final List<LayoutTypeDefinition> layoutTypes;

    public LayoutTypeResource(String category) {
        this.category = category;
        this.service = (LayoutStore)Framework.getService(LayoutStore.class);
        this.layoutTypes = this.service.getLayoutTypeDefinitions(category);
        Collections.sort(this.layoutTypes, new LayoutTypeDefinitionComparator());
    }

    @GET
    @Path(value="layoutTypes")
    public Object getLayoutTypeDefinitions(@Context HttpServletRequest request, @QueryParam(value="all") Boolean all) {
        return new LayoutTypeDefinitions((Collection<? extends LayoutTypeDefinition>)this.layoutTypes);
    }

    @GET
    @Path(value="layoutType/{name}")
    public Object getLayoutTypeDefinition(@Context HttpServletRequest request, @PathParam(value="name") String name) {
        LayoutTypeDefinition def = this.service.getLayoutTypeDefinition(this.category, name);
        if (def != null) {
            return def;
        }
        return Response.status((int)401).build();
    }

    public TemplateView getTemplate(@Context UriInfo uriInfo) {
        return this.getTemplate("layout-types.ftl", uriInfo);
    }

    protected TemplateView getTemplate(String name, UriInfo uriInfo) {
        Object baseURL = uriInfo.getAbsolutePath().toString();
        if (!((String)baseURL).endsWith("/")) {
            baseURL = (String)baseURL + "/";
        }
        TemplateView tv = new TemplateView((Object)this, name);
        tv.arg("layoutTypeCategory", (Object)this.category);
        tv.arg("layoutTypes", this.layoutTypes);
        tv.arg("baseURL", baseURL);
        return tv;
    }

    @GET
    public Object doGet(@QueryParam(value="layoutType") String layoutTypeName, @Context UriInfo uriInfo) {
        if (layoutTypeName == null) {
            return this.getTemplate(uriInfo);
        }
        LayoutTypeDefinition wType = this.service.getLayoutTypeDefinition(this.category, layoutTypeName);
        if (wType == null) {
            throw new WebResourceNotFoundException("No layout type found with name: " + layoutTypeName);
        }
        TemplateView tpl = this.getTemplate(uriInfo);
        tpl.arg("layoutType", (Object)wType);
        return tpl;
    }
}

