/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtilLoggingHelper {
    private static final Log log = LogFactory.getLog(JavaUtilLoggingHelper.class);
    private static LogHandler activeHandler;

    private JavaUtilLoggingHelper() {
    }

    public static synchronized void redirectToApacheCommons() {
        JavaUtilLoggingHelper.redirectToApacheCommons(Level.INFO);
    }

    public static synchronized void redirectToApacheCommons(Level threshold) {
        if (activeHandler != null) {
            return;
        }
        try {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            for (Handler handler : rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
            }
            activeHandler = new LogHandler();
            activeHandler.setLevel(threshold);
            rootLogger.addHandler(activeHandler);
            rootLogger.setLevel(threshold);
            log.info((Object)("Redirecting java.util.logging to Apache Commons Logging, threshold is " + threshold.toString()));
        }
        catch (SecurityException e) {
            log.error((Object)"Handler setup failed", (Throwable)e);
        }
    }

    public static synchronized void reset() {
        if (activeHandler == null) {
            return;
        }
        try {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            rootLogger.removeHandler(activeHandler);
        }
        catch (SecurityException e) {
            log.error((Object)"Handler removal failed", (Throwable)e);
        }
        activeHandler = null;
    }

    public static class LogHandler
    extends Handler {
        final ThreadLocal<LogRecord> holder = new ThreadLocal();
        private final Map<String, Log> cache = new ConcurrentHashMap<String, Log>();

        protected void doPublish(LogRecord record) {
            Level level = record.getLevel();
            if (level == Level.FINER || level == Level.FINEST) {
                return;
            }
            String name = record.getLoggerName();
            if (name == null) {
                return;
            }
            Log log = this.cache.get(name);
            if (log == null) {
                log = LogFactory.getLog((String)name);
                this.cache.put(name, log);
            }
            if (level == Level.FINE) {
                log.trace((Object)record.getMessage(), record.getThrown());
            } else if (level == Level.CONFIG) {
                log.debug((Object)record.getMessage(), record.getThrown());
            } else if (level == Level.INFO) {
                log.info((Object)record.getMessage(), record.getThrown());
            } else if (level == Level.WARNING) {
                log.warn((Object)record.getMessage(), record.getThrown());
            } else if (level == Level.SEVERE) {
                log.error((Object)record.getMessage(), record.getThrown());
            }
        }

        @Override
        public void publish(LogRecord record) {
            if (this.holder.get() != null) {
                return;
            }
            this.holder.set(record);
            try {
                this.doPublish(record);
            }
            finally {
                this.holder.remove();
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

