/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mongodb.audit.pageprovider;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.document.AdditionalDocumentAuditParams;
import org.nuxeo.ecm.platform.audit.api.document.DocumentAuditHelper;
import org.nuxeo.mongodb.audit.pageprovider.MongoDBAuditPageProvider;

public class MongoDBDocumentHistoryPageProvider
extends MongoDBAuditPageProvider {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MongoDBDocumentHistoryPageProvider.class);
    public static final String SINGLE_QUERY = String.format("{ \"%s\": \"?\" }", "docUUID");
    public static final String COMPLEX_QUERY = String.format("{ \"$or\": [ { \"%s\": \"?\" }, { \"$and\": [ { \"%s\": \"?\" }, { \"%s\": { \"$lte\": ISODate(\"?\") } } ] } ]}", "docUUID", "docUUID", "eventDate");
    protected Object[] newParams;

    @Override
    protected String getFixedPart() {
        if (this.getParameters().length == 3) {
            return COMPLEX_QUERY;
        }
        return SINGLE_QUERY;
    }

    @Override
    public List<SortInfo> getSortInfos() {
        List<SortInfo> sort = super.getSortInfos();
        if (sort == null || sort.size() == 0) {
            sort = new ArrayList<SortInfo>(2);
            sort.add(new SortInfo("eventDate", true));
            sort.add(new SortInfo("_id", true));
        }
        return sort;
    }

    public Object[] getParameters() {
        if (this.newParams == null) {
            CoreSession session;
            String uuid;
            Object[] params = super.getParameters();
            if (params.length != 1) {
                log.error((Object)(((Object)((Object)this)).getClass().getSimpleName() + " Expect only one parameter the document uuid, unexpected behavior may occur"));
            }
            if (params[0] instanceof DocumentModel) {
                DocumentModel doc = (DocumentModel)params[0];
                uuid = doc.getId();
                session = doc.getCoreSession();
            } else {
                session = (CoreSession)this.getProperties().get("coreSession");
                uuid = params[0].toString();
            }
            if (session != null) {
                AdditionalDocumentAuditParams additionalParams = DocumentAuditHelper.getAuditParamsForUUID((String)uuid, (CoreSession)session);
                this.newParams = additionalParams != null ? new Object[]{uuid, additionalParams.getTargetUUID(), additionalParams.getMaxDate()} : new Object[]{uuid};
            } else {
                log.warn((Object)"No core session found: cannot compute all info to get complete audit entries");
                return params;
            }
        }
        return this.newParams;
    }

    public boolean hasChangedParameters(Object[] parameters) {
        return this.getParametersChanged(this.parameters, parameters);
    }
}

