/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonReader;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentNotFoundException;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentSecurityException;
import org.nuxeo.ecm.platform.comment.impl.AbstractCommentManager;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class TreeCommentManager
extends AbstractCommentManager {
    private static final Logger log = LogManager.getLogger(TreeCommentManager.class);
    public static final String COMMENT_RELATED_TEXT_ID = "commentRelatedTextId_%s";
    public static final String AUTOSUBSCRIBE_CONFIG_KEY = "org.nuxeo.ecm.platform.comment.service.notification.autosubscribe";
    protected static final String COMMENT_NAME = "comment";
    @Deprecated(since="11.1")
    protected static final String GET_COMMENT_PAGE_PROVIDER_NAME = "GET_COMMENT_AS_EXTERNAL_ENTITY";
    protected static final String GET_EXTERNAL_COMMENT_PAGE_PROVIDER_NAME = "GET_EXTERNAL_COMMENT_BY_ECM_ANCESTOR";
    protected static final String GET_COMMENTS_FOR_DOCUMENT_PAGE_PROVIDER_NAME = "GET_COMMENTS_FOR_DOCUMENT_BY_ECM_PARENT";
    protected static final String SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE = "This service implementation does not implement deprecated API.";
    protected static final String QUERY_GET_COMMENTS_UUID_BY_COMMENT_ANCESTOR = "SELECT ecm:uuid FROM Comment WHERE ecm:ancestorId = '%s'";
    protected static final String QUERY_GET_COMMENTS_UUID_BY_COMMENT_ANCESTOR_AND_AUTHOR = "SELECT ecm:uuid FROM Comment WHERE ecm:ancestorId = '%s' AND comment:author = '%s'";

    public List<DocumentModel> getComments(CoreSession session, DocumentModel doc) {
        return this.getCommentDocuments(session, doc.getId(), null, null, true);
    }

    public Comment getComment(CoreSession session, String commentId) {
        DocumentModel commentDoc = this.getCommentDocumentModel(session, commentId);
        return (Comment)commentDoc.getAdapter(Comment.class);
    }

    public PartialList<Comment> getComments(CoreSession session, String documentId, Long pageSize, Long currentPageIndex, boolean sortAscending) {
        PartialList<DocumentModel> result = this.getCommentDocuments(session, documentId, pageSize, currentPageIndex, sortAscending);
        return result.stream().map(doc -> (Comment)doc.getAdapter(Comment.class)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> new PartialList(list, result.totalSize())));
    }

    public List<DocumentModel> getDocumentsForComment(DocumentModel comment) {
        throw new UnsupportedOperationException(SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE);
    }

    public DocumentModel getThreadForComment(DocumentModel comment) {
        throw new UnsupportedOperationException(SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE);
    }

    public Comment getExternalComment(CoreSession session, String documentId, String entityId) {
        DocumentModel commentDoc = this.getExternalCommentModel(session, documentId, entityId);
        return (Comment)commentDoc.getAdapter(Comment.class);
    }

    public Comment createComment(CoreSession session, Comment comment) {
        IdRef parentRef = new IdRef(comment.getParentId());
        this.checkCreateCommentPermissions(session, (DocumentRef)parentRef);
        this.fillCommentForCreation(session, comment);
        return (Comment)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel commentedDoc = s.getDocument((DocumentRef)parentRef);
            DocumentRef locationDocRef = this.getLocationRefOfCommentCreation((CoreSession)s, commentedDoc);
            DocumentModel commentDoc = s.newDocumentModel(locationDocRef, COMMENT_NAME, comment.getDocument().getType());
            if (comment.getDocument().hasFacet("ExternalEntity")) {
                commentDoc.addFacet("ExternalEntity");
            }
            DocumentModelJsonReader.applyDirtyPropertyValues((DocumentModel)comment.getDocument(), (DocumentModel)commentDoc);
            commentDoc.setPropertyValue("comment:ancestorIds", (Serializable)this.computeAncestorIds(session, comment.getParentId()));
            commentDoc = s.createDocument(commentDoc);
            Comment createdComment = (Comment)commentDoc.getAdapter(Comment.class);
            DocumentModel topLevelDoc = this.getTopLevelDocument((CoreSession)s, commentDoc);
            this.manageRelatedTextOfTopLevelDocument((CoreSession)s, topLevelDoc, createdComment.getId(), createdComment.getText());
            this.handleNotificationAutoSubscriptions((CoreSession)s, topLevelDoc, commentDoc);
            this.notifyEvent((CoreSession)s, "commentAdded", commentedDoc, commentDoc);
            return createdComment;
        });
    }

    public DocumentModel createComment(DocumentModel commentedDoc, DocumentModel commentDoc) {
        this.checkCreateCommentPermissions(commentDoc.getCoreSession(), commentedDoc.getRef());
        return (DocumentModel)CoreInstance.doPrivileged((CoreSession)commentDoc.getCoreSession(), session -> {
            DocumentRef locationDocRef = this.getLocationRefOfCommentCreation((CoreSession)session, commentedDoc);
            DocumentModel commentModelToCreate = session.newDocumentModel(locationDocRef, COMMENT_NAME, commentDoc.getType());
            commentModelToCreate.copyContent(commentDoc);
            commentModelToCreate.setPropertyValue("comment:parentId", (Serializable)((Object)commentedDoc.getId()));
            commentModelToCreate.setPropertyValue("comment:ancestorIds", (Serializable)this.computeAncestorIds((CoreSession)session, commentedDoc.getId()));
            commentModelToCreate = session.createDocument(commentModelToCreate);
            DocumentModel topLevelDoc = this.getTopLevelDocument((CoreSession)session, commentModelToCreate);
            this.manageRelatedTextOfTopLevelDocument((CoreSession)session, topLevelDoc, commentModelToCreate.getId(), (String)((Object)commentDoc.getPropertyValue("comment:text")));
            this.handleNotificationAutoSubscriptions((CoreSession)session, topLevelDoc, commentDoc);
            commentModelToCreate.detach(true);
            this.notifyEvent((CoreSession)session, "commentAdded", commentedDoc, commentModelToCreate);
            return commentModelToCreate;
        });
    }

    public DocumentModel createLocatedComment(DocumentModel doc, DocumentModel comment, String path) {
        throw new UnsupportedOperationException(SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE);
    }

    public DocumentModel createComment(DocumentModel doc, String text) {
        throw new UnsupportedOperationException(SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE);
    }

    public DocumentModel createComment(DocumentModel doc, String text, String author) {
        throw new UnsupportedOperationException(SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE);
    }

    public DocumentModel createComment(DocumentModel doc, DocumentModel parent, DocumentModel child) {
        throw new UnsupportedOperationException(SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE);
    }

    public Comment updateComment(CoreSession session, String commentId, Comment comment) {
        DocumentModel commentDoc = this.getCommentDocumentModel(session, commentId);
        return this.update(session, comment, commentDoc);
    }

    public Comment updateExternalComment(CoreSession session, String documentId, String entityId, Comment comment) {
        DocumentModel commentDoc = this.getExternalCommentModel(session, documentId, entityId);
        return this.update(session, comment, commentDoc);
    }

    protected Comment update(CoreSession session, Comment comment, DocumentModel commentDoc) {
        NuxeoPrincipal principal = session.getPrincipal();
        return (Comment)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel topLevelDoc = this.getTopLevelDocument((CoreSession)s, commentDoc);
            if (!(principal.isAdministrator() || commentDoc.getPropertyValue("comment:author").equals(principal.getName()) || session.hasPermission(principal, topLevelDoc.getRef(), "Everything"))) {
                throw new CommentSecurityException(String.format("The user %s cannot edit comments of document %s", principal.getName(), commentDoc.getPropertyValue("comment:parentId")));
            }
            if (comment.getModificationDate() == null) {
                comment.setModificationDate(Instant.now());
            }
            if (comment.getDocument().hasFacet("ExternalEntity")) {
                commentDoc.addFacet("ExternalEntity");
            }
            DocumentModelJsonReader.applyDirtyPropertyValues((DocumentModel)comment.getDocument(), (DocumentModel)commentDoc);
            DocumentModel updatedDoc = s.saveDocument(commentDoc);
            Comment updatedComment = (Comment)updatedDoc.getAdapter(Comment.class);
            this.manageRelatedTextOfTopLevelDocument((CoreSession)s, topLevelDoc, updatedComment.getId(), updatedComment.getText());
            DocumentModel commentedDoc = this.getCommentedDocument(session, commentDoc);
            this.notifyEvent(session, "commentUpdated", topLevelDoc, commentedDoc, updatedDoc);
            return updatedComment;
        });
    }

    public void deleteExternalComment(CoreSession session, String documentId, String entityId) {
        DocumentModel commentDoc = this.getExternalCommentModel(session, documentId, entityId);
        this.removeComment(session, commentDoc.getRef());
    }

    public void deleteComment(CoreSession s, String commentId) {
        this.removeComment(s, (DocumentRef)new IdRef(commentId));
    }

    public void deleteComment(DocumentModel doc, DocumentModel comment) {
        throw new UnsupportedOperationException(SERVICE_WITHOUT_IMPLEMENTATION_MESSAGE);
    }

    protected DocumentRef getLocationRefOfCommentCreation(CoreSession session, DocumentModel commentedDoc) {
        if (commentedDoc.hasSchema(COMMENT_NAME)) {
            return commentedDoc.getRef();
        }
        DocumentModel commentsFolder = session.newDocumentModel(commentedDoc.getRef(), "Comments", "CommentRoot");
        commentsFolder.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        commentsFolder = session.getOrCreateDocument(commentsFolder);
        session.save();
        return commentsFolder.getRef();
    }

    public boolean hasFeature(CommentManager.Feature feature) {
        switch (feature) {
            case COMMENTS_LINKED_WITH_PROPERTY: 
            case COMMENTS_ARE_SPECIAL_CHILDREN: {
                return true;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }

    @Override
    protected DocumentModel getTopLevelDocument(CoreSession session, DocumentModel commentDoc) {
        DocumentModel docModel = commentDoc;
        while (docModel.getParentRef() != null && (docModel.hasSchema(COMMENT_NAME) || "CommentRoot".equals(docModel.getType()))) {
            docModel = session.getDocument(docModel.getParentRef());
        }
        return docModel;
    }

    protected void checkCreateCommentPermissions(CoreSession session, DocumentRef documentRef) {
        try {
            if (!session.hasPermission(documentRef, "Read")) {
                throw new CommentSecurityException(String.format("The user %s can not create comments on document %s", session.getPrincipal().getName(), documentRef));
            }
        }
        catch (DocumentNotFoundException dnfe) {
            throw new CommentNotFoundException(String.format("The comment %s does not exist.", documentRef), (Throwable)dnfe);
        }
    }

    protected DocumentModel getExternalCommentModel(CoreSession session, String documentId, String entityId) {
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)session);
        PageProvider pageProvider = StringUtils.isBlank((CharSequence)documentId) ? ppService.getPageProvider(GET_COMMENT_PAGE_PROVIDER_NAME, Collections.emptyList(), Long.valueOf(1L), Long.valueOf(0L), props, new Object[]{entityId}) : ppService.getPageProvider(GET_EXTERNAL_COMMENT_PAGE_PROVIDER_NAME, Collections.emptyList(), Long.valueOf(1L), Long.valueOf(0L), props, new Object[]{documentId, entityId});
        List documents = pageProvider.getCurrentPage();
        if (documents.isEmpty()) {
            throw new CommentNotFoundException(String.format("The external comment %s does not exist.", entityId));
        }
        return (DocumentModel)documents.get(0);
    }

    protected void removeComment(CoreSession session, DocumentRef documentRef) {
        NuxeoPrincipal principal = session.getPrincipal();
        CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentRef ancestorRef = this.getTopLevelDocumentRef((CoreSession)s, documentRef);
            DocumentModel commentDoc = s.getDocument(documentRef);
            Serializable author = commentDoc.getPropertyValue("comment:author");
            if (!(principal.isAdministrator() || author.equals(principal.getName()) || s.hasPermission(principal, ancestorRef, "Everything"))) {
                throw new CommentSecurityException(String.format("The user %s cannot delete comments of the document %s", principal.getName(), ancestorRef));
            }
            Comment comment = (Comment)commentDoc.getAdapter(Comment.class);
            DocumentModel topLevelDoc = this.getTopLevelDocument((CoreSession)s, commentDoc);
            DocumentModel commentedDoc = this.getCommentedDocument((CoreSession)s, commentDoc);
            this.manageRelatedTextOfTopLevelDocument((CoreSession)s, topLevelDoc, comment.getId(), null);
            s.removeDocument(documentRef);
            this.notifyEvent((CoreSession)s, "commentRemoved", topLevelDoc, commentedDoc, commentDoc);
        });
    }

    protected DocumentModel getCommentDocumentModel(CoreSession session, String id) {
        try {
            return session.getDocument((DocumentRef)new IdRef(id));
        }
        catch (DocumentNotFoundException dnfe) {
            throw new CommentNotFoundException(String.format("The comment %s does not exist.", id), (Throwable)dnfe);
        }
        catch (DocumentSecurityException dse) {
            throw new CommentSecurityException(String.format("The user %s does not have access to the comment %s", session.getPrincipal().getName(), id), (Throwable)dse);
        }
    }

    protected PartialList<DocumentModel> getCommentDocuments(CoreSession session, String documentId, Long pageSize, Long currentPageIndex, boolean sortAscending) {
        try {
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(documentId));
            if (!doc.hasSchema(COMMENT_NAME) && session.hasChild(doc.getRef(), "Comments")) {
                DocumentModel commentsFolder = session.getChild(doc.getRef(), "Comments");
                documentId = commentsFolder.getId();
            }
            PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
            Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)session);
            List<SortInfo> sortInfos = Collections.singletonList(new SortInfo("comment:creationDate", sortAscending));
            PageProvider pageProvider = ppService.getPageProvider(GET_COMMENTS_FOR_DOCUMENT_PAGE_PROVIDER_NAME, sortInfos, pageSize, currentPageIndex, props, new Object[]{documentId});
            return new PartialList(pageProvider.getCurrentPage(), pageProvider.getResultsCount());
        }
        catch (DocumentNotFoundException dnfe) {
            return new PartialList(Collections.emptyList(), 0L);
        }
        catch (DocumentSecurityException dse) {
            throw new CommentSecurityException(String.format("The user %s does not have access to the comments of document %s", session.getPrincipal().getName(), documentId), (Throwable)dse);
        }
    }

    protected void manageRelatedTextOfTopLevelDocument(CoreSession session, DocumentModel topLevelDoc, String commentId, String commentText) {
        Objects.requireNonNull(topLevelDoc, "Top level document is required");
        topLevelDoc.addFacet("HasRelatedText");
        String relatedTextId = String.format(COMMENT_RELATED_TEXT_ID, commentId);
        List resources = (List)((Object)topLevelDoc.getPropertyValue("relatedtextresources"));
        Optional<Map> optional = resources.stream().filter(m -> relatedTextId.equals(m.get("relatedtextid"))).findAny();
        if (StringUtils.isEmpty((CharSequence)commentText)) {
            optional.ifPresent(resources::remove);
        } else {
            optional.ifPresentOrElse(map -> map.put("relatedtext", commentText), () -> resources.add(Map.of("relatedtextid", relatedTextId, "relatedtext", commentText)));
        }
        topLevelDoc.setPropertyValue("relatedtextresources", (Serializable)((Object)resources));
        topLevelDoc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        topLevelDoc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
        topLevelDoc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        session.saveDocument(topLevelDoc);
    }

    @Override
    protected DocumentModel getCommentedDocument(CoreSession session, DocumentModel commentDoc) {
        DocumentModel commentedDoc = session.getParentDocument(commentDoc.getRef());
        if ("CommentRoot".equals(commentedDoc.getType())) {
            commentedDoc = session.getDocument(commentedDoc.getParentRef());
        }
        return commentedDoc;
    }

    protected boolean hasComments(CoreSession session, DocumentModel document) {
        String query = String.format(QUERY_GET_COMMENTS_UUID_BY_COMMENT_ANCESTOR, document.getId());
        return !session.queryProjection(query, 1L, 0L).isEmpty();
    }

    protected boolean hasComments(CoreSession session, DocumentModel document, String user) {
        String query = String.format(QUERY_GET_COMMENTS_UUID_BY_COMMENT_ANCESTOR_AND_AUTHOR, document.getId(), user);
        return !session.queryProjection(query, 1L, 0L).isEmpty();
    }

    protected void handleNotificationAutoSubscriptions(CoreSession session, DocumentModel topLevelDoc, DocumentModel commentDoc) {
        if (((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanFalse(AUTOSUBSCRIBE_CONFIG_KEY)) {
            log.trace("autosubscription to new comments is disabled");
            return;
        }
        NuxeoPrincipal topLevelDocumentAuthor = this.getAuthor(topLevelDoc);
        if (!this.hasComments(session, topLevelDoc)) {
            this.subscribeToNotifications(topLevelDoc, topLevelDocumentAuthor);
        }
        NuxeoPrincipal commentAuthor = this.getAuthor(commentDoc);
        if (topLevelDocumentAuthor != null && topLevelDocumentAuthor.equals(commentAuthor)) {
            return;
        }
        if (commentAuthor != null && !this.hasComments(session, topLevelDoc, commentAuthor.getName())) {
            this.subscribeToNotifications(topLevelDoc, commentAuthor);
        }
    }

    protected void subscribeToNotifications(DocumentModel document, NuxeoPrincipal user) {
        if (user == null) {
            return;
        }
        String subscriber = "user:" + user.getName();
        NotificationManager notificationManager = (NotificationManager)Framework.getService(NotificationManager.class);
        if (notificationManager != null) {
            notificationManager.addSubscriptions(subscriber, document, Boolean.valueOf(false), user);
        }
    }
}

