/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.impl;

import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.impl.AbstractRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;

public abstract class LazyRendition
extends AbstractRendition
implements Rendition {
    public static final String EMPTY_MARKER = "empty=true";
    public static final String ERROR_MARKER = "error=true";
    public static final String STALE_MARKER = "stale=true";
    public static final String IN_PROGRESS_MARKER = "inprogress";
    protected List<Blob> blobs = null;

    public LazyRendition(RenditionDefinition definition) {
        super(definition);
    }

    @Override
    public Blob getBlob() {
        List<Blob> blobs = this.getBlobs();
        if (blobs != null && blobs.size() > 0) {
            return blobs.get(0);
        }
        return null;
    }

    @Override
    public List<Blob> getBlobs() {
        if (this.blobs == null) {
            this.blobs = this.computeRenditionBlobs();
        }
        return this.blobs;
    }

    @Override
    public boolean isCompleted() {
        Blob blob = this.getBlob();
        if (blob == null) {
            return true;
        }
        String mimeType = blob.getMimeType();
        return mimeType == null || !mimeType.contains(EMPTY_MARKER);
    }

    protected abstract List<Blob> computeRenditionBlobs();
}

