/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.Calendar;
import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;

@Operation(id="Document.ReplacePermission", category="Document", label="Replace Permission", description="Replace a given permission on the input document(s). Returns the document(s).")
public class ReplacePermission {
    public static final String ID = "Document.ReplacePermission";
    public static final String NOTIFY_KEY = "notify";
    public static final String COMMENT_KEY = "comment";
    @Context
    protected CoreSession session;
    @Param(name="username", alias={"user"}, description="ACE target user/group.")
    protected String user;
    @Param(name="permission", description="ACE permission.")
    String permission;
    @Param(name="acl", required=false, values={"local"}, description="ACL name.")
    String aclName = "local";
    @Param(name="begin", required=false, description="ACE begin date.")
    Calendar begin;
    @Param(name="end", required=false, description="ACE end date.")
    Calendar end;
    @Param(name="id", description="ACE id.")
    String id;
    @Param(name="notify", required=false, description="Notify the user or not")
    boolean notify = false;
    @Param(name="comment", required=false, description="Comment")
    String comment;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.replacePermission(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        DocumentModel doc = this.session.getDocument(docRef);
        this.replacePermission(doc);
        return doc;
    }

    protected void replacePermission(DocumentModel doc) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put(NOTIFY_KEY, this.notify);
        contextData.put(COMMENT_KEY, this.comment);
        ACE oldACE = ACE.fromId((String)this.id);
        ACE newACE = ACE.builder((String)this.user, (String)this.permission).creator(this.session.getPrincipal().getName()).begin(this.begin).end(this.end).contextData(contextData).build();
        this.session.replaceACE(doc.getRef(), this.aclName, oldACE, newACE);
    }
}

