/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class HighlightJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public HighlightJsonEnricher() {
        super("highlight");
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeArrayFieldStart("highlight");
        Map h = (Map)((Object)document.getContextData("highlight"));
        if (h != null) {
            for (String field : h.keySet()) {
                jg.writeStartObject();
                jg.writeStringField("field", field);
                jg.writeObjectField("segments", h.get(field));
                jg.writeEndObject();
            }
        }
        jg.writeEndArray();
    }
}

