/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ec.notification.NotificationImpl;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationRegistry;

public class NotificationRegistryImpl
implements NotificationRegistry {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NotificationRegistryImpl.class);
    private final Map<String, List<Notification>> notificationRegistry = new HashMap<String, List<Notification>>();
    private final List<Notification> notificationList = new ArrayList<Notification>();

    public void clear() {
        this.notificationRegistry.clear();
    }

    public void registerNotification(Notification notif, List<String> events) {
        if (notif.getName() == null) {
            log.error((Object)"Notifications contributions must have a name");
        }
        if (notif.getEnabled()) {
            NotificationImpl notification = new NotificationImpl(notif.getName(), notif.getTemplate(), notif.getChannel(), notif.getSubjectTemplate(), notif.getAutoSubscribed(), notif.getSubject(), notif.getAvailableIn(), notif.getLabel());
            if (notif.getTemplateExpr() != null) {
                notification.setTemplateExpr(notif.getTemplateExpr());
            }
            if (this.notificationList.contains(notification)) {
                this.unregisterNotification((Notification)notification);
            }
            this.notificationList.add((Notification)notification);
            if (events != null && !events.isEmpty()) {
                for (String event : events) {
                    List<Notification> regNotifs = this.getNotificationsForEvent(event);
                    if (regNotifs.contains(notification)) continue;
                    regNotifs.add((Notification)notification);
                }
            }
        } else {
            this.unregisterNotification(notif);
        }
    }

    public void unregisterNotification(Notification notif) {
        if (notif == null) {
            log.warn((Object)"Try to unregister a null notification, do nothing");
            return;
        }
        NotificationImpl notification = new NotificationImpl(notif.getName(), notif.getTemplate(), notif.getChannel(), notif.getSubjectTemplate(), notif.getAutoSubscribed(), notif.getSubject(), notif.getAvailableIn(), notif.getLabel());
        this.notificationList.remove(notification);
        this.notificationRegistry.values().forEach(notifications -> notifications.remove(notification));
    }

    public Set<String> getNotificationEventNames() {
        return this.notificationRegistry.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public List<Notification> getNotificationsForEvent(String eventId) {
        return this.notificationRegistry.computeIfAbsent(eventId, k -> new ArrayList());
    }

    public List<Notification> getNotifications() {
        return this.notificationList;
    }

    @Deprecated
    public Map<String, List<Notification>> getNotificationRegistry() {
        return this.notificationRegistry;
    }

    public List<Notification> getNotificationsForSubscriptions(String parentType) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification notification : this.notificationList) {
            if (notification.getAutoSubscribed()) continue;
            String type = notification.getAvailableIn();
            if (type == null || "all".equals(type) || "*".equals(type)) {
                result.add(notification);
                continue;
            }
            String[] types = type.replace(",", " ").split(" ");
            if (!Arrays.asList(types).contains(parentType)) continue;
            result.add(notification);
        }
        return result;
    }
}

