/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.http.handler.ResourceProxyRequestHandler;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.support.DataUriGenerator;
import ro.isdc.wro.util.WroUtil;

public class CssDataUriPreProcessor
extends AbstractCssUrlRewritingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssDataUriPreProcessor.class);
    public static final String ALIAS = "cssDataUri";
    private static final int SIZE_LIMIT = 32768;
    private DataUriGenerator dataUriGenerator;
    @Inject
    private UriLocatorFactory uriLocatorFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String replaceImageUrl(String cssUri, String imageUrl) {
        InputStream is;
        String result;
        block5: {
            Validate.notNull((Object)this.uriLocatorFactory);
            LOG.debug("replace url for image: {} from css: {}", (Object)imageUrl, (Object)cssUri);
            String cleanImageUrl = WroUtil.cleanImageUrl(imageUrl);
            String fileName = FilenameUtils.getName((String)imageUrl);
            String fullPath = cleanImageUrl;
            if (this.isImageUrlChangeRequired(cleanImageUrl)) {
                fullPath = WroUtil.getFullPath(cssUri) + cleanImageUrl;
            }
            result = imageUrl;
            is = null;
            try {
                is = this.uriLocatorFactory.locate(fullPath);
                String dataUri = this.getDataUriGenerator().generateDataURI(is, fileName);
                if (!this.isReplaceAccepted(dataUri)) break block5;
                result = dataUri;
                LOG.debug("dataUri replacement: {}", (Object)StringUtils.abbreviate((String)dataUri, (int)30));
            }
            catch (IOException e) {
                try {
                    LOG.warn("[FAIL] extract dataUri from: {}, because: {}. A possible cause: using CssUrlRewritingProcessor before CssDataUriPreProcessor.", (Object)fullPath, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return result;
    }

    private boolean isImageUrlChangeRequired(String imageUrl) {
        return !imageUrl.startsWith("http") && !ResourceProxyRequestHandler.isProxyUri(imageUrl);
    }

    protected boolean isReplaceAccepted(String dataUri) {
        try {
            byte[] bytes = dataUri.getBytes("UTF-8");
            boolean exceedLimit = bytes.length >= 32768;
            LOG.debug("dataUri size: {}KB, limit exceeded: {}", (Object)(bytes.length / 1024), (Object)exceedLimit);
            return !exceedLimit;
        }
        catch (UnsupportedEncodingException e) {
            throw new WroRuntimeException("Should never happen", e);
        }
    }

    @Override
    protected boolean isReplaceNeeded(String url) {
        return !DataUriGenerator.isDataUri(url.trim());
    }

    protected DataUriGenerator getDataUriGenerator() {
        if (this.dataUriGenerator == null) {
            this.dataUriGenerator = new DataUriGenerator();
        }
        return this.dataUriGenerator;
    }
}

