/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.service.Configuration;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;

public class VideoHelper {
    public static final Log log = LogFactory.getLog(VideoHelper.class);
    public static final String MISSING_PREVIEW_PICTURE = "preview/missing-video-preview.jpeg";
    public static final String FFMPEG_INFO_COMMAND_LINE = "ffmpeg-info";
    public static final int DEFAULT_MIN_DURATION_FOR_STORYBOARD = 10;
    public static final int DEFAULT_NUMBER_OF_THUMBNAILS = 9;
    protected static final List<Map<String, Object>> THUMBNAILS_VIEWS = new ArrayList<Map<String, Object>>();

    private VideoHelper() {
    }

    public static void updateStoryboard(DocumentModel docModel, Blob video) {
        if (video == null) {
            docModel.setPropertyValue("vid:storyboard", null);
            docModel.setPropertyValue("vid:info/duration", (Serializable)Integer.valueOf(0));
            return;
        }
        VideoService videoService = (VideoService)Framework.getService(VideoService.class);
        Configuration configuration = videoService.getConfiguration();
        VideoDocument videoDocument = (VideoDocument)docModel.getAdapter(VideoDocument.class);
        double duration = videoDocument.getVideo().getDuration();
        double storyboardMinDuration = 10.0;
        if (configuration != null) {
            storyboardMinDuration = configuration.getStoryboardMinDuration();
        }
        BlobHolder result = null;
        if (storyboardMinDuration >= 0.0 && duration >= storyboardMinDuration) {
            try {
                HashMap<String, Number> parameters = new HashMap<String, Number>();
                parameters.put("duration", duration);
                int numberOfThumbnails = 9;
                if (configuration != null) {
                    numberOfThumbnails = configuration.getStoryboardThumbnailCount();
                }
                parameters.put("thumbnail_number", numberOfThumbnails);
                parameters.put("original_width", videoDocument.getVideo().getWidth());
                parameters.put("original_height", videoDocument.getVideo().getHeight());
                result = ((ConversionService)Framework.getService(ConversionService.class)).convert("videoStoryboard", (BlobHolder)new SimpleBlobHolder(video), parameters);
            }
            catch (ConversionException e) {
                log.warn((Object)String.format("could not extract story board for document '%s' with video file '%s': %s", docModel.getTitle(), video.getFilename(), e.getMessage()));
                log.debug((Object)e, (Throwable)e);
                return;
            }
        }
        if (result != null) {
            List blobs = result.getBlobs();
            List comments = (List)((Object)result.getProperty("comments"));
            List timecodes = (List)((Object)result.getProperty("timecodes"));
            ArrayList storyboard = new ArrayList();
            for (int i = 0; i < blobs.size(); ++i) {
                HashMap<String, Serializable> item = new HashMap<String, Serializable>();
                item.put("comment", (Serializable)comments.get(i));
                item.put("timecode", (Serializable)timecodes.get(i));
                item.put("content", (Serializable)blobs.get(i));
                storyboard.add(item);
            }
            docModel.setPropertyValue("vid:storyboard", (Serializable)storyboard);
        }
    }

    public static void updatePreviews(DocumentModel docModel, Blob video, Double position, List<Map<String, Object>> templates) throws IOException {
        BlobHolder result;
        if (video == null) {
            docModel.setPropertyValue("picture:views", null);
            return;
        }
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("position", position);
        try {
            result = ((ConversionService)Framework.getService(ConversionService.class)).convert("videoScreenshot", (BlobHolder)new SimpleBlobHolder(video), parameters);
        }
        catch (ConversionException e) {
            log.warn((Object)String.format("could not extract screenshot from document '%s' with video file '%s': %s", docModel.getTitle(), video.getFilename(), e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            return;
        }
        if (result != null && result.getBlob() != null && result.getBlob().getLength() > 0L) {
            PictureResourceAdapter picture = (PictureResourceAdapter)docModel.getAdapter(PictureResourceAdapter.class);
            try {
                picture.fillPictureViews(result.getBlob(), result.getBlob().getFilename(), docModel.getTitle(), new ArrayList<Map<String, Object>>(templates));
            }
            catch (IOException e) {
                log.warn((Object)("failed to video compute previews for " + docModel.getTitle() + ": " + e.getMessage()));
            }
        }
        if (((List)docModel.getProperty("picture:views").getValue(List.class)).isEmpty()) {
            try (InputStream is = VideoHelper.class.getResourceAsStream("/preview/missing-video-preview.jpeg");){
                Blob blob = Blobs.createBlob((InputStream)is, (String)"image/jpeg");
                blob.setFilename(MISSING_PREVIEW_PICTURE.replace('/', '-'));
                PictureResourceAdapter picture = (PictureResourceAdapter)docModel.getAdapter(PictureResourceAdapter.class);
                picture.fillPictureViews(blob, blob.getFilename(), docModel.getTitle(), new ArrayList<Map<String, Object>>(templates));
            }
        }
    }

    public static void updatePreviews(DocumentModel docModel, Blob video) throws IOException {
        Double duration = (Double)docModel.getPropertyValue("vid:info/duration");
        double position = 0.0;
        if (duration != null) {
            VideoService videoService = (VideoService)Framework.getService(VideoService.class);
            Configuration configuration = videoService.getConfiguration();
            position = configuration != null ? duration * configuration.getPreviewScreenshotInDurationPercent() / 100.0 : duration * 0.1;
        }
        VideoHelper.updatePreviews(docModel, video, position, THUMBNAILS_VIEWS);
    }

    public static void updateVideoInfo(DocumentModel docModel, Blob video) {
        VideoInfo videoInfo = VideoHelper.getVideoInfo(video);
        if (videoInfo == null || video.getLength() == 0L) {
            docModel.setPropertyValue("vid:info", (Serializable)((Object)VideoInfo.EMPTY_INFO.toMap()));
            return;
        }
        docModel.setPropertyValue("vid:info", (Serializable)((Object)videoInfo.toMap()));
    }

    public static VideoInfo getVideoInfo(Blob video) {
        if (video == null || video.getLength() == 0L) {
            return null;
        }
        try {
            ExecResult result;
            try (CloseableFile cf = video.getCloseableFile("." + FilenameUtils.getExtension((String)video.getFilename()));){
                CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
                CmdParameters params = cles.getDefaultCmdParameters();
                params.addNamedParameter("inFilePath", cf.getFile().getAbsolutePath());
                result = cles.execCommand(FFMPEG_INFO_COMMAND_LINE, params);
            }
            if (!result.isSuccessful()) {
                throw result.getError();
            }
            return VideoInfo.fromFFmpegOutput((List)result.getOutput());
        }
        catch (IOException | CommandException | CommandNotAvailable e) {
            throw new NuxeoException(e);
        }
    }

    static {
        LinkedHashMap<String, Object> thumbnailView = new LinkedHashMap<String, Object>();
        thumbnailView.put("title", "Small");
        thumbnailView.put("maxsize", 350L);
        THUMBNAILS_VIEWS.add(thumbnailView);
        HashMap<String, Object> staticPlayerView = new HashMap<String, Object>();
        staticPlayerView.put("title", "StaticPlayerView");
        staticPlayerView.put("maxsize", 1200L);
        THUMBNAILS_VIEWS.add(staticPlayerView);
    }
}

