/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public class PDFEncryption {
    private Blob pdfBlob;
    private PDDocument pdfDoc;
    private static final List<Integer> ALLOWED_LENGTH = Arrays.asList(40, 128);
    private static final int DEFAULT_KEYLENGTH = 128;
    private int keyLength = 128;
    private String originalOwnerPwd;
    private String ownerPwd;
    private String userPwd;

    public PDFEncryption(Blob inBlob) {
        this.pdfBlob = inBlob;
    }

    public Blob encryptReadOnly() {
        AccessPermission ap = new AccessPermission();
        ap.setCanPrint(true);
        ap.setCanModify(false);
        ap.setCanExtractContent(true);
        ap.setCanModifyAnnotations(false);
        ap.setCanFillInForm(false);
        ap.setCanExtractForAccessibility(true);
        ap.setCanAssembleDocument(false);
        ap.setCanPrintDegraded(true);
        return this.encrypt(ap);
    }

    public Blob encrypt(AccessPermission inPerm) {
        if (!ALLOWED_LENGTH.contains(this.keyLength)) {
            throw new NuxeoException(this.keyLength + " is not an allowed length for the encrytion key");
        }
        this.ownerPwd = StringUtils.isBlank((CharSequence)this.ownerPwd) ? this.originalOwnerPwd : this.ownerPwd;
        try {
            StandardProtectionPolicy spp = new StandardProtectionPolicy(this.ownerPwd, this.userPwd, inPerm);
            spp.setEncryptionKeyLength(this.keyLength);
            this.pdfDoc = PDDocument.load((File)this.pdfBlob.getFile(), (String)this.originalOwnerPwd);
            this.pdfDoc.protect((ProtectionPolicy)spp);
            Blob result = Blobs.createBlobWithExtension((String)".pdf");
            this.pdfDoc.save(result.getFile());
            result.setMimeType("application/pdf");
            if (StringUtils.isNotBlank((CharSequence)this.pdfBlob.getFilename())) {
                result.setFilename(this.pdfBlob.getFilename());
            }
            this.pdfDoc.close();
            FileBlob fb = new FileBlob(result.getFile());
            fb.setMimeType("application/pdf");
            return fb;
        }
        catch (Exception e) {
            throw new NuxeoException("Failed to encrypt the PDF", (Throwable)e);
        }
    }

    public Blob removeEncryption() {
        try {
            String password = StringUtils.isBlank((CharSequence)this.originalOwnerPwd) ? this.ownerPwd : this.originalOwnerPwd;
            this.pdfDoc = PDDocument.load((File)this.pdfBlob.getFile(), (String)password);
            if (!this.pdfDoc.isEncrypted()) {
                this.pdfDoc.close();
                return this.pdfBlob;
            }
            this.pdfDoc.setAllSecurityToBeRemoved(true);
            Blob result = Blobs.createBlobWithExtension((String)".pdf");
            this.pdfDoc.save(result.getFile());
            result.setMimeType("application/pdf");
            if (StringUtils.isNotBlank((CharSequence)this.pdfBlob.getFilename())) {
                result.setFilename(this.pdfBlob.getFilename());
            }
            this.pdfDoc.close();
            FileBlob fb = new FileBlob(result.getFile());
            fb.setMimeType("application/pdf");
            return fb;
        }
        catch (Exception e) {
            throw new NuxeoException("Failed to remove encryption of the PDF", (Throwable)e);
        }
    }

    public void setKeyLength(int keyLength) throws NuxeoException {
        if (keyLength < 1) {
            keyLength = 128;
        } else if (!ALLOWED_LENGTH.contains(keyLength)) {
            throw new NuxeoException("Cannot use " + keyLength + " is not allowed as lenght for the encrytion key");
        }
        this.keyLength = keyLength;
    }

    public void setOriginalOwnerPwd(String originalOwnerPwd) {
        this.originalOwnerPwd = originalOwnerPwd;
    }

    public void setOwnerPwd(String ownerPwd) {
        this.ownerPwd = ownerPwd;
    }

    public void setUserPwd(String userPwd) {
        this.userPwd = userPwd;
    }
}

