/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public class PDFUtils {
    public static final String DEFAULT_BLOB_XPATH = "file:content";
    protected static final Map<String, PDType1Font> STANDARD_14;

    public static PDType1Font getStandardType1Font(String name) {
        return STANDARD_14.get(name);
    }

    public static int[] hex255ToRGB(String inHex) {
        int[] result = new int[]{0, 0, 0};
        if (inHex != null && (inHex = inHex.toLowerCase().replace("#", "").replace("0x", "")).length() >= 6) {
            for (int i = 0; i < 3; ++i) {
                result[i] = Integer.parseInt(inHex.substring(i * 2, i * 2 + 2), 16);
            }
        }
        return result;
    }

    public static PDDocument load(Blob inBlob, String inPwd) throws NuxeoException {
        PDDocument pdfDoc;
        try {
            pdfDoc = PDDocument.load((InputStream)inBlob.getStream(), (String)inPwd);
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to load the PDF", (Throwable)e);
        }
        return pdfDoc;
    }

    public static FileBlob saveInTempFile(PDDocument inPdfDoc) throws IOException {
        return PDFUtils.saveInTempFile(inPdfDoc, null);
    }

    public static FileBlob saveInTempFile(PDDocument inPdfDoc, String inFileName) throws IOException {
        Blob result = Blobs.createBlobWithExtension((String)".pdf");
        File resultFile = result.getFile();
        inPdfDoc.save(result.getFile());
        result.setMimeType("application/pdf");
        if (StringUtils.isNotBlank((CharSequence)inFileName)) {
            result.setFilename(inFileName);
        }
        FileBlob fb = new FileBlob(resultFile);
        fb.setMimeType("application/pdf");
        return fb;
    }

    public static void setInfos(PDDocument inPdfDoc, String inTitle, String inSubject, String inAuthor) {
        if (inTitle != null && inTitle.isEmpty()) {
            inTitle = null;
        }
        if (inSubject != null && inSubject.isEmpty()) {
            inSubject = null;
        }
        if (inAuthor != null && inAuthor.isEmpty()) {
            inAuthor = null;
        }
        if (inTitle != null || inAuthor != null || inSubject != null) {
            PDDocumentInformation docInfo = inPdfDoc.getDocumentInformation();
            if (inTitle != null) {
                docInfo.setTitle(inTitle);
            }
            if (inSubject != null) {
                docInfo.setSubject(inSubject);
            }
            if (inAuthor != null) {
                docInfo.setAuthor(inAuthor);
            }
            inPdfDoc.setDocumentInformation(docInfo);
        }
    }

    public static String checkXPath(String inXPath) {
        if (StringUtils.isBlank((CharSequence)inXPath)) {
            inXPath = DEFAULT_BLOB_XPATH;
        }
        return inXPath;
    }

    public static void closeSilently(PDDocument ... inPdfDocs) {
        for (PDDocument doc : inPdfDocs) {
            if (doc == null) continue;
            try {
                doc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        HashMap<String, PDType1Font> map = new HashMap<String, PDType1Font>();
        for (PDType1Font font : List.of(PDType1Font.TIMES_ROMAN, PDType1Font.TIMES_BOLD, PDType1Font.TIMES_ITALIC, PDType1Font.TIMES_BOLD_ITALIC, PDType1Font.HELVETICA, PDType1Font.HELVETICA_BOLD, PDType1Font.HELVETICA_OBLIQUE, PDType1Font.HELVETICA_BOLD_OBLIQUE, PDType1Font.COURIER, PDType1Font.COURIER_BOLD, PDType1Font.COURIER_OBLIQUE, PDType1Font.COURIER_BOLD_OBLIQUE, PDType1Font.SYMBOL, PDType1Font.ZAPF_DINGBATS)) {
            map.put(font.getBaseFont(), font);
        }
        STANDARD_14 = Collections.unmodifiableMap(map);
    }
}

