/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class JSONWire
extends TextWire {
    static final BytesStore COMMA = BytesStore.from((CharSequence)",");

    public JSONWire(@NotNull Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
    }

    public JSONWire(@NotNull Bytes bytes) {
        this(bytes, false);
    }

    @NotNull
    public static JSONWire from(@NotNull String text) {
        return new JSONWire(Bytes.from((String)text));
    }

    public static String asText(@NotNull Wire wire) {
        long pos = wire.bytes().readPosition();
        JSONWire tw = new JSONWire((Bytes)NativeBytes.nativeBytes());
        wire.copyTo(tw);
        wire.bytes().readPosition(pos);
        return tw.toString();
    }

    @Override
    @NotNull
    protected TextWire.TextValueOut createValueOut() {
        return new JSONValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new JSONValueIn();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Quotes needsQuotes(@NotNull CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch >= ' ') continue;
            return Quotes.DOUBLE;
        }
        return Quotes.NONE;
    }

    @Override
    void escape(@NotNull CharSequence s) {
        this.bytes.writeUnsignedByte(34);
        if (this.needsQuotes(s) == Quotes.NONE) {
            this.bytes.appendUtf8(s);
        } else {
            this.escape0(s, Quotes.DOUBLE);
        }
        this.bytes.writeUnsignedByte(34);
    }

    @Override
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumePadding();
        int code = this.peekCode();
        if (code == 125) {
            sb.setLength(0);
            return sb;
        }
        if (code == 123) {
            if (this.valueIn.stack.level > 0) {
                throw new IORuntimeException("Expected field name, but got { at " + this.bytes.toDebugString(64L));
            }
            this.valueIn.pushState();
            this.bytes.readSkip(1L);
        }
        return super.readField(sb);
    }

    class JSONValueIn
    extends TextWire.TextValueIn {
        JSONValueIn() {
            super(JSONWire.this);
        }

        @Override
        public String text() {
            String text = super.text();
            return text == null || text.equals("null") ? null : text;
        }
    }

    class JSONValueOut
    extends TextWire.TextValueOut {
        JSONValueOut() {
            super(JSONWire.this);
        }

        @Override
        @NotNull
        public String nullOut() {
            return "null";
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            return this.text(type);
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            return this;
        }

        @Override
        public void elementSeparator() {
            this.sep = COMMA;
        }

        @Override
        protected void popState() {
        }

        @Override
        protected void pushState() {
            this.leaf = true;
        }

        @Override
        protected void afterOpen() {
            this.sep = TextWire.EMPTY;
        }

        @Override
        protected void afterClose() {
        }

        @Override
        protected void addNewLine(long pos) {
        }

        @Override
        protected void newLine() {
        }

        @Override
        protected void endField() {
            this.sep = COMMA;
        }

        @Override
        protected void fieldValueSeperator() {
            JSONWire.this.bytes.writeUnsignedByte(58);
        }

        @Override
        public void writeComment(@NotNull CharSequence s) {
        }

        @Override
        protected String doubleToString(double d) {
            return Double.isNaN(d) ? "null" : super.doubleToString(d);
        }

        @Override
        protected String floatToString(float f) {
            return Float.isNaN(f) ? "null" : super.floatToString(f);
        }

        @Override
        @NotNull
        public WireOut rawText(CharSequence value) {
            JSONWire.this.bytes.writeByte((byte)34);
            WireOut wireOut = super.rawText(value);
            JSONWire.this.bytes.writeByte((byte)34);
            return wireOut;
        }
    }
}

