/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.KeyStrategy;

public class KeyStrategyDocId
implements KeyStrategy {
    private static final KeyStrategyDocId INSTANCE = new KeyStrategyDocId();
    protected static final String MAIN_BLOB_XPATH = "content";

    public static KeyStrategyDocId instance() {
        return INSTANCE;
    }

    @Override
    public boolean useDeDuplication() {
        return false;
    }

    @Override
    public String getDigestFromKey(String key) {
        return null;
    }

    @Override
    public BlobWriteContext getBlobWriteContext(BlobContext blobContext) {
        String xpath = blobContext.xpath;
        if (!MAIN_BLOB_XPATH.equals(xpath)) {
            throw new NuxeoException("Cannot store blob with xpath '" + xpath + "' in record blob provider");
        }
        String key = this.getKey(blobContext);
        return new BlobWriteContext(blobContext, null, () -> key, this);
    }

    protected String getKey(BlobContext blobContext) {
        String docId = blobContext.docId;
        if (docId == null) {
            throw new NuxeoException("Missing docId for key strategy");
        }
        return docId;
    }

    public boolean equals(Object obj) {
        return obj instanceof KeyStrategyDocId;
    }

    public int hashCode() {
        return 0;
    }
}

