/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.avro;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.avro.NonNullValueException;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.avro.AvroMapper;
import org.nuxeo.runtime.avro.AvroService;

public class PropertyMapper
extends AvroMapper<Property, Object> {
    protected static final Map<String, Class<?>> MAPPING = Collections.singletonMap("content", BlobProperty.class);

    public PropertyMapper(AvroService service) {
        super(service);
    }

    public Object fromAvro(Schema schema, Object input) {
        switch (schema.getType()) {
            case NULL: {
                if (input == null) {
                    return null;
                }
                throw new NonNullValueException();
            }
            case UNION: {
                for (Schema sub : schema.getTypes()) {
                    try {
                        return this.service.fromAvro(sub, Property.class, input);
                    }
                    catch (NonNullValueException nonNullValueException) {
                    }
                }
                throw new RuntimeServiceException("Cannot map from value " + schema.getType());
            }
            case RECORD: {
                GenericRecord record = (GenericRecord)input;
                List fields = schema.getFields();
                HashMap<String, Object> data = new HashMap<String, Object>(fields.size());
                for (Schema.Field field : fields) {
                    String propertyName = this.service.decodeName(field.name());
                    Class<Property> clazz = MAPPING.getOrDefault(propertyName, Property.class);
                    Object value = this.service.fromAvro(field.schema(), clazz, record.get(field.name()));
                    data.put(propertyName, value);
                }
                return data;
            }
            case ARRAY: {
                GenericData.Array array = (GenericData.Array)input;
                ArrayList<Object> list = new ArrayList<Object>(array.size());
                for (Object element : array) {
                    list.add(this.service.fromAvro(schema.getElementType(), Property.class, element));
                }
                return list;
            }
            case LONG: {
                if ("timestamp-millis".equals(this.getLogicalType(schema))) {
                    return new Date((Long)input);
                }
                return input;
            }
            case INT: 
            case FLOAT: 
            case STRING: 
            case DOUBLE: 
            case BOOLEAN: {
                return input;
            }
            case BYTES: {
                return Blobs.createBlob((byte[])((ByteBuffer)input).array());
            }
        }
        throw new RuntimeServiceException("Cannot map from value " + schema.getType());
    }

    public Object toAvro(Schema schema, Property input) {
        switch (schema.getType()) {
            case NULL: {
                if (input.getValue() == null) {
                    return null;
                }
                throw new NonNullValueException();
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    try {
                        return this.service.toAvro(s, (Object)input);
                    }
                    catch (NonNullValueException nonNullValueException) {
                    }
                }
                throw new RuntimeServiceException("Cannot map value to " + schema.getType());
            }
            case RECORD: {
                if (input.isComplex()) {
                    GenericData.Record record = new GenericData.Record(schema);
                    for (Schema.Field f : schema.getFields()) {
                        record.put(f.name(), this.service.toAvro(f.schema(), (Object)input.get(this.service.decodeName(f.name()))));
                    }
                    return record;
                }
                throw new RuntimeServiceException("Cannot map value to " + schema.getType());
            }
            case ARRAY: {
                if (input.getType().isListType()) {
                    Collection<Object> objects;
                    if (((ListType)input.getType()).isArray()) {
                        objects = Arrays.asList((Object[])input.getValue());
                    } else {
                        ListProperty list = (ListProperty)input;
                        objects = list.stream().map(p -> this.service.toAvro(schema.getElementType(), p)).collect(Collectors.toList());
                    }
                    return new GenericData.Array(schema, objects);
                }
                throw new RuntimeServiceException("Cannot map value to " + schema.getType());
            }
            case INT: 
            case FLOAT: 
            case STRING: 
            case DOUBLE: 
            case BOOLEAN: {
                if (input.isScalar()) {
                    return input.getValue();
                }
                throw new RuntimeServiceException("Cannot map value to " + schema.getType());
            }
            case LONG: {
                if (input.isScalar()) {
                    if ("timestamp-millis".equals(this.getLogicalType(schema))) {
                        GregorianCalendar cal = (GregorianCalendar)input.getValue();
                        return cal.toInstant().toEpochMilli();
                    }
                    return input.getValue();
                }
                throw new RuntimeServiceException("Cannot map value to " + schema.getType());
            }
        }
        throw new RuntimeServiceException("Cannot map value to " + schema.getType());
    }
}

