/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.AsyncEventExecutor;
import org.nuxeo.ecm.core.event.impl.AsyncWaitHook;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventBundleImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerList;
import org.nuxeo.ecm.core.event.impl.PostCommitEventExecutor;
import org.nuxeo.ecm.core.event.impl.ShallowEvent;
import org.nuxeo.ecm.core.event.pipe.EventPipeDescriptor;
import org.nuxeo.ecm.core.event.pipe.EventPipeRegistry;
import org.nuxeo.ecm.core.event.pipe.dispatch.EventBundleDispatcher;
import org.nuxeo.ecm.core.event.pipe.dispatch.EventDispatcherDescriptor;
import org.nuxeo.ecm.core.event.pipe.dispatch.EventDispatcherRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class EventServiceImpl
implements EventService,
EventServiceAdmin,
Synchronization {
    public static final VMID VMID = new VMID();
    private static final Log log = LogFactory.getLog(EventServiceImpl.class);
    protected static final ThreadLocal<CompositeEventBundle> threadBundles = new ThreadLocal<CompositeEventBundle>(){

        @Override
        protected CompositeEventBundle initialValue() {
            return new CompositeEventBundle();
        }
    };
    protected final EventListenerList listenerDescriptors;
    protected PostCommitEventExecutor postCommitExec;
    protected volatile AsyncEventExecutor asyncExec;
    protected final List<AsyncWaitHook> asyncWaitHooks = new CopyOnWriteArrayList<AsyncWaitHook>();
    protected boolean blockAsyncProcessing = false;
    protected boolean blockSyncPostCommitProcessing = false;
    protected boolean bulkModeEnabled = false;
    protected EventPipeRegistry registeredPipes = new EventPipeRegistry();
    protected EventDispatcherRegistry dispatchers = new EventDispatcherRegistry();
    protected EventBundleDispatcher pipeDispatcher;

    public EventServiceImpl() {
        this.listenerDescriptors = new EventListenerList();
        this.postCommitExec = new PostCommitEventExecutor();
        this.asyncExec = new AsyncEventExecutor();
    }

    public void init() {
        List<EventPipeDescriptor> pipes;
        this.asyncExec.init();
        EventDispatcherDescriptor dispatcherDescriptor = this.dispatchers.getDispatcherDescriptor();
        if (dispatcherDescriptor != null && !(pipes = this.registeredPipes.getPipes()).isEmpty()) {
            this.pipeDispatcher = dispatcherDescriptor.getInstance();
            this.pipeDispatcher.init(pipes, dispatcherDescriptor.getParameters());
        }
    }

    public EventBundleDispatcher getEventBundleDispatcher() {
        return this.pipeDispatcher;
    }

    public void shutdown(long timeoutMillis) throws InterruptedException {
        this.postCommitExec.shutdown(timeoutMillis);
        Set notTerminated = this.asyncWaitHooks.stream().filter(hook -> !hook.shutdown()).collect(Collectors.toSet());
        if (!notTerminated.isEmpty()) {
            throw new RuntimeException("Asynch services are still running : " + notTerminated);
        }
        if (!this.asyncExec.shutdown(timeoutMillis)) {
            throw new RuntimeException("Async executor is still running, timeout expired");
        }
        if (this.pipeDispatcher != null) {
            this.pipeDispatcher.shutdown();
        }
    }

    public void registerForAsyncWait(AsyncWaitHook callback) {
        this.asyncWaitHooks.add(callback);
    }

    public void unregisterForAsyncWait(AsyncWaitHook callback) {
        this.asyncWaitHooks.remove(callback);
    }

    @Override
    public void waitForAsyncCompletion() {
        this.waitForAsyncCompletion(Long.MAX_VALUE);
    }

    @Override
    public void waitForAsyncCompletion(long timeout) {
        Set notCompleted = this.asyncWaitHooks.stream().filter(hook -> !hook.waitForAsyncCompletion()).collect(Collectors.toSet());
        if (!notCompleted.isEmpty()) {
            throw new RuntimeException("Async tasks are still running : " + notCompleted);
        }
        try {
            if (!this.asyncExec.waitForCompletion(timeout)) {
                throw new RuntimeException("Async event listeners thread pool is not terminated");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (this.pipeDispatcher != null) {
            try {
                this.pipeDispatcher.waitForCompletion(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addEventListener(EventListenerDescriptor listener) {
        this.listenerDescriptors.add(listener);
        log.debug((Object)("Registered event listener: " + listener.getName()));
    }

    public void addEventPipe(EventPipeDescriptor pipeDescriptor) {
        this.registeredPipes.addContribution(pipeDescriptor);
        log.debug((Object)("Registered event pipe: " + pipeDescriptor.getName()));
    }

    public void addEventDispatcher(EventDispatcherDescriptor dispatcherDescriptor) {
        this.dispatchers.addContrib(dispatcherDescriptor);
        log.debug((Object)("Registered event dispatcher: " + dispatcherDescriptor.getName()));
    }

    @Override
    public void removeEventListener(EventListenerDescriptor listener) {
        this.listenerDescriptors.removeDescriptor(listener);
        log.debug((Object)("Unregistered event listener: " + listener.getName()));
    }

    public void removeEventPipe(EventPipeDescriptor pipeDescriptor) {
        this.registeredPipes.removeContribution(pipeDescriptor);
        log.debug((Object)("Unregistered event pipe: " + pipeDescriptor.getName()));
    }

    public void removeEventDispatcher(EventDispatcherDescriptor dispatcherDescriptor) {
        this.dispatchers.removeContrib(dispatcherDescriptor);
        log.debug((Object)("Unregistered event dispatcher: " + dispatcherDescriptor.getName()));
    }

    @Override
    public void fireEvent(String name, EventContext context) {
        this.fireEvent(new EventImpl(name, context));
    }

    @Override
    public void fireEvent(Event event) {
        String ename = event.getName();
        EventStats stats = (EventStats)Framework.getService(EventStats.class);
        Tracer tracer = Tracing.getTracer();
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledInlineListenersDescriptors()) {
            if (!desc.acceptEvent(ename)) continue;
            try {
                long t0 = System.currentTimeMillis();
                desc.asEventListener().handleEvent(event);
                long elapsed = System.currentTimeMillis() - t0;
                this.traceAddAnnotation(event, tracer, elapsed, desc.getName());
                if (stats != null) {
                    stats.logSyncExec(desc, elapsed);
                }
                if (!event.isCanceled()) continue;
                return;
            }
            catch (ConcurrentUpdateException e) {
                throw e;
            }
            catch (RuntimeException e) {
                String message = "Exception during " + desc.getName() + " sync listener execution, ";
                if (event.isBubbleException()) {
                    message = message + "other listeners will be ignored";
                } else if (event.isMarkedForRollBack()) {
                    message = message + "transaction will be rolled back";
                    if (event.getRollbackMessage() != null) {
                        message = message + " (" + event.getRollbackMessage() + ")";
                    }
                } else {
                    message = message + "continuing to run other listeners";
                }
                tracer.getCurrentSpan().addAnnotation("EventService#fireEvent " + event.getName() + ": " + message);
                if (e instanceof RecoverableClientException) {
                    log.info((Object)(message + "\n" + e.getMessage()));
                    log.debug((Object)message, (Throwable)e);
                } else {
                    log.error((Object)message, (Throwable)e);
                }
                if (TransactionHelper.isTransactionMarkedRollback()) {
                    throw e;
                }
                if (event.isBubbleException()) {
                    throw e;
                }
                if (!event.isMarkedForRollBack()) continue;
                Exception ee = event.getRollbackException() != null ? event.getRollbackException() : e;
                throw new RuntimeException(message, ee);
            }
        }
        if (!event.isInline()) {
            ShallowEvent shallowEvent = ShallowEvent.create(event);
            if (event.isImmediate()) {
                EventBundleImpl b = new EventBundleImpl();
                b.push(shallowEvent);
                tracer.getCurrentSpan().addAnnotation("EventService#fireEvent firing immediate: " + event.getName());
                this.fireEventBundle(b);
            } else {
                this.recordEvent(shallowEvent);
            }
        }
    }

    protected void traceAddAnnotation(Event event, Tracer tracer, long elapsed, String listener) {
        DocumentEventContext docContext;
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        attributes.put("event", AttributeValue.stringAttributeValue((String)event.getName()));
        attributes.put("listener", AttributeValue.stringAttributeValue((String)listener));
        attributes.put("duration_ms", AttributeValue.longAttributeValue((long)elapsed));
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext && (docContext = (DocumentEventContext)eventContext).getSourceDocument() != null) {
            String id;
            Path docPath = docContext.getSourceDocument().getPath();
            if (docPath != null) {
                attributes.put("doc", AttributeValue.stringAttributeValue((String)docPath.toString()));
            }
            if ((id = docContext.getSourceDocument().getId()) != null) {
                attributes.put("doc_id", AttributeValue.stringAttributeValue((String)id));
            }
        }
        tracer.getCurrentSpan().addAnnotation("EventService#fireEvent Event fired", attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEventBundle(EventBundle event) {
        Span span = Tracing.getTracer().getCurrentSpan();
        span.addAnnotation("EventService#fireEventBundle");
        try {
            List<EventListenerDescriptor> postCommitSync = this.listenerDescriptors.getEnabledSyncPostCommitListenersDescriptors();
            List<EventListenerDescriptor> postCommitAsync = this.listenerDescriptors.getEnabledAsyncPostCommitListenersDescriptors();
            if (this.bulkModeEnabled) {
                List<Object> listeners = new ArrayList();
                if (!this.blockSyncPostCommitProcessing) {
                    listeners = postCommitSync;
                }
                if (!this.blockAsyncProcessing) {
                    listeners.addAll(postCommitAsync);
                }
                if (!listeners.isEmpty()) {
                    this.postCommitExec.runBulk(listeners, event);
                }
                return;
            }
            if (this.blockSyncPostCommitProcessing) {
                log.debug((Object)"Dropping PostCommit handler execution");
            } else if (!postCommitSync.isEmpty()) {
                this.postCommitExec.run(postCommitSync, event);
            }
            if (this.blockAsyncProcessing) {
                log.debug((Object)"Dopping bundle");
                return;
            }
            if (this.pipeDispatcher == null) {
                this.asyncExec.run(postCommitAsync, event);
            } else {
                this.pipeDispatcher.sendEventBundle(event);
            }
        }
        finally {
            span.addAnnotation("EventService#fireEventBundle.done");
        }
    }

    @Override
    public void fireEventBundleSync(EventBundle event) {
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledSyncPostCommitListenersDescriptors()) {
            desc.asPostCommitListener().handleEvent(event);
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledAsyncPostCommitListenersDescriptors()) {
            desc.asPostCommitListener().handleEvent(event);
        }
    }

    @Override
    public List<EventListener> getEventListeners() {
        return this.listenerDescriptors.getInLineListeners();
    }

    @Override
    public List<PostCommitEventListener> getPostCommitEventListeners() {
        ArrayList<PostCommitEventListener> result = new ArrayList<PostCommitEventListener>();
        result.addAll(this.listenerDescriptors.getSyncPostCommitListeners());
        result.addAll(this.listenerDescriptors.getAsyncPostCommitListeners());
        return result;
    }

    public EventListenerList getEventListenerList() {
        return this.listenerDescriptors;
    }

    @Override
    public EventListenerDescriptor getEventListener(String name) {
        return this.listenerDescriptors.getDescriptor(name);
    }

    @Override
    public EventListenerList getListenerList() {
        return this.listenerDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListenerEnabledFlag(String listenerName, boolean enabled) {
        if (!this.listenerDescriptors.hasListener(listenerName)) {
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getAsyncPostCommitListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getSyncPostCommitListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getInlineListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
    }

    @Override
    public int getActiveThreadsCount() {
        return this.asyncExec.getActiveCount();
    }

    @Override
    public int getEventsInQueueCount() {
        return this.asyncExec.getUnfinishedCount();
    }

    @Override
    public boolean isBlockAsyncHandlers() {
        return this.blockAsyncProcessing;
    }

    @Override
    public boolean isBlockSyncPostCommitHandlers() {
        return this.blockSyncPostCommitProcessing;
    }

    @Override
    public void setBlockAsyncHandlers(boolean blockAsyncHandlers) {
        this.blockAsyncProcessing = blockAsyncHandlers;
    }

    @Override
    public void setBlockSyncPostCommitHandlers(boolean blockSyncPostComitHandlers) {
        this.blockSyncPostCommitProcessing = blockSyncPostComitHandlers;
    }

    @Override
    public boolean isBulkModeEnabled() {
        return this.bulkModeEnabled;
    }

    @Override
    public void setBulkModeEnabled(boolean bulkModeEnabled) {
        this.bulkModeEnabled = bulkModeEnabled;
    }

    protected void recordEvent(Event event) {
        CompositeEventBundle b = threadBundles.get();
        b.push(event);
        if (TransactionHelper.isTransactionActive()) {
            if (!b.registeredSynchronization) {
                try {
                    TransactionHelper.lookupTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
                }
                catch (NamingException | RollbackException | SystemException e) {
                    throw new RuntimeException("Cannot register Synchronization", e);
                }
                b.registeredSynchronization = true;
            }
        } else if (event.isCommitEvent()) {
            this.handleTxCommited();
        }
    }

    public void beforeCompletion() {
        Span span = Tracing.getTracer().getCurrentSpan();
        span.addAnnotation("EventService#beforeCompletion");
    }

    public void afterCompletion(int status) {
        Span span = Tracing.getTracer().getCurrentSpan();
        if (status == 3) {
            span.addAnnotation("EventService#afterCompletion committed");
            this.handleTxCommited();
        } else if (status == 4) {
            span.addAnnotation("EventService#afterCompletion ROLLBACK");
            this.handleTxRollbacked();
        } else {
            log.error((Object)("Unexpected afterCompletion status: " + status));
        }
        span.addAnnotation("EventService#afterCompletion.done");
    }

    protected void handleTxRollbacked() {
        threadBundles.remove();
    }

    protected void handleTxCommited() {
        CompositeEventBundle b = threadBundles.get();
        threadBundles.remove();
        for (EventBundle bundle : b.byRepository.values()) {
            try {
                this.fireEventBundle(bundle);
            }
            catch (NuxeoException e) {
                log.error((Object)("Error while processing " + bundle), (Throwable)e);
            }
        }
    }

    private static class CompositeEventBundle {
        boolean registeredSynchronization;
        final Map<String, EventBundle> byRepository = new HashMap<String, EventBundle>();

        private CompositeEventBundle() {
        }

        void push(Event event) {
            String repositoryName = event.getContext().getRepositoryName();
            if (!this.byRepository.containsKey(repositoryName)) {
                this.byRepository.put(repositoryName, new EventBundleImpl());
            }
            this.byRepository.get(repositoryName).push(event);
        }
    }
}

