/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import io.opencensus.trace.Tracing;
import io.opencensus.trace.config.TraceConfig;
import io.opencensus.trace.config.TraceParams;
import io.opencensus.trace.samplers.Samplers;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsReporter;

public abstract class AbstractMetricsReporter
implements MetricsReporter {
    public static final String URL_OPTION = "url";
    public static final String TIMEOUT_OPTION = "timeout";
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    public static final String SERVICE_OPTION = "service";
    public static final String DEFAULT_SERVICE = "nuxeo";
    public static final String MAX_ATTRIBUTES_OPTION = "maxAttributes";
    public static final String DEFAULT_MAX_ATTRIBUTES = "128";
    public static final String MAX_ANNOTATIONS_OPTION = "maxAnnotations";
    public static final String DEFAULT_MAX_ANNOTATIONS = "128";
    public static final String SAMPLER_PROB_OPTION = "samplerProbability";
    public static final String DEFAULT_SAMPLER_PROB = "0.1";
    protected Map<String, String> options;
    protected long pollInterval;

    public void enableTracing() {
        TraceConfig traceConfig = Tracing.getTraceConfig();
        TraceParams activeTraceParams = traceConfig.getActiveTraceParams();
        TraceParams.Builder builder = activeTraceParams.toBuilder();
        int maxAttributes = Integer.parseInt(this.options.getOrDefault(MAX_ATTRIBUTES_OPTION, "128"));
        int maxAnnotations = Integer.parseInt(this.options.getOrDefault(MAX_ANNOTATIONS_OPTION, "128"));
        builder.setMaxNumberOfAttributes(maxAttributes).setMaxNumberOfAnnotations(maxAnnotations);
        float samplerProbability = Float.parseFloat(this.options.getOrDefault(SAMPLER_PROB_OPTION, DEFAULT_SAMPLER_PROB));
        if ((double)samplerProbability >= 0.999) {
            builder.setSampler(Samplers.alwaysSample());
        } else if (samplerProbability < 0.0f) {
            builder.setSampler(Samplers.neverSample());
        } else {
            builder.setSampler(Samplers.probabilitySampler((double)samplerProbability));
        }
        traceConfig.updateActiveTraceParams(builder.build());
    }

    @Override
    public void init(long pollInterval, Map<String, String> options) {
        this.options = options;
        this.pollInterval = pollInterval;
    }

    protected String getCurrentHostname() {
        try {
            return InetAddress.getLocalHost().getHostName().split("\\.")[0];
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    protected long getPollInterval() {
        return this.pollInterval;
    }

    protected String getHostnameFromNuxeoUrl() {
        try {
            String url = Framework.getProperty((String)"nuxeo.url");
            if (StringUtils.isBlank((CharSequence)url)) {
                return "";
            }
            URI uri = new URI(url);
            String domain = uri.getHost();
            if (StringUtils.isBlank((CharSequence)domain)) {
                return "";
            }
            return domain.startsWith("www.") ? domain.substring(4) : domain;
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    protected String getOption(String name, String defaultValue) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    protected String requireOption(String name) {
        return this.requireOption(name, null);
    }

    protected String requireOption(String name, String errorMessage) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("Metric Reporter configuration requires option: " + name + (String)(StringUtils.isBlank((CharSequence)errorMessage) ? "" : " " + errorMessage));
        }
        return value;
    }

    protected int getOptionAsInt(String name, int defaultValue) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    protected boolean getOptionAsBoolean(String name, boolean defaultValue) {
        String value = this.options.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

