/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNodeImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphVariablesUtil;
import org.nuxeo.runtime.api.Framework;

public class GraphRouteImpl
extends DocumentRouteImpl
implements GraphRoute {
    private static final long serialVersionUID = 1L;
    protected List<GraphNode> nodes;
    protected Map<String, GraphNode> nodesById;

    public GraphRouteImpl(DocumentModel doc) {
        super(doc, new GraphRunner());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getName()).toString();
    }

    @Override
    public Collection<GraphNode> getNodes() {
        if (this.nodes == null) {
            this.compute();
        }
        return this.nodes;
    }

    protected void compute() {
        String startNodeId = this.computeNodes();
        this.computeTransitions();
        this.computeLoopTransitions(startNodeId);
    }

    protected String computeNodes() {
        CoreSession session = this.document.getCoreSession();
        DocumentModelList children = session.getChildren(this.document.getRef());
        this.nodes = new ArrayList<GraphNode>(children.size());
        this.nodesById = new HashMap<String, GraphNode>();
        String startNodeId = null;
        for (DocumentModel doc : children) {
            if (!doc.getType().equals("RouteNode")) continue;
            GraphNodeImpl node = new GraphNodeImpl(doc, this);
            String id = node.getId();
            if (this.nodesById.put(id, node) != null) {
                throw new DocumentRouteException("Duplicate nodes with id: " + id);
            }
            this.nodes.add(node);
            if (!node.isStart()) continue;
            if (startNodeId != null) {
                throw new DocumentRouteException("Duplicate start nodes: " + startNodeId + " and " + id);
            }
            startNodeId = id;
        }
        return startNodeId;
    }

    protected void computeTransitions() throws DocumentRouteException {
        for (GraphNode node : this.nodes) {
            List<GraphNode.Transition> tt = node.getOutputTransitions();
            for (GraphNode.Transition t : tt) {
                GraphNode target = this.getNode(t.target);
                target.initAddInputTransition(t);
            }
        }
    }

    protected void computeLoopTransitions(String startNodeId) throws DocumentRouteException {
        if (startNodeId == null) {
            return;
        }
        LinkedList<String> postOrder = new LinkedList<String>();
        LinkedList stack = new LinkedList();
        LinkedList<String> first = new LinkedList<String>();
        first.add(startNodeId);
        stack.push(first);
        HashSet<String> done = new HashSet<String>();
        while (true) {
            String nodeId;
            if ((nodeId = (String)((Deque)stack.peek()).peek()) == null) {
                stack.pop();
                if (stack.isEmpty()) break;
                nodeId = (String)((Deque)stack.peek()).pop();
                postOrder.add(nodeId);
                continue;
            }
            if (done.add(nodeId)) {
                LinkedList<String> children = new LinkedList<String>();
                for (GraphNode.Transition t : this.getNode(nodeId).getOutputTransitions()) {
                    children.add(t.target);
                }
                stack.push(children);
                continue;
            }
            ((Deque)stack.peek()).pop();
        }
        Collections.reverse(postOrder);
        HashMap<String, Integer> ordering = new HashMap<String, Integer>();
        int i = 1;
        for (String nodeId : postOrder) {
            ordering.put(nodeId, i++);
        }
        done.clear();
        LinkedList<String> todo = new LinkedList<String>();
        todo.add(startNodeId);
        while (!todo.isEmpty()) {
            String nodeId;
            nodeId = (String)todo.pop();
            if (!done.add(nodeId)) continue;
            int source = (Integer)ordering.get(nodeId);
            for (GraphNode.Transition t : this.getNode(nodeId).getOutputTransitions()) {
                todo.push(t.target);
                int target = (Integer)ordering.get(t.target);
                if (target > source) continue;
                t.loop = true;
            }
        }
    }

    @Override
    public GraphNode getStartNode() throws DocumentRouteException {
        for (GraphNode node : this.getNodes()) {
            if (!node.isStart()) continue;
            return node;
        }
        throw new DocumentRouteException("No start node for graph: " + this.getName());
    }

    @Override
    public GraphNode getNode(String id) {
        this.getNodes();
        GraphNode node = this.nodesById.get(id);
        if (node != null) {
            return node;
        }
        throw new IllegalArgumentException("No node with id: " + id + " in graph: " + this);
    }

    @Override
    public Map<String, Serializable> getVariables() {
        return GraphVariablesUtil.getVariables(this.document, "docri:variablesFacet");
    }

    @Override
    public Map<String, Serializable> getJsonVariables() {
        return GraphVariablesUtil.getVariables(this.document, "docri:variablesFacet", true);
    }

    @Override
    public void setVariables(Map<String, Serializable> map) {
        GraphVariablesUtil.setVariables(this.document, "docri:variablesFacet", map);
    }

    @Override
    public void setJSONVariables(Map<String, String> map) {
        GraphVariablesUtil.setJSONVariables(this.document, "docri:variablesFacet", map);
    }

    @Override
    public DocumentModelList getAttachedDocumentModels() {
        List ids = (List)((Object)this.document.getPropertyValue("docri:participatingDocuments"));
        ArrayList<IdRef> docRefs = new ArrayList<IdRef>();
        for (String id : ids) {
            IdRef idRef = new IdRef(id);
            if (!this.document.getCoreSession().exists((DocumentRef)idRef)) continue;
            docRefs.add(idRef);
        }
        return this.document.getCoreSession().getDocuments(docRefs.toArray(new DocumentRef[0]));
    }

    @Override
    public String getAvailabilityFilter() {
        try {
            return (String)((Object)this.document.getPropertyValue("docri:availabilityFilter"));
        }
        catch (PropertyException e) {
            return null;
        }
    }

    @Override
    public boolean hasParentRoute() {
        String parentRouteInstanceId = (String)((Object)this.document.getPropertyValue("docri:parentRouteInstanceId"));
        return !StringUtils.isEmpty((CharSequence)parentRouteInstanceId);
    }

    @Override
    public void resumeParentRoute(CoreSession session) {
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        String parentRouteInstanceId = (String)((Object)this.document.getPropertyValue("docri:parentRouteInstanceId"));
        String parentRouteNodeId = (String)((Object)this.document.getPropertyValue("docri:parentRouteNodeId"));
        routing.resumeInstance(parentRouteInstanceId, parentRouteNodeId, null, null, session);
    }

    @Override
    public List<GraphNode> getSuspendedNodes() {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        for (GraphNode node : this.getNodes()) {
            if (!GraphNode.State.SUSPENDED.equals((Object)node.getState())) continue;
            result.add(node);
        }
        return result;
    }
}

