/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.codec;

import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.message.RawMessageDecoder;
import org.apache.avro.message.RawMessageEncoder;
import org.apache.avro.reflect.ReflectData;
import org.nuxeo.lib.stream.codec.Codec;

public class AvroBinaryCodec<T>
implements Codec<T> {
    public static final String NAME = "avroBinary";
    protected final Class<T> messageClass;
    protected final Schema schema;
    protected final RawMessageEncoder<T> encoder;
    protected final RawMessageDecoder<T> decoder;

    public AvroBinaryCodec(Class<T> messageClass) {
        this.messageClass = messageClass;
        this.schema = ReflectData.get().getSchema(messageClass);
        this.encoder = new RawMessageEncoder((GenericData)ReflectData.get(), this.schema);
        this.decoder = new RawMessageDecoder((GenericData)ReflectData.get(), this.schema);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] encode(T object) {
        try {
            return this.encoder.encode(object).array();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T decode(byte[] data) {
        try {
            return (T)this.decoder.decode(data, null);
        }
        catch (IOException | IndexOutOfBoundsException | AvroRuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

