/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.kafka;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogConfig;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.RebalanceListener;
import org.nuxeo.lib.stream.log.internals.AbstractLogManager;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;
import org.nuxeo.lib.stream.log.kafka.KafkaLogAppender;
import org.nuxeo.lib.stream.log.kafka.KafkaLogConfig;
import org.nuxeo.lib.stream.log.kafka.KafkaLogTailer;
import org.nuxeo.lib.stream.log.kafka.KafkaUtils;

public class KafkaLogManager
extends AbstractLogManager {
    public static final String DISABLE_SUBSCRIBE_PROP = "subscribe.disable";
    protected final List<KafkaLogConfig> configs;
    protected final KafkaLogConfig defaultConfig;
    protected final Map<KafkaLogConfig, KafkaUtils> kUtils = new HashMap<KafkaLogConfig, KafkaUtils>();

    public KafkaLogManager(String prefix, Properties producerProperties, Properties consumerProperties) {
        this(Collections.singletonList(new KafkaLogConfig("unknown", true, Collections.emptyList(), prefix, null, producerProperties, consumerProperties)));
    }

    public KafkaLogManager(List<KafkaLogConfig> kafkaConfigs) {
        if (kafkaConfigs == null && kafkaConfigs.isEmpty()) {
            throw new IllegalArgumentException("config required");
        }
        this.configs = kafkaConfigs;
        this.defaultConfig = this.findDefaultConfig();
        this.configs.forEach(config -> this.kUtils.put((KafkaLogConfig)config, new KafkaUtils(config.getAdminProperties())));
    }

    protected KafkaLogConfig findDefaultConfig() {
        List defaultConfigs = this.configs.stream().filter(LogConfig::isDefault).collect(Collectors.toList());
        if (defaultConfigs.isEmpty()) {
            return this.configs.get(this.configs.size() - 1);
        }
        return (KafkaLogConfig)defaultConfigs.get(defaultConfigs.size() - 1);
    }

    protected KafkaLogConfig getConfig(Name name) {
        return this.configs.stream().filter(config -> config.match(name)).findFirst().orElse(this.defaultConfig);
    }

    protected KafkaLogConfig getConfig(Name name, Name group) {
        return this.configs.stream().filter(config -> config.match(name, group)).findFirst().orElse(this.defaultConfig);
    }

    @Override
    public void create(Name name, int size) {
        KafkaLogConfig config = this.getConfig(name);
        this.kUtils.get(config).createTopic(config.getResolver().getId(name), size, config.getReplicatorFactor());
    }

    @Override
    protected int getSize(Name name) {
        KafkaLogConfig config = this.getConfig(name);
        return this.kUtils.get(config).partitions(config.getResolver().getId(name));
    }

    @Override
    public boolean exists(Name name) {
        KafkaLogConfig config = this.getConfig(name);
        return this.kUtils.get(config).topicExists(config.getResolver().getId(name));
    }

    @Override
    public <M extends Externalizable> CloseableLogAppender<M> createAppender(Name name, Codec<M> codec) {
        KafkaLogConfig config = this.getConfig(name);
        return KafkaLogAppender.open(codec, config.getResolver(), name, config.getProducerProperties(), config.getConsumerProperties());
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doCreateTailer(Collection<LogPartition> partitions, Name group, Codec<M> codec) {
        partitions.forEach(this::checkValidPartition);
        if (partitions.isEmpty()) {
            return KafkaLogTailer.createAndAssign(codec, this.defaultConfig.getResolver(), partitions, group, (Properties)this.defaultConfig.getConsumerProperties().clone());
        }
        KafkaLogConfig config = this.getConfig(partitions.iterator().next().name());
        return KafkaLogTailer.createAndAssign(codec, config.getResolver(), partitions, group, (Properties)config.getConsumerProperties().clone());
    }

    protected void checkValidPartition(LogPartition partition) {
        KafkaLogConfig config = this.getConfig(partition.name());
        int partitions = this.kUtils.get(config).getNumberOfPartitions(config.getResolver().getId(partition.name()));
        if (partition.partition() >= partitions) {
            throw new IllegalArgumentException("Partition out of bound " + partition + " max: " + partitions);
        }
    }

    @Override
    public void close() {
        super.close();
        this.configs.forEach(config -> this.kUtils.get(config).close());
    }

    @Override
    public boolean supportSubscribe() {
        return this.defaultConfig.getDisableSubscribe() == false;
    }

    @Override
    protected <M extends Externalizable> LogTailer<M> doSubscribe(Name group, Collection<Name> names, RebalanceListener listener, Codec<M> codec) {
        KafkaLogConfig config = this.getConfig(names.iterator().next(), group);
        return KafkaLogTailer.createAndSubscribe(codec, config.getResolver(), names, group, (Properties)config.getConsumerProperties().clone(), listener);
    }

    @Override
    public List<LogLag> getLagPerPartition(Name name, Name group) {
        KafkaLogConfig config = this.getConfig(name, group);
        Properties props = (Properties)config.getConsumerProperties().clone();
        props.put("group.id", config.getResolver().getId(group));
        props.put("client.id", config.getResolver().getId(group) + "-lag");
        Class<KafkaLogManager> clazz = KafkaLogManager.class;
        synchronized (KafkaLogManager.class) {
            List<LogLag> list;
            try (KafkaConsumer consumer = new KafkaConsumer(props);){
                Set topicPartitions = consumer.partitionsFor(config.getResolver().getId(name)).stream().map(meta -> new TopicPartition(meta.topic(), meta.partition())).collect(Collectors.toSet());
                LogLag[] ret = new LogLag[topicPartitions.size()];
                Map endOffsets = consumer.endOffsets(topicPartitions);
                Map committedOffsets = consumer.committed(topicPartitions);
                for (TopicPartition topicPartition : topicPartitions) {
                    Long endOffset;
                    OffsetAndMetadata committed = (OffsetAndMetadata)committedOffsets.get(topicPartition);
                    long committedOffset = 0L;
                    if (committed != null) {
                        committedOffset = committed.offset();
                    }
                    if ((endOffset = (Long)endOffsets.get(topicPartition)) == null) {
                        endOffset = 0L;
                    }
                    ret[topicPartition.partition()] = new LogLag(committedOffset, endOffset);
                }
                list = Arrays.asList(ret);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return list;
        }
    }

    @Override
    public List<Name> listAllNames() {
        Set<String> allTopics = this.kUtils.get(this.defaultConfig).listTopics();
        HashSet<Name> names = new HashSet<Name>(allTopics.size());
        for (String topic : allTopics) {
            for (KafkaLogConfig config : this.configs) {
                if (!topic.startsWith(config.getResolver().getPrefix())) continue;
                names.add(config.getResolver().getName(topic));
            }
        }
        return new ArrayList<Name>(names);
    }

    public String toString() {
        return "KafkaLogManager{configs=" + this.configs + ", defaultConfig=" + this.defaultConfig + ", defaultResolver" + this.defaultConfig.getResolver() + "}";
    }

    protected String filterDisplayedProperties(Properties properties) {
        String ret = properties.toString();
        if (ret.indexOf("password") < 0) {
            return ret;
        }
        return ret.replaceAll("password=.[^\\\"\\;\\,\\ ]*", "password=****");
    }

    @Override
    public List<Name> listConsumerGroups(Name name) {
        KafkaLogConfig config = this.getConfig(name);
        String topic = config.getResolver().getId(name);
        if (!this.kUtils.get(config).topicExists(topic)) {
            throw new IllegalArgumentException("Unknown Log: " + name);
        }
        return this.kUtils.get(config).listConsumers(topic).stream().filter(group -> group.startsWith(config.getResolver().getPrefix())).map(config.getResolver()::getName).collect(Collectors.toList());
    }

    @Override
    public boolean delete(Name name) {
        KafkaLogConfig config = this.getConfig(name);
        return this.kUtils.get(config).delete(config.getResolver().getId(name));
    }
}

