/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.jaxrs.BundleNotFoundException;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ListenerDescriptor;

@XObject(value="listeners")
public class ListenerSetDescriptor {
    @XNodeList(value="listener", type=ArrayList.class, componentType=ListenerDescriptor.class, trim=true, nullByDefault=false)
    protected ArrayList<ListenerDescriptor> listenerDescriptors;
    private ServletContextListener[] listeners;
    private ServletContextEvent event;

    public synchronized boolean isInitialized() {
        return this.event != null;
    }

    public synchronized void init(ServletConfig config) throws ReflectiveOperationException, BundleNotFoundException {
        if (this.event == null && !this.listenerDescriptors.isEmpty()) {
            this.event = new ServletContextEvent(config.getServletContext());
            this.listeners = new ServletContextListener[this.listenerDescriptors.size()];
            for (int i = 0; i < this.listeners.length; ++i) {
                ListenerDescriptor ld = this.listenerDescriptors.get(i);
                this.listeners[i] = ld.getListener();
                this.listeners[i].contextInitialized(this.event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean destroy() {
        if (this.event != null && this.listeners != null) {
            try {
                for (ServletContextListener listener : this.listeners) {
                    listener.contextDestroyed(this.event);
                }
            }
            finally {
                this.event = null;
                this.listeners = null;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.listenerDescriptors.toString();
    }
}

