/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http.servlet;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.common.Scope;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.contrib.http.HttpServerHandler;
import io.opencensus.contrib.http.servlet.OcHttpServletExtractor;
import io.opencensus.contrib.http.servlet.OcHttpServletListener;
import io.opencensus.contrib.http.servlet.OcHttpServletUtil;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.config.TraceConfig;
import io.opencensus.trace.propagation.TextFormat;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OcHttpServletFilter
implements Filter {
    public static final String OC_TRACE_PROPAGATOR = "opencensus.trace_propagator";
    public static final String OC_EXTRACTOR = "opencensus.extractor";
    public static final String OC_PUBLIC_ENDPOINT = "opencensus.public_endpoint";
    static final String EXCEPTION_MESSAGE = "Invalid value for attribute ";
    @VisibleForTesting
    static final TextFormat.Getter<HttpServletRequest> getter = new TextFormat.Getter<HttpServletRequest>(){

        @Nullable
        public String get(HttpServletRequest carrier, String key) {
            return carrier.getHeader(key);
        }
    };
    @VisibleForTesting
    HttpServerHandler<HttpServletRequest, HttpServletResponse, HttpServletRequest> handler;

    public OcHttpServletFilter() {
        TraceConfig traceConfig = Tracing.getTraceConfig();
        traceConfig.updateActiveTraceParams(traceConfig.getActiveTraceParams().toBuilder().build());
        this.handler = OcHttpServletFilter.buildHttpServerHandler();
    }

    static HttpServerHandler<HttpServletRequest, HttpServletResponse, HttpServletRequest> buildHttpServerHandler() {
        return OcHttpServletFilter.buildHttpServerHandlerWithOptions(new OcHttpServletExtractor(), Tracing.getPropagationComponent().getTraceContextFormat(), false);
    }

    static HttpServerHandler<HttpServletRequest, HttpServletResponse, HttpServletRequest> buildHttpServerHandlerWithOptions(HttpExtractor<HttpServletRequest, HttpServletResponse> extractor, TextFormat propagator, Boolean publicEndpoint) {
        return new HttpServerHandler(Tracing.getTracer(), extractor, propagator, getter, publicEndpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.handler == null) {
            throw new ServletException("Failed to build HttpServerHandler");
        }
        TextFormat propagator = null;
        OcHttpServletExtractor extractor = null;
        Boolean publicEndpoint = null;
        ServletContext context = filterConfig.getServletContext();
        Object obj = context.getAttribute(OC_TRACE_PROPAGATOR);
        if (obj != null) {
            if (!(obj instanceof TextFormat)) throw new ServletException("Invalid value for attribute opencensus.trace_propagator");
            propagator = (TextFormat)obj;
        } else {
            propagator = Tracing.getPropagationComponent().getTraceContextFormat();
        }
        obj = context.getAttribute(OC_EXTRACTOR);
        if (obj != null) {
            if (!(obj instanceof HttpExtractor)) throw new ServletException("Invalid value for attribute opencensus.extractor");
            extractor = (HttpExtractor)obj;
        } else {
            extractor = new OcHttpServletExtractor();
        }
        String publicEndVal = context.getInitParameter(OC_PUBLIC_ENDPOINT);
        publicEndpoint = publicEndVal != null ? Boolean.valueOf(Boolean.parseBoolean(publicEndVal)) : Boolean.valueOf(false);
        this.handler = OcHttpServletFilter.buildHttpServerHandlerWithOptions(extractor, propagator, publicEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpReq = (HttpServletRequest)request;
            HttpServletResponse httpResp = (HttpServletResponse)response;
            HttpRequestContext context = this.handler.handleStart((Object)httpReq, (Object)httpReq);
            OcHttpServletListener listener = new OcHttpServletListener(this.handler, context);
            httpReq.setAttribute("opencensus.servlet.listener", (Object)listener);
            int length = httpReq.getContentLength();
            if (length > 0) {
                this.handler.handleMessageReceived(context, (long)length);
            }
            Scope scope = Tracing.getTracer().withSpan(this.handler.getSpanFromContext(context));
            try {
                chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpResp);
            }
            finally {
                scope.close();
            }
            if (httpReq.isAsyncStarted()) {
                AsyncContext async = httpReq.getAsyncContext();
                async.addListener((AsyncListener)listener, (ServletRequest)httpReq, (ServletResponse)httpResp);
            } else {
                OcHttpServletUtil.recordMessageSentEvent(this.handler, context, httpResp);
                this.handler.handleEnd(context, (Object)httpReq, (Object)httpResp, null);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

