/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.business.adapter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;

@JsonPropertyOrder(value={"type", "id"})
public abstract class BusinessAdapter {
    private static final Log log = LogFactory.getLog(BusinessAdapter.class);
    @JsonProperty(value="id")
    protected String id;
    @JsonProperty(value="type")
    protected String type;
    protected transient DocumentModel doc;

    public BusinessAdapter() {
        this.doc = SimpleDocumentModel.empty();
    }

    public BusinessAdapter(DocumentModel document) {
        this.type = document.getType();
        this.doc = document;
        this.id = this.doc.getId();
    }

    public void save(CoreSession session) {
        session.saveDocument(this.doc);
    }

    @JsonIgnore
    public DocumentModel getDocument() {
        return this.doc;
    }

    public String getId() {
        try {
            return this.doc.getId();
        }
        catch (UnsupportedOperationException e) {
            return this.id;
        }
    }

    public String getType() {
        return this.doc.getType() == null ? this.type : this.doc.getType();
    }
}

