/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.runtime.api.Framework;

public class ExtendedInfoDeserializer
extends JsonDeserializer<ExtendedInfo> {
    public ExtendedInfo deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object value;
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        switch (node.getNodeType()) {
            case STRING: {
                value = node.textValue();
                try {
                    value = Date.from(Instant.parse((String)value));
                }
                catch (DateTimeParseException dateTimeParseException) {}
                break;
            }
            case BOOLEAN: {
                value = node.booleanValue();
                break;
            }
            case NUMBER: {
                value = node.numberValue();
                if (!(value instanceof Integer)) break;
                value = (long)((Integer)value).intValue();
                break;
            }
            case BINARY: {
                value = (Serializable)SerializationUtils.deserialize((byte[])Base64.decode((byte[])node.binaryValue()));
                break;
            }
            case ARRAY: {
                value = (Serializable)mapper.convertValue((Object)node, List.class);
                break;
            }
            case OBJECT: {
                value = (Serializable)mapper.convertValue((Object)node, Map.class);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Error when deserializing type: " + node.getNodeType());
            }
        }
        return ((AuditLogger)Framework.getService(AuditLogger.class)).newExtendedInfo((Serializable)value);
    }
}

