/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidations;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidationsQueue;
import org.nuxeo.runtime.metrics.MetricsService;

public class SoftRefCachingRowMapper
implements RowMapper {
    private static final String ABSENT = "__ABSENT__\u0000\u0000\u0000";
    private final Map<RowId, Row> cache;
    private Model model;
    private RowMapper rowMapper;
    private final VCSInvalidations localInvalidations;
    public final VCSInvalidationsQueue cacheQueue;
    private VCSInvalidationsPropagator cachePropagator;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected Counter cacheHitCount;
    protected Timer cacheGetTimer;
    protected Counter sorRows;
    protected Timer sorGetTimer;

    public SoftRefCachingRowMapper() {
        this.cache = new ReferenceMap(0, 1);
        this.localInvalidations = new VCSInvalidations();
        this.cacheQueue = new VCSInvalidationsQueue("mapper-" + this);
    }

    public void initialize(String repositoryName, Model model, RowMapper rowMapper, VCSInvalidationsPropagator cachePropagator, Map<String, String> properties) {
        this.model = model;
        this.rowMapper = rowMapper;
        this.cachePropagator = cachePropagator;
        cachePropagator.addQueue(this.cacheQueue);
        this.setMetrics(repositoryName);
    }

    protected void setMetrics(String repositoryName) {
        this.cacheHitCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "soft-ref", "hit"}).tagged(new String[]{"repository", repositoryName}));
        this.cacheGetTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "soft-ref", "timer"}).tagged(new String[]{"repository", repositoryName}));
        this.sorRows = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "soft-ref", "sor", "rows"}).tagged(new String[]{"repository", repositoryName}));
        this.sorGetTimer = this.registry.timer(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "soft-ref", "sor", "timer"}).tagged(new String[]{"repository", repositoryName}));
    }

    public void close() {
        this.clearCache();
        this.cachePropagator.removeQueue(this.cacheQueue);
    }

    @Override
    public Serializable generateNewId() {
        return this.rowMapper.generateNewId();
    }

    protected static boolean isAbsent(Row row) {
        return row.tableName == ABSENT;
    }

    protected void cachePut(Row row) {
        if ((row = row.clone()).isCollection() && row.values.length > 0 && row.values[0] instanceof ACLRow) {
            row.values = this.sortACLRows((ACLRow[])row.values);
        }
        this.cache.put(new RowId(row), row);
    }

    protected ACLRow[] sortACLRows(ACLRow[] acls) {
        ArrayList<ACLRow> list = new ArrayList<ACLRow>(Arrays.asList(acls));
        Collections.sort(list, ACLRow.ACLRowPositionComparator.INSTANCE);
        ACLRow[] res = new ACLRow[acls.length];
        return list.toArray(res);
    }

    protected void cachePutAbsent(RowId rowId) {
        this.cache.put(new RowId(rowId), new Row(ABSENT, (Serializable)null));
    }

    protected void cachePutAbsentIfNull(RowId rowId, Row row) {
        if (row != null) {
            this.cachePut(row);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    protected void cachePutAbsentIfRowId(RowId rowId) {
        if (rowId instanceof Row) {
            this.cachePut((Row)rowId);
        } else {
            this.cachePutAbsent(rowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row cacheGet(RowId rowId) {
        Timer.Context context = this.cacheGetTimer.time();
        try {
            Row row = this.cache.get(rowId);
            if (row != null && !SoftRefCachingRowMapper.isAbsent(row)) {
                row = row.clone();
            }
            if (row != null) {
                this.cacheHitCount.inc();
            }
            Row row2 = row;
            return row2;
        }
        finally {
            context.stop();
        }
    }

    protected void cacheRemove(RowId rowId) {
        this.cache.remove(rowId);
    }

    @Override
    public VCSInvalidations receiveInvalidations() {
        this.rowMapper.receiveInvalidations();
        VCSInvalidations invalidations = (VCSInvalidations)this.cacheQueue.getInvalidations();
        if (invalidations.all) {
            this.clearCache();
        }
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                this.cacheRemove(rowId);
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                this.cachePutAbsent(rowId);
            }
        }
        return invalidations.isEmpty() ? null : invalidations;
    }

    @Override
    public void sendInvalidations(VCSInvalidations invalidations) {
        if (!this.localInvalidations.isEmpty()) {
            if (invalidations == null) {
                invalidations = new VCSInvalidations();
            }
            invalidations.add(this.localInvalidations);
            this.localInvalidations.clear();
        }
        if (invalidations != null && !invalidations.isEmpty()) {
            this.rowMapper.sendInvalidations(invalidations);
            this.cachePropagator.propagateInvalidations(invalidations, this.cacheQueue);
        }
    }

    @Override
    public void clearCache() {
        this.cache.clear();
        this.sorRows.dec(this.sorRows.getCount());
        this.localInvalidations.clear();
        this.rowMapper.clearCache();
    }

    @Override
    public long getCacheSize() {
        return this.cache.size();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.rowMapper.rollback(xid);
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends RowId> read(Collection<RowId> rowIds, boolean cacheOnly) {
        ArrayList<? extends RowId> res = new ArrayList<RowId>(rowIds.size());
        LinkedList<RowId> todo = new LinkedList<RowId>();
        for (RowId rowId : rowIds) {
            Row row = this.cacheGet(rowId);
            if (row == null) {
                if (cacheOnly) {
                    res.add(new RowId(rowId));
                    continue;
                }
                todo.add(rowId);
                continue;
            }
            if (SoftRefCachingRowMapper.isAbsent(row)) {
                res.add(new RowId(rowId));
                continue;
            }
            res.add(row);
        }
        if (!todo.isEmpty()) {
            Timer.Context context = this.sorGetTimer.time();
            try {
                List<? extends RowId> fetched = this.rowMapper.read(todo, cacheOnly);
                for (RowId rowId : fetched) {
                    this.cachePutAbsentIfRowId(rowId);
                }
                res.addAll(fetched);
                this.sorRows.inc((long)fetched.size());
            }
            finally {
                context.stop();
            }
        }
        return res;
    }

    @Override
    public void write(RowMapper.RowBatch batch) {
        for (Row row : batch.creates) {
            this.cachePut(row);
            this.localInvalidations.addModified(new RowId(row));
        }
        for (RowMapper.RowUpdate rowu : batch.updates) {
            this.cachePut(rowu.row);
            this.localInvalidations.addModified(new RowId(rowu.row));
        }
        for (RowId rowId : batch.deletes) {
            if (rowId instanceof Row) {
                throw new AssertionError();
            }
            this.cachePutAbsent(rowId);
            this.localInvalidations.addDeleted(rowId);
        }
        for (RowId rowId : batch.deletesDependent) {
            if (rowId instanceof Row) {
                throw new AssertionError();
            }
            this.cachePutAbsent(rowId);
            this.localInvalidations.addDeleted(rowId);
        }
        this.rowMapper.write(batch);
    }

    @Override
    public Row readSimpleRow(RowId rowId) {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            row = this.rowMapper.readSimpleRow(rowId);
            this.cachePutAbsentIfNull(rowId, row);
            return row;
        }
        if (SoftRefCachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row;
    }

    @Override
    public Map<String, String> getBinaryFulltext(RowId rowId) {
        return this.rowMapper.getBinaryFulltext(rowId);
    }

    @Override
    public Serializable[] readCollectionRowArray(RowId rowId) {
        Row row = this.cacheGet(rowId);
        if (row == null) {
            Serializable[] array = this.rowMapper.readCollectionRowArray(rowId);
            assert (array != null);
            row = new Row(rowId.tableName, rowId.id, array);
            this.cachePut(row);
            return row.values;
        }
        if (SoftRefCachingRowMapper.isAbsent(row)) {
            return null;
        }
        return row.values;
    }

    @Override
    public List<Row> readSelectionRows(SelectionType selType, Serializable selId, Serializable filter, Serializable criterion, boolean limitToOne) {
        List<Row> rows = this.rowMapper.readSelectionRows(selType, selId, filter, criterion, limitToOne);
        for (Row row : rows) {
            this.cachePut(row);
        }
        return rows;
    }

    @Override
    public Set<Serializable> readSelectionsIds(SelectionType selType, List<Serializable> values) {
        return this.rowMapper.readSelectionsIds(selType, values);
    }

    @Override
    public RowMapper.CopyResult copy(RowMapper.IdWithTypes source, Serializable destParentId, String destName, Row overwriteRow, boolean excludeSpecialChildren) {
        RowMapper.CopyResult result = this.rowMapper.copy(source, destParentId, destName, overwriteRow, excludeSpecialChildren);
        VCSInvalidations invalidations = result.invalidations;
        if (invalidations.modified != null) {
            for (RowId rowId : invalidations.modified) {
                this.cacheRemove(rowId);
                this.localInvalidations.addModified(new RowId(rowId));
            }
        }
        if (invalidations.deleted != null) {
            for (RowId rowId : invalidations.deleted) {
                this.cacheRemove(rowId);
                this.localInvalidations.addDeleted(rowId);
            }
        }
        return result;
    }

    @Override
    public List<RowMapper.NodeInfo> getDescendantsInfo(Serializable rootId) {
        return this.rowMapper.getDescendantsInfo(rootId);
    }

    @Override
    public void remove(Serializable rootId, List<RowMapper.NodeInfo> nodeInfos) {
        this.rowMapper.remove(rootId, nodeInfos);
        for (RowMapper.NodeInfo info : nodeInfos) {
            for (String fragmentName : this.model.getTypeFragments(new RowMapper.IdWithTypes(info))) {
                RowId rowId = new RowId(fragmentName, info.id);
                this.cacheRemove(rowId);
                this.localInvalidations.addDeleted(rowId);
            }
        }
        this.cachePutAbsent(new RowId("hierarchy", rootId));
    }
}

