/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.io;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.CustomEncoding;

public class InstantAsLongEncoding
extends CustomEncoding<Instant> {
    protected static final int NULL_SCHEMA_INDEX = 0;
    protected static final int LONG_SCHEMA_INDEX = 1;

    public InstantAsLongEncoding() {
        List<Schema> union = Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG));
        union.get(1).addProp("CustomEncoding", "InstantAsLongEncoding");
        this.schema = Schema.createUnion(union);
    }

    protected void write(Object o, Encoder encoder) throws IOException {
        if (o == null) {
            encoder.writeIndex(0);
            encoder.writeNull();
        } else {
            encoder.writeIndex(1);
            encoder.writeLong(((Instant)o).toEpochMilli());
        }
    }

    protected Instant read(Object o, Decoder decoder) throws IOException {
        int index = decoder.readIndex();
        if (index == 0) {
            decoder.readNull();
            return null;
        }
        if (index == 1) {
            return Instant.ofEpochMilli(decoder.readLong());
        }
        throw new IOException("Unable to read Instant as long, index=" + index + " is unknown");
    }
}

