/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoTool;
import org.nuxeo.runtime.api.Framework;

public class VideoSlicer
extends VideoTool {
    public static final String NAME = "slicerTool";
    public static final String START_AT_PARAM = "startAt";
    public static final String DURATION_PARAM = "duration";
    public static final String ENCODE_PARAM = "encode";
    protected static final String SEGMENTS_PATH = "segmentsPath";
    protected static final String COMMAND_SLICER_DEFAULT = "videoSlicer";
    protected static final String COMMAND_SLICER_BY_COPY = "videoSlicerByCopy";
    protected static final String COMMAND_SLICER_SEGMENTS = "videoSlicerSegments";
    protected static final String COMMAND_SLICER_START_AT = "videoSlicerStartAt";

    public VideoSlicer() {
        super(NAME, COMMAND_SLICER_DEFAULT);
    }

    public Map<String, String> setupParameters(BlobHolder blobHolder, Map<String, Object> parameters) {
        boolean useDuration;
        Map cmdParameters = super.setupParameters(blobHolder, parameters);
        Blob video = blobHolder.getBlob();
        String startAt = (String)parameters.get(START_AT_PARAM);
        String duration = (String)parameters.get(DURATION_PARAM);
        boolean encode = (Boolean)parameters.get(ENCODE_PARAM);
        boolean useStart = !StringUtils.isEmpty((CharSequence)startAt);
        boolean bl = useDuration = !StringUtils.isEmpty((CharSequence)duration);
        if (useStart) {
            File outputFile;
            cmdParameters.put(START_AT_PARAM, startAt);
            String finalFilename = this.setupFilename(video.getFilename(), startAt, duration);
            try {
                outputFile = Framework.createTempFile((String)FilenameUtils.removeExtension((String)finalFilename), (String)("sliced." + FilenameUtils.getExtension((String)finalFilename)));
            }
            catch (IOException e) {
                throw new NuxeoException("VideoSlicer could not set up temporary output file.", (Throwable)e);
            }
            cmdParameters.put("outFilePath", outputFile.getAbsolutePath());
            if (useDuration) {
                cmdParameters.put(DURATION_PARAM, duration);
                this.commandLineName = encode ? COMMAND_SLICER_DEFAULT : COMMAND_SLICER_BY_COPY;
            } else {
                this.commandLineName = COMMAND_SLICER_START_AT;
            }
        } else if (useDuration) {
            Path segmentsDirectory;
            try {
                segmentsDirectory = Framework.createTempDirectory((String)"Segments", (FileAttribute[])new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new NuxeoException("VideoSlicer could not create temporary directory for video segments", (Throwable)e);
            }
            File segments = segmentsDirectory.toFile();
            File dir = new File(segments.getAbsolutePath(), this.addSuffixToFileName(video.getFilename(), "-%03d"));
            String outFilePattern = dir.getAbsolutePath();
            cmdParameters.put("outFilePath", outFilePattern);
            cmdParameters.put(DURATION_PARAM, duration);
            cmdParameters.put(SEGMENTS_PATH, segments.getAbsolutePath());
            this.commandLineName = COMMAND_SLICER_SEGMENTS;
        }
        return cmdParameters;
    }

    public BlobHolder buildResult(String mimeType, Map<String, String> cmdParams) {
        if (!this.commandLineName.equals(COMMAND_SLICER_SEGMENTS)) {
            return super.buildResult(mimeType, cmdParams);
        }
        BlobList parts = new BlobList();
        File segments = new File(cmdParams.get(SEGMENTS_PATH));
        mimeType = cmdParams.getOrDefault("outputMimetype", mimeType);
        for (File segmentFile : segments.listFiles()) {
            Blob blob = VideoSlicer.getTemporaryBlob((String)segmentFile.getAbsolutePath(), (String)mimeType);
            parts.add((Object)blob);
        }
        FileUtils.deleteQuietly((File)segments);
        return new SimpleBlobHolder((List)parts);
    }

    private String setupFilename(String filename, String startAt, String duration) {
        Object suffix = StringUtils.isEmpty((CharSequence)startAt) ? "" : "-" + startAt.replaceAll(":", "");
        suffix = (String)suffix + (String)(StringUtils.isEmpty((CharSequence)duration) ? "" : "-" + duration.replaceAll(":", ""));
        return this.addSuffixToFileName(filename, (String)suffix);
    }

    private String addSuffixToFileName(String filename, String suffix) {
        if (StringUtils.isEmpty((CharSequence)filename) || StringUtils.isEmpty((CharSequence)suffix)) {
            return filename;
        }
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex < 0) {
            return filename + suffix;
        }
        return filename.substring(0, dotIndex) + suffix + filename.substring(dotIndex);
    }
}

