/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.writer.JsonXmlStreamWriter;
import java.io.Console;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.RegistrationException;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.Version;
import org.nuxeo.launcher.NuxeoLauncherException;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.connect.ConnectBroker;
import org.nuxeo.launcher.connect.ConnectRegistrationBroker;
import org.nuxeo.launcher.connect.LauncherRestartException;
import org.nuxeo.launcher.daemon.DaemonThreadFactory;
import org.nuxeo.launcher.gui.NuxeoLauncherGUI;
import org.nuxeo.launcher.info.CommandInfo;
import org.nuxeo.launcher.info.CommandSetInfo;
import org.nuxeo.launcher.info.ConfigurationInfo;
import org.nuxeo.launcher.info.DistributionInfo;
import org.nuxeo.launcher.info.InstanceInfo;
import org.nuxeo.launcher.info.KeyValueInfo;
import org.nuxeo.launcher.info.MessageInfo;
import org.nuxeo.launcher.info.PackageInfo;
import org.nuxeo.launcher.monitoring.StatusServletClient;
import org.nuxeo.launcher.process.ProcessManager;
import org.nuxeo.log4j.Log4JHelper;

public class NuxeoLauncher {
    protected static final String OUTPUT_UNSET_VALUE = "<unset>";
    protected static final String OPTION_NODEPS = "nodeps";
    private static final String OPTION_NODEPS_DESC = "Ignore package dependencies and constraints.";
    protected static final String OPTION_GUI = "gui";
    private static final String OPTION_GUI_DESC = "Start graphical user interface (default is true on Windows and false on other platforms).";
    protected static final String OPTION_JSON = "json";
    private static final String OPTION_JSON_DESC = "Output JSON for mp-* commands.";
    protected static final String OPTION_XML = "xml";
    private static final String OPTION_XML_DESC = "Output XML for mp-* commands.";
    protected static final String OPTION_DEBUG = "debug";
    private static final String OPTION_DEBUG_DESC = "Activate debug messages.\n<categories>: comma-separated Java categories to debug (default: \"org.nuxeo.launcher\").";
    private static final String OPTION_DEBUG_CATEGORY_ARG_NAME = "categories";
    protected static final String OPTION_DEBUG_CATEGORY = "dc";
    private static final String OPTION_DEBUG_CATEGORY_DESC = "Deprecated: see categories on '--debug' option.";
    protected static final String OPTION_QUIET = "quiet";
    private static final String OPTION_QUIET_DESC = "Suppress information messages.";
    protected static final String OPTION_HELP = "help";
    private static final String OPTION_HELP_DESC = "Show detailed help.";
    protected static final String OPTION_RELAX = "relax";
    private static final String OPTION_RELAX_DESC = "Allow relax constraint on current platform (default: ask).";
    protected static final String OPTION_ACCEPT = "accept";
    private static final String OPTION_ACCEPT_DESC = "Accept, refuse or ask confirmation for all changes (default: ask).\nIn non interactive mode, '--accept=true' also sets '--relax=true' if needed.";
    protected static final String OPTION_SNAPSHOT = "snapshot";
    private static final String OPTION_SNAPSHOT_DESC = "Allow use of SNAPSHOT Nuxeo Packages.\nThis option is implicit:\n\t- on SNAPSHOT distributions (daily builds),\n\t- if the command explicitly requests a SNAPSHOT package.";
    @Deprecated(since="11.1")
    protected static final String OPTION_FORCE = "force";
    @Deprecated(since="11.1")
    private static final String OPTION_FORCE_DESC = "Deprecated since 11.1: strict mode is the default.";
    @Deprecated(since="11.1")
    protected static final String OPTION_STRICT = "strict";
    @Deprecated(since="11.1")
    private static final String OPTION_STRICT_DESC = "Deprecated since 11.1: strict mode is the default.";
    protected static final String OPTION_LENIENT = "lenient";
    protected static final String OPTION_LENIENT_DESC = "Do not abort in error the start command when a component cannot be activated or if a server is already running.";
    protected static final String OPTION_HIDE_DEPRECATION = "hide-deprecation-warnings";
    protected static final String OPTION_HIDE_DEPRECATION_DESC = "Hide deprecation warnings.";
    protected static final String OPTION_IGNORE_MISSING = "ignore-missing";
    protected static final String OPTION_IGNORE_MISSING_DESC = "Ignore unknown packages on mp-add, mp-install and mp-set commands.";
    protected static final String OPTION_CLID = "clid";
    private static final String OPTION_CLID_DESC = "Use the provided instance CLID file";
    protected static final String OPTION_OFFLINE = "offline";
    private static final String OPTION_OFFLINE_DESC = "Allow offline registration";
    protected static final String OPTION_RENEW = "renew";
    private static final String OPTION_RENEW_DESC = "Renew the current CLID";
    protected static final String OPTION_ENCRYPT = "encrypt";
    private static final String OPTION_ENCRYPT_ARG_NAME = "algorithm";
    private static final String OPTION_ENCRYPT_DESC = String.format("Activate key value symmetric encryption.\nThe algorithm can be configured: <%s> is a cipher transformation of the form: \"algorithm/mode/padding\" or \"algorithm\".\nDefault value is \"%s\" (Advanced Encryption Standard, Electronic Cookbook Mode, PKCS5-style padding).", "encrypt", "AES/ECB/PKCS5Padding");
    protected static final String OPTION_SET = "set";
    private static final String OPTION_SET_ARG_NAME = "template";
    private static final String OPTION_SET_DESC = String.format("Set the value for a given key.\nThe value is stored in {{%s}} by default unless a template name is provided; if so, it is then stored in the template's {{%s}} file or {{nuxeo.NUXEO_ENVIRONMENT}} if later is defined in environment.\nIf the value is empty (''), then the property is unset.\nThis option is implicit if no '--get' or '--get-regexp' option is used and there are exactly two parameters (key value).", "nuxeo.conf", "nuxeo.defaults");
    protected static final String OPTION_GET = "get";
    private static final String OPTION_GET_DESC = "Get the value for a given key. Returns error code 6 if the key was not found.\nThis option is implicit if '--set' option is not used and there are more or less than two parameters.";
    protected static final String OPTION_GET_REGEXP = "get-regexp";
    private static final String OPTION_GET_REGEXP_DESC = "Get the value for all keys matching the given regular expression(s).";
    protected static final String OPTION_GZIP_OUTPUT = "gzip";
    private static final String OPTION_GZIP_DESC = "Compress the output.";
    protected static final String OPTION_OUTPUT = "output";
    private static final String OPTION_OUTPUT_DESC = "Write output in specified file.";
    protected static final String OPTION_PRETTY_PRINT = "pretty-print";
    private static final String OPTION_PRETTY_PRINT_DESC = "Pretty print the output.";
    private static final String DEFAULT_NUXEO_CONTEXT_PATH = "/nuxeo";
    private static final Logger log;
    private static final Marker NO_NEW_LINE;
    private static final Options options;
    private static final String JAVA_OPTS_PROPERTY = "launcher.java.opts";
    private static final String JAVA_OPTS_DEFAULT = "-Xms512m -Xmx1024m";
    private static final String OVERRIDE_JAVA_TMPDIR_PARAM = "launcher.override.java.tmpdir";
    protected boolean overrideJavaTmpDir;
    private static final String START_MAX_WAIT_PARAM = "launcher.start.max.wait";
    private static final String STOP_MAX_WAIT_PARAM = "launcher.stop.max.wait";
    private static final String START_MAX_WAIT_DEFAULT = "300";
    private static final String STOP_MAX_WAIT_DEFAULT = "60";
    private static final String[] COMMANDS_NO_GUI;
    private static final String[] COMMANDS_NO_RUNNING_SERVER;
    public static final int STATUS_CODE_ON = 0;
    public static final int STATUS_CODE_OFF = 3;
    public static final int STATUS_CODE_UNKNOWN = 4;
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_ERROR = 1;
    public static final int EXIT_CODE_INVALID = 2;
    public static final int EXIT_CODE_UNIMPLEMENTED = 3;
    public static final int EXIT_CODE_UNAUTHORIZED = 4;
    public static final int EXIT_CODE_NOT_INSTALLED = 5;
    public static final int EXIT_CODE_NOT_CONFIGURED = 6;
    public static final int EXIT_CODE_NOT_RUNNING = 7;
    public static final int EXIT_CODE_CANNOT_EXECUTE = 126;
    public static final int EXIT_CODE_LAUNCHER_CHANGED = 128;
    private static final String OPTION_HELP_DESC_ENV;
    private static final String OPTION_HELP_DESC_COMMANDS = "\nCOMMANDS\n        help\t\t\tPrint this message.\n        gui\t\t\tDeprecated: use '--gui' option instead.\n        start\t\t\tStart Nuxeo server in background, waiting for effective start. Useful for batch executions requiring the server being immediately available after the script returned.\n        stop\t\t\tStop any Nuxeo server started with the same {{nuxeo.conf}} file.\n        restart\t\t\tRestart Nuxeo server.\n        config\t\t\tGet and set template or global parameters.\n        encrypt\t\t\tOutput encrypted value for a given parameter.\n        decrypt\t\t\tOutput decrypted value for a given parameter.\n        configure\t\tConfigure Nuxeo server with parameters from {{nuxeo.conf}}.\n        console\t\t\tStart Nuxeo server in a console mode. Ctrl-C will stop it.\n        status\t\t\tPrint server running status.\n        startbg\t\t\tStart Nuxeo server in background, without waiting for effective start. Useful for starting Nuxeo as a service.\n        restartbg\t\tRestart Nuxeo server with a call to \"startbg\" after \"stop\".\n        pack\t\t\tBuild a static archive.\n        showconf\t\tDisplay the instance configuration.\n        mp-list\t\t\tList local Nuxeo Packages.\n        mp-listall\t\tList all Nuxeo Packages.\n        mp-init\t\t\tDeprecated: no more Nuxeo Packages locally available in the distribution.\n        mp-update\t\tUpdate cache of Nuxeo Packages list.\n        mp-add\t\t\tAdd Nuxeo Package(s) to local cache. You must provide the package file(s), name(s) or ID(s) as parameter.\n        mp-install\t\tRun Nuxeo Package installation. It is automatically called at startup if {{installAfterRestart.log}} file exists in data directory. Else you must provide the package file(s), name(s) or ID(s) as parameter.\n        mp-uninstall\t\tUninstall Nuxeo Package(s). You must provide the package name(s) or ID(s) as parameter (see \"mp-list\" command).\n        mp-remove\t\tRemove Nuxeo Package(s) from the local cache. You must provide the package name(s) or ID(s) as parameter (see \"mp-list\" command).\n        mp-reset\t\tReset all packages to DOWNLOADED state. May be useful after a manual server upgrade.\n        mp-set\t\t\tInstall a list of Nuxeo Packages and remove those not in the list.\n        mp-request\t\tInstall and uninstall Nuxeo Package(s) in one command. You must provide a *quoted* list of package names or IDs prefixed with + (install) or - (uninstall).\n        mp-purge\t\tUninstall and remove all packages from the local cache.\n        mp-hotfix\t\tInstall all the available hotfixes for the current platform but do not upgrade already installed ones (requires a registered instance).\n        mp-upgrade\t\tGet all the available upgrades for the Nuxeo Packages currently installed (requires a registered instance).\n        mp-show\t\t\tShow Nuxeo Package(s) information. You must provide the package file(s), name(s) or ID(s) as parameter.\n        register\t\tRegister your instance with an existing Connect account. You must provide the credentials, the project name or ID, its type and a description.\n        register-trial\t\tThis command is deprecated. To register for a free 30 day trial on Nuxeo Online Services, please visit https://connect.nuxeo.com/register\n\nThe following commands are always executed in console/headless mode (no GUI): \"configure\", \"mp-purge\", \"mp-add\", \"mp-install\", \"mp-uninstall\", \"mp-request\", \"mp-remove\", \"mp-hotfix\", \"mp-upgrade\", \"mp-reset\", \"mp-list\", \"mp-listall\", \"mp-update\", \"status\", \"showconf\", \"mp-show\", \"mp-set\", \"config\", \"encrypt\", \"decrypt\", \"help\".\n\nThe following commands cannot be executed on a running server: \"pack\", \"mp-purge\", \"mp-add\", \"mp-install\", \"mp-uninstall\", \"mp-request\", \"mp-remove\", \"mp-hotfix\", \"mp-upgrade\", \"mp-reset\".\n\nCommand parameters may need to be prefixed with '--' to separate them from option arguments when confusion arises.";
    private static final String OPTION_HELP_USAGE = "        nuxeoctl <command> [options] [--] [command parameters]\n\n";
    private static final String OPTION_HELP_HEADER = "SYNOPSIS\n        nuxeoctl encrypt [--encrypt <algorithm>] [<clearValue>..] [-d [<categories>]|-q]\n                Output encrypted value for <clearValue>.\n                If <clearValue> is not provided, it is read from stdin.\n\n        nuxeoctl decrypt '<cryptedValue>'.. [-d [<categories>]|-q]\n                Output decrypted value for <cryptedValue>. The secret key is read from stdin.\n\n        nuxeoctl config [<key> <value>].. <key> [<value>] [--encrypt [<algorithm>]] [--set [<template>]] [-d [<categories>]|-q]\n                Set template or global parameters.\n                If <value> is not provided and the --set 'option' is used, then the value is read from stdin.\n\n        nuxeoctl config [--get] <key>.. [-d [<categories>]|-q]\n                Get value for the given key(s).\n\n        nuxeoctl config [--get-regexp] <regexp>.. [-d [<categories>]|-q]\n                Get value for the keys matching the given regular expression(s).\n\n        nuxeoctl help|status|showconf [-d [<categories>]|-q]\n\n        nuxeoctl configure [-d [<categories>]|-q|-hdw]\n\n        nuxeoctl stop [-d [<categories>]|-q|--gui <true|false|yes|no>]\n\n        nuxeoctl start|restart|console|startbg|restartbg [-d [<categories>]|-q|--clid <arg>|--gui <true|false|yes|no>|--lenient|-hdw]\n\n        nuxeoctl mp-show [command parameters] [-d [<categories>]|-q|--clid <arg>|--xml|--json]\n\n        nuxeoctl mp-list|mp-listall|mp-update [command parameters] [-d [<categories>]|-q|--clid <arg>|--relax <true|false|yes|no>|--xml|--json]\n\n        nuxeoctl mp-reset|mp-purge|mp-hotfix|mp-upgrade [command parameters] [-d [<categories>]|-q|--clid <arg>|--xml|--json|--accept <true|false|yes|no|ask>]\n\n        nuxeoctl mp-add|mp-install|mp-uninstall|mp-remove|mp-set|mp-request [command parameters] [-d [<categories>]|-q|--clid <arg>|--xml|--json|--nodeps|--relax <true|false|yes|no|ask>|--accept <true|false|yes|no|ask>|-s|-im]\n\n        nuxeoctl register [<username> [<project> [<type> <description>] [<token>]]]\n                Register an instance with Nuxeo Online Services. Token can be created at https://connect.nuxeo.com/nuxeo/site/connect/tokens\n\n        nuxeoctl register --clid <arg>\n                Register an instance according to the given CLID file.\n\n        nuxeoctl register --renew [--clid <arg>]\n                Renew an instance registration with Nuxeo Online Services.\n\nOPTIONS";
    private static final String OPTION_HELP_FOOTER = "\nSee online documentation \"ADMINDOC/nuxeoctl and Control Panel Usage\": https://doc.nuxeo.com/x/FwNc";
    private static final int PAGE_SIZE = 20;
    protected ConfigurationGenerator configurationGenerator;
    protected ProcessManager processManager;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("NuxeoProcessThread", false));
    protected String[] params;
    protected String command;
    private boolean useGui = false;
    private int status = 4;
    private StatusServletClient statusServletClient;
    private static boolean quiet;
    private static boolean debug;
    private static boolean strict;
    private boolean xmlOutput = false;
    private boolean jsonOutput = false;
    private ConnectBroker connectBroker = null;
    private String clid = null;
    private ConnectRegistrationBroker connectRegistrationBroker = null;
    private InstanceInfo info;
    CommandLine cmdLine;
    private boolean ignoreMissing = false;
    private static Map<String, NuxeoLauncherGUI> guis;

    protected boolean commandRequiresNoRunningServer() {
        return Arrays.asList(COMMANDS_NO_RUNNING_SERVER).contains(this.command);
    }

    protected boolean commandRequiresNoGUI() {
        return Arrays.asList(COMMANDS_NO_GUI).contains(this.command);
    }

    public final ConfigurationGenerator getConfigurationGenerator() {
        return this.configurationGenerator;
    }

    public boolean commandIs(String aCommand) {
        return StringUtils.equalsIgnoreCase(this.command, aCommand);
    }

    public NuxeoLauncherGUI getGUI() {
        if (guis == null) {
            return null;
        }
        return guis.get(this.configurationGenerator.getNuxeoConf().toString());
    }

    public void setGUI(NuxeoLauncherGUI gui) {
        if (guis == null) {
            guis = new HashMap<String, NuxeoLauncherGUI>();
        }
        guis.put(this.configurationGenerator.getNuxeoConf().toString(), gui);
    }

    public NuxeoLauncher(ConfigurationGenerator configurationGenerator) {
        this.configurationGenerator = configurationGenerator;
        this.init();
    }

    public void init() {
        if (!this.configurationGenerator.init(true)) {
            throw new IllegalStateException("Initialization failed");
        }
        this.statusServletClient = new StatusServletClient(this.configurationGenerator);
        this.statusServletClient.setKey(this.configurationGenerator.getUserConfig().getProperty("server.status.key"));
        String processRegex = "^(?!/bin/sh).*" + Pattern.quote(this.configurationGenerator.getNuxeoConf().getPath()) + ".*" + Pattern.quote("org.apache.catalina.startup.Bootstrap") + ".*$";
        this.processManager = ProcessManager.of(processRegex);
        if (SystemUtils.IS_OS_MAC) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "NuxeoCtl");
        }
    }

    protected List<String> getJavaOptsProperty(Function<String, String> mapper) {
        return this.configurationGenerator.getJavaOpts(mapper);
    }

    public void checkNoRunningServer() throws IllegalStateException {
        try {
            this.processManager.findPid().ifPresent(pid -> {
                throw new NuxeoLauncherException("Cannot execute command. A server is running with process ID " + pid, 126);
            });
        }
        catch (IOException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            log.warn("Could not check existing process: {}", supplierArray);
        }
    }

    private List<String> getOSCommand(List<String> roughCommand) {
        if (SystemUtils.IS_OS_UNIX) {
            return this.getUnixCommand(roughCommand);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.getWindowsCommand(roughCommand);
        }
        throw new NuxeoLauncherException("Unknown os, can't launch server", 126);
    }

    private List<String> getWindowsCommand(List<String> roughCommand) {
        return roughCommand.stream().filter(StringUtils::isNotBlank).map(s -> "\"" + s + "\"").collect(Collectors.toList());
    }

    private List<String> getUnixCommand(List<String> roughCommand) {
        String linearizedCommand = roughCommand.stream().filter(StringUtils::isNotBlank).map(s -> s.replaceAll(" ", "\\\\ ")).reduce("exec ", (s1, s2) -> s1 + " " + s2);
        return List.of("/bin/sh", "-c", linearizedCommand);
    }

    protected Collection<? extends String> getServerProperties() {
        File home = this.configurationGenerator.getNuxeoHome();
        return List.of(NuxeoLauncher.formatPropertyToCommandLine("catalina.base", home.getPath()), NuxeoLauncher.formatPropertyToCommandLine("catalina.home", home.getPath()));
    }

    private File getJavaExecutable() {
        return Path.of(System.getProperty("java.home"), new String[0]).resolve("bin").resolve("java").toFile();
    }

    protected String getClassPath() {
        File binDir = this.configurationGenerator.getNuxeoBinDir();
        String cp = ".";
        cp = this.addToClassPath(cp, "nxserver" + File.separator + "lib");
        cp = this.addToClassPath(cp, this.getBinJarName(binDir, "bootstrap(-\\d+(\\.\\d+)*)?.jar"));
        cp = this.addToClassPath(cp, this.getBinJarName(binDir, "tomcat-juli(-\\d+(\\.\\d+)*)?.jar"));
        return cp;
    }

    protected String getBinJarName(File dir, String pattern) {
        int found;
        Pattern jarPattern = Pattern.compile(pattern);
        File[] foundJarFiles = dir.listFiles(f -> jarPattern.matcher(f.getName()).matches());
        int n = found = foundJarFiles == null ? 0 : foundJarFiles.length;
        if (found == 1) {
            return dir.getName() + File.separator + foundJarFiles[0].getName();
        }
        throw new RuntimeException(String.format("There should be only 1 file but %s were found in %s looking for %s", found, dir.getAbsolutePath(), pattern));
    }

    protected Collection<String> getNuxeoProperties() {
        ArrayList<String> nuxeoProperties = new ArrayList<String>();
        nuxeoProperties.add(NuxeoLauncher.formatPropertyToCommandLine("nuxeo.home", this.configurationGenerator.getNuxeoHome().getPath()));
        nuxeoProperties.add(NuxeoLauncher.formatPropertyToCommandLine("nuxeo.conf", this.configurationGenerator.getNuxeoConf().getPath()));
        nuxeoProperties.add(this.formatNuxeoPropertyToCommandLine("nuxeo.log.dir"));
        nuxeoProperties.add(this.formatNuxeoPropertyToCommandLine("nuxeo.data.dir"));
        nuxeoProperties.add(this.formatNuxeoPropertyToCommandLine("nuxeo.tmp.dir"));
        nuxeoProperties.add(this.formatNuxeoPropertyToCommandLine("nuxeo.mp.dir"));
        if (!DEFAULT_NUXEO_CONTEXT_PATH.equals(this.configurationGenerator.getUserConfig().getProperty("org.nuxeo.ecm.contextPath"))) {
            nuxeoProperties.add(this.formatNuxeoPropertyToCommandLine("org.nuxeo.ecm.contextPath"));
        }
        if (this.overrideJavaTmpDir) {
            nuxeoProperties.add(NuxeoLauncher.formatPropertyToCommandLine("java.io.tmpdir", this.configurationGenerator.getUserConfig().getProperty("nuxeo.tmp.dir")));
        }
        return nuxeoProperties;
    }

    private String formatNuxeoPropertyToCommandLine(String property) {
        return NuxeoLauncher.formatPropertyToCommandLine(property, this.configurationGenerator.getUserConfig().getProperty(property));
    }

    protected static String formatPropertyToCommandLine(String key, String value) {
        return String.format("-D%s=%s", key, value);
    }

    protected String addToClassPath(String cp, String filename) {
        File classPathEntry = new File(this.configurationGenerator.getNuxeoHome(), filename);
        if (!classPathEntry.exists()) {
            classPathEntry = new File(filename);
        }
        if (!classPathEntry.exists()) {
            throw new RuntimeException("Tried to add nonexistent classpath entry: " + filename);
        }
        cp = (String)cp + System.getProperty("path.separator") + classPathEntry.getPath();
        return cp;
    }

    protected static Options initParserOptions() {
        Options options = new Options();
        options.addOption(Option.builder("h").longOpt(OPTION_HELP).desc(OPTION_HELP_DESC).build());
        options.addOption(Option.builder("q").longOpt(OPTION_QUIET).desc(OPTION_QUIET_DESC).build());
        OptionGroup debugOptions = new OptionGroup();
        debugOptions.addOption(Option.builder("d").longOpt(OPTION_DEBUG).desc(OPTION_DEBUG_DESC).hasArgs().argName(OPTION_DEBUG_CATEGORY_ARG_NAME).optionalArg(true).valueSeparator(',').build());
        debugOptions.addOption(Option.builder(OPTION_DEBUG_CATEGORY).desc(OPTION_DEBUG_CATEGORY_DESC).hasArgs().argName(OPTION_DEBUG_CATEGORY_ARG_NAME).optionalArg(true).valueSeparator(',').build());
        options.addOptionGroup(debugOptions);
        options.addOption(Option.builder().longOpt("debug-launcher").desc("Linux-only. Activate Java debugging mode on the Launcher.").build());
        options.addOption(Option.builder().longOpt(OPTION_CLID).desc(OPTION_CLID_DESC).hasArg().build());
        options.addOption(Option.builder().longOpt(OPTION_OFFLINE).desc(OPTION_OFFLINE_DESC).build());
        options.addOption(Option.builder().longOpt(OPTION_RENEW).desc(OPTION_RENEW_DESC).build());
        OptionGroup outputOptions = new OptionGroup();
        outputOptions.addOption(Option.builder().longOpt(OPTION_XML).desc(OPTION_XML_DESC).build());
        outputOptions.addOption(Option.builder().longOpt(OPTION_JSON).desc(OPTION_JSON_DESC).build());
        options.addOptionGroup(outputOptions);
        options.addOption(Option.builder().longOpt(OPTION_GUI).desc(OPTION_GUI_DESC).hasArg().argName("true|false|yes|no").build());
        options.addOption(Option.builder().longOpt(OPTION_NODEPS).desc(OPTION_NODEPS_DESC).build());
        options.addOption(Option.builder().longOpt(OPTION_RELAX).desc(OPTION_RELAX_DESC).hasArg().argName("true|false|yes|no|ask").build());
        options.addOption(Option.builder().longOpt(OPTION_ACCEPT).desc(OPTION_ACCEPT_DESC).hasArg().argName("true|false|yes|no|ask").build());
        options.addOption(Option.builder("s").longOpt(OPTION_SNAPSHOT).desc(OPTION_SNAPSHOT_DESC).build());
        options.addOption(Option.builder("f").longOpt(OPTION_FORCE).desc("Deprecated since 11.1: strict mode is the default.").build());
        options.addOption(Option.builder().longOpt(OPTION_STRICT).desc("Deprecated since 11.1: strict mode is the default.").build());
        options.addOption(Option.builder().longOpt(OPTION_LENIENT).desc(OPTION_LENIENT_DESC).build());
        options.addOption(Option.builder("im").longOpt(OPTION_IGNORE_MISSING).desc(OPTION_IGNORE_MISSING_DESC).build());
        options.addOption(Option.builder("hdw").longOpt(OPTION_HIDE_DEPRECATION).desc(OPTION_HIDE_DEPRECATION_DESC).build());
        options.addOption(Option.builder().longOpt(OPTION_ENCRYPT).desc(OPTION_ENCRYPT_DESC).hasArg().argName(OPTION_ENCRYPT_ARG_NAME).optionalArg(true).build());
        options.addOption(Option.builder().longOpt(OPTION_GZIP_OUTPUT).desc(OPTION_GZIP_DESC).hasArg().argName("true|false").optionalArg(true).build());
        options.addOption(Option.builder().longOpt(OPTION_PRETTY_PRINT).desc(OPTION_PRETTY_PRINT_DESC).hasArg().argName("true|false").optionalArg(true).build());
        options.addOption(Option.builder().longOpt(OPTION_OUTPUT).desc(OPTION_OUTPUT_DESC).hasArg().argName("file").optionalArg(true).build());
        OptionGroup configOptions = new OptionGroup();
        configOptions.addOption(Option.builder().longOpt(OPTION_SET).desc(OPTION_SET_DESC).hasArg().argName(OPTION_SET_ARG_NAME).optionalArg(true).build());
        configOptions.addOption(Option.builder().longOpt(OPTION_GET).desc(OPTION_GET_DESC).build());
        configOptions.addOption(Option.builder().longOpt(OPTION_GET_REGEXP).desc(OPTION_GET_REGEXP_DESC).build());
        options.addOptionGroup(configOptions);
        return options;
    }

    protected static CommandLine parseOptions(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmdLine = parser.parse(options, args);
        if (cmdLine.hasOption(OPTION_HELP)) {
            cmdLine.getArgList().add(OPTION_HELP);
            NuxeoLauncher.setQuiet();
        } else if (cmdLine.getArgList().isEmpty()) {
            throw new ParseException("Missing command.");
        }
        if (cmdLine.hasOption(OPTION_QUIET) || cmdLine.hasOption(OPTION_XML) || cmdLine.hasOption(OPTION_JSON)) {
            NuxeoLauncher.setQuiet();
        }
        if (cmdLine.hasOption(OPTION_DEBUG)) {
            NuxeoLauncher.setDebug(cmdLine.getOptionValues(OPTION_DEBUG));
        }
        if (cmdLine.hasOption(OPTION_DEBUG_CATEGORY)) {
            NuxeoLauncher.setDebug(cmdLine.getOptionValues(OPTION_DEBUG_CATEGORY));
        }
        if (cmdLine.hasOption(OPTION_FORCE) || cmdLine.hasOption(OPTION_STRICT)) {
            log.warn("--force and --strict have no impact, Nuxeo is started in strict mode by default.");
        }
        if (cmdLine.hasOption(OPTION_LENIENT)) {
            NuxeoLauncher.relaxStrict();
        }
        return cmdLine;
    }

    public static void main(String[] args) {
        NuxeoLauncher launcher = null;
        try {
            launcher = NuxeoLauncher.createLauncher(args);
            if (launcher.commandRequiresNoGUI()) {
                launcher.useGui = false;
            }
            if (launcher.useGui && launcher.getGUI() == null) {
                launcher.setGUI(new NuxeoLauncherGUI(launcher));
            }
            NuxeoLauncher.launch(launcher);
        }
        catch (LauncherRestartException e) {
            log.info("Restarting launcher...");
            System.exit(128);
        }
        catch (ParseException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            log.error("Invalid command line: {}", supplierArray);
            log.debug(e, (Throwable)e);
            NuxeoLauncher.printShortHelp();
            System.exit(2);
        }
        catch (IOException | GeneralSecurityException | PackageException | ConfigurationException e) {
            log.error(e.getMessage());
            log.debug(e, (Throwable)e);
            System.exit(2);
        }
        catch (NuxeoLauncherException e) {
            log.error(e.getMessage());
            log.debug(e, (Throwable)e);
            System.exit(e.getExitCode());
        }
        catch (Exception e) {
            log.error("Cannot execute command. {}", (Object)e.getMessage(), (Object)e);
            log.debug(e, (Throwable)e);
            System.exit(1);
        }
    }

    public static void launch(NuxeoLauncher launcher) throws IOException, PackageException, ConfigurationException, GeneralSecurityException {
        boolean commandSucceeded = true;
        if (launcher.commandIs(null)) {
            return;
        }
        if (launcher.commandRequiresNoRunningServer()) {
            launcher.checkNoRunningServer();
        }
        if (launcher.commandIs(OPTION_HELP)) {
            NuxeoLauncher.printLongHelp();
        } else if (launcher.commandIs("status")) {
            String statusMsg = launcher.status();
            if (!quiet) {
                log.warn(statusMsg);
                if (launcher.isStarted()) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = launcher::getURL;
                    log.info("Go to {}", supplierArray);
                    log.info(launcher.getStartupSummary());
                }
            }
            System.exit(launcher.getStatus());
        } else if (launcher.commandIs("startbg")) {
            commandSucceeded = launcher.doStart();
        } else if (launcher.commandIs("start")) {
            if (launcher.useGui) {
                launcher.getGUI().start();
            } else {
                commandSucceeded = launcher.doStartAndWait();
            }
        } else if (launcher.commandIs("console")) {
            launcher.executor.execute(launcher::doConsole);
        } else if (launcher.commandIs("stop")) {
            if (launcher.useGui) {
                launcher.getGUI().stop();
            } else {
                launcher.doStop();
            }
        } else if (launcher.commandIs("restartbg")) {
            launcher.doStop();
            commandSucceeded = launcher.doStart();
        } else if (launcher.commandIs("restart")) {
            launcher.doStop();
            commandSucceeded = launcher.doStartAndWait();
        } else if (launcher.commandIs("configure")) {
            launcher.configure();
        } else if (launcher.commandIs("mp-list")) {
            launcher.pkgList();
        } else if (launcher.commandIs("mp-listall")) {
            launcher.pkgListAll();
        } else if (launcher.commandIs("mp-init")) {
            commandSucceeded = launcher.pkgInit();
        } else if (launcher.commandIs("mp-purge")) {
            commandSucceeded = launcher.pkgPurge();
        } else if (launcher.commandIs("mp-add")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgAdd(launcher.params) : launcher.pkgRequest(Arrays.asList(launcher.params), null, null, null);
        } else if (launcher.commandIs("mp-install")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgInstall(launcher.params) : launcher.pkgRequest(null, Arrays.asList(launcher.params), null, null);
        } else if (launcher.commandIs("mp-uninstall")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgUninstall(launcher.params) : launcher.pkgRequest(null, null, Arrays.asList(launcher.params), null);
        } else if (launcher.commandIs("mp-remove")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgRemove(launcher.params) : launcher.pkgRequest(null, null, null, Arrays.asList(launcher.params));
        } else if (launcher.commandIs("mp-request")) {
            if (launcher.cmdLine.hasOption(OPTION_NODEPS)) {
                throw new NuxeoLauncherException("The command mp-request is not available with the --nodeps option", 2);
            }
            commandSucceeded = launcher.pkgCompoundRequest(Arrays.asList(launcher.params));
        } else if (launcher.commandIs("mp-set")) {
            commandSucceeded = launcher.pkgSetRequest(Arrays.asList(launcher.params), launcher.cmdLine.hasOption(OPTION_NODEPS));
        } else if (launcher.commandIs("mp-hotfix")) {
            commandSucceeded = launcher.pkgHotfix();
        } else if (launcher.commandIs("mp-upgrade")) {
            commandSucceeded = launcher.pkgUpgrade();
        } else if (launcher.commandIs("mp-reset")) {
            commandSucceeded = launcher.pkgReset();
        } else if (launcher.commandIs("mp-update")) {
            commandSucceeded = launcher.pkgRefreshCache();
        } else if (launcher.commandIs("showconf")) {
            launcher.showConfig();
        } else if (launcher.commandIs("mp-show")) {
            commandSucceeded = launcher.pkgShow(launcher.params);
        } else if (launcher.commandIs(OPTION_ENCRYPT)) {
            launcher.encrypt();
        } else if (launcher.commandIs("decrypt")) {
            launcher.decrypt();
        } else if (launcher.commandIs("config")) {
            launcher.config();
        } else if (launcher.commandIs("register")) {
            commandSucceeded = launcher.register();
        } else if (launcher.commandIs("register-trial")) {
            commandSucceeded = launcher.registerTrial();
        } else {
            NuxeoLauncher.printLongHelp();
            throw new NuxeoLauncherException("Unknown command: " + launcher.command + ", see help above or with nuxeoctl help", 2);
        }
        CommandSetInfo cset = launcher.connectBroker.getCommandSet();
        if (launcher.xmlOutput && launcher.command.startsWith("mp-")) {
            launcher.printXMLOutput(cset);
        }
        if (!commandSucceeded && !quiet || debug) {
            cset.log(commandSucceeded);
        }
        if (!commandSucceeded) {
            System.exit(1);
        }
    }

    public String promptDescription() throws ConfigurationException, IOException {
        return this.prompt("Description: ", null, null);
    }

    public String prompt(String message, Predicate<String> predicate, String error) throws IOException, ConfigurationException {
        String value;
        boolean doRegexMatch = predicate != null;
        Console console = System.console();
        if (console != null) {
            value = console.readLine(message, new Object[0]);
            while (value == null || doRegexMatch && !predicate.test(value)) {
                console.printf(error + "\n", value);
                value = console.readLine(message, new Object[0]);
            }
        } else {
            value = IOUtils.toString(System.in, StandardCharsets.UTF_8);
            if (value == null || doRegexMatch && !predicate.test(value)) {
                throw new ConfigurationException(error);
            }
        }
        return value;
    }

    public char[] promptPassword(String message) throws IOException {
        Console console = System.console();
        if (console != null) {
            return console.readPassword(message, new Object[0]);
        }
        return IOUtils.toCharArray(System.in, StandardCharsets.UTF_8);
    }

    public char[] promptToken() throws IOException {
        return this.promptPassword("Please enter your token: ");
    }

    public NuxeoClientInstanceType promptInstanceType() throws IOException, ConfigurationException {
        String s;
        NuxeoClientInstanceType type;
        Console console = System.console();
        if (console == null) {
            String typeStr = IOUtils.toString(System.in, StandardCharsets.UTF_8);
            NuxeoClientInstanceType type2 = NuxeoClientInstanceType.fromString(typeStr);
            if (type2 == null) {
                throw new ConfigurationException("Unknown type: " + typeStr);
            }
            return type2;
        }
        while ((type = StringUtils.isBlank(s = console.readLine("Instance type (dev|preprod|prod): [dev] ", new Object[0])) ? NuxeoClientInstanceType.DEV : NuxeoClientInstanceType.fromString(s)) == null) {
        }
        return type;
    }

    public ConnectProject promptProject(@NotNull List<ConnectProject> projects) throws ConfigurationException, IOException {
        if (projects.isEmpty()) {
            throw new ConfigurationException("You don't have access to any project.");
        }
        if (projects.size() == 1) {
            return projects.get(0);
        }
        Console console = System.console();
        if (console == null) {
            String projectName = IOUtils.toString(System.in, StandardCharsets.UTF_8);
            ConnectProject project2 = this.getConnectRegistrationBroker().getProjectByName(projectName, projects);
            if (project2 == null) {
                throw new ConfigurationException("Unknown project: " + projectName);
            }
            return project2;
        }
        System.out.println("Available projects:");
        int i = 0;
        boolean hasNextPage = true;
        while (true) {
            String projectName;
            if (i > 0 && !SystemUtils.IS_OS_WINDOWS) {
                System.out.print("\u001b[1A\u001b[2K");
            }
            int fromIndex = i * 20;
            int toIndex = (i + 1) * 20;
            if (toIndex >= projects.size()) {
                toIndex = projects.size();
                hasNextPage = false;
            }
            projects.subList(fromIndex, toIndex).forEach(project -> System.out.println("\t- " + project.getSymbolicName()));
            if (toIndex < projects.size()) {
                int pageLeft = (projects.size() - i * 20 + 20 - 1) / 20;
                System.out.print(String.format("Project name (press Enter for next page; %d pages left): ", pageLeft));
            } else {
                System.out.print("Project name: ");
            }
            if (hasNextPage) {
                ++i;
            }
            if (!StringUtils.isNotEmpty(projectName = console.readLine())) continue;
            ConnectProject project3 = this.getConnectRegistrationBroker().getProjectByName(projectName, projects);
            if (project3 != null) {
                return project3;
            }
            System.err.println("Unknown project: " + projectName);
            i = 0;
            hasNextPage = true;
        }
    }

    public boolean register() throws IOException, ConfigurationException {
        if (this.cmdLine.hasOption(OPTION_RENEW)) {
            if (this.params.length != 0) {
                throw new ConfigurationException("Unexpected arguments for --renew.");
            }
            return this.registerRenew();
        }
        if (this.cmdLine.hasOption(OPTION_CLID) && this.params.length == 0) {
            return this.registerSaveCLID();
        }
        if (this.cmdLine.hasOption(OPTION_OFFLINE) && this.params.length == 0) {
            return this.registerOffline();
        }
        return this.registerRemoteInstance();
    }

    protected boolean registerRenew() throws IOException {
        try {
            this.getConnectRegistrationBroker().remoteRenewRegistration();
        }
        catch (RegistrationException e) {
            log.debug(e, (Throwable)e);
            return false;
        }
        log.info("Server registration renewed");
        return true;
    }

    protected boolean registerSaveCLID() throws IOException, ConfigurationException {
        try {
            this.getConnectBroker().saveCLID();
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            throw new ConfigurationException(e);
        }
        log.info("Server registration saved");
        return true;
    }

    protected boolean registerOffline() throws IOException, ConfigurationException {
        log.info("\nTo register your instance:");
        log.info("1. Visit {}/connect/registerInstance", ConnectUrlConfig::getBaseUrl);
        log.info("2. Select the project on which you want the instance to be registered and copy the technical identifier found below (CTID):\n\n{}\n", () -> TechnicalInstanceIdentifier.instance().getCTID());
        Date expirationDate = new Date();
        this.prompt("3. Enter the given identifier to register your instance (CLID): ", strCLID -> {
            try {
                this.getConnectRegistrationBroker().registerLocal((String)strCLID, "");
                long timestamp = Long.parseLong(StringUtils.substringBetween(strCLID, ".", "."));
                expirationDate.setTime(timestamp * 1000L);
            }
            catch (IOException | NumberFormatException | ConfigurationException e) {
                return false;
            }
            return true;
        }, "This identifier is invalid or cannot be read properly or cannot be saved.");
        log.info("Server registration saved");
        log.info("Your Nuxeo Online Services is valid until {}", (Object)expirationDate);
        return true;
    }

    protected boolean registerRemoteInstance() throws IOException, ConfigurationException {
        String description;
        NuxeoClientInstanceType type;
        ConnectProject project;
        if (this.params.length > 5) {
            throw new ConfigurationException("Wrong number of arguments.");
        }
        String username = this.params.length > 0 ? this.params[0] : this.prompt("Username: ", StringUtils::isNotBlank, "Username cannot be empty.");
        char[] token = this.params.length == 3 || this.params.length == 5 ? this.params[this.params.length - 1].toCharArray() : this.promptToken();
        List<ConnectProject> projects = this.getConnectRegistrationBroker().getAvailableProjects(username, token);
        if (this.params.length > 1) {
            String projectName = this.params[1];
            project = this.getConnectRegistrationBroker().getProjectByName(projectName, projects);
            if (project == null) {
                throw new ConfigurationException("Unknown project: " + projectName);
            }
        } else {
            project = this.promptProject(projects);
        }
        if (this.params.length > 3) {
            type = NuxeoClientInstanceType.fromString(this.params[2]);
            if (type == null) {
                throw new ConfigurationException("Unknown type: " + this.params[2]);
            }
            description = this.params[3];
        } else {
            type = this.promptInstanceType();
            description = this.promptDescription();
        }
        return this.registerRemoteInstance(username, token, project, type, description);
    }

    protected boolean registerRemoteInstance(String username, char[] token, ConnectProject project, NuxeoClientInstanceType type, String description) throws IOException, ConfigurationException {
        this.getConnectRegistrationBroker().registerRemote(username, token, project.getUuid(), type, description);
        log.info("Server registered to {} for project {}\nType: {}\nDescription: {}", (Object)username, (Object)project, (Object)type, (Object)description);
        return true;
    }

    @Deprecated
    public boolean registerTrial() {
        String msg = "This command is deprecated. To register for a free 30 day trial on Nuxeo Online Services, please visit https://connect.nuxeo.com/register";
        throw new NuxeoLauncherException(msg, 3);
    }

    protected void encrypt() throws GeneralSecurityException {
        Crypto crypto = this.configurationGenerator.getCrypto();
        String algorithm = this.cmdLine.getOptionValue(OPTION_ENCRYPT, null);
        if (this.params.length == 0) {
            String encryptedString;
            Console console = System.console();
            if (console != null) {
                encryptedString = crypto.encrypt(algorithm, Crypto.getBytes(console.readPassword("Please enter the value to encrypt: ", new Object[0])));
            } else {
                try {
                    encryptedString = crypto.encrypt(algorithm, IOUtils.toByteArray(System.in));
                }
                catch (IOException e) {
                    throw new NuxeoLauncherException("Encrypt failed", 1, e);
                }
            }
            log.info(encryptedString);
        } else {
            for (String strToEncrypt : this.params) {
                String encryptedString = crypto.encrypt(algorithm, strToEncrypt.getBytes());
                log.info(encryptedString);
            }
        }
    }

    protected void decrypt() {
        Crypto crypto = this.configurationGenerator.getCrypto();
        this.askCryptoKeyAndDecrypt(crypto, this.params).forEach(log::info);
    }

    protected List<String> askCryptoKeyAndDecrypt(Crypto crypto, String ... values) {
        boolean validKey;
        Console console = System.console();
        if (console != null) {
            validKey = crypto.verifyKey(console.readPassword("Please enter the secret key: ", new Object[0]));
        } else {
            try {
                validKey = crypto.verifyKey(IOUtils.toByteArray(System.in));
            }
            catch (IOException e) {
                throw new NuxeoLauncherException("Key verification failed", 1, e);
            }
        }
        if (!validKey) {
            throw new NuxeoLauncherException("The key is not valid", 2);
        }
        return Stream.of(values).map(crypto::decrypt).map(Crypto::getChars).map(String::new).collect(Collectors.toList());
    }

    protected void config() throws ConfigurationException, IOException, GeneralSecurityException {
        if (this.cmdLine.hasOption(OPTION_SET) || !this.cmdLine.hasOption(OPTION_GET) && !this.cmdLine.hasOption(OPTION_GET_REGEXP) && this.params.length == 2) {
            this.setConfigProperties();
        } else {
            this.getConfigProperties();
        }
    }

    protected void getConfigProperties() {
        List<Object> keys;
        boolean isRegexp = this.cmdLine.hasOption(OPTION_GET_REGEXP);
        CryptoProperties userConfig = this.configurationGenerator.getUserConfig();
        if (isRegexp) {
            keys = new ArrayList();
            for (Object key : userConfig.keySet()) {
                for (String param : this.params) {
                    Pattern pattern = Pattern.compile(param, 2);
                    if (!pattern.matcher((String)key).find()) continue;
                    keys.add((String)key);
                }
            }
        } else {
            keys = Arrays.asList(this.params);
        }
        Crypto crypto = userConfig.getCrypto();
        boolean keyChecked = false;
        boolean raw = true;
        StringBuilder sb = new StringBuilder();
        String newLine = System.lineSeparator();
        for (String string : keys) {
            String value = userConfig.getProperty(string, raw);
            if (value == null) {
                sb.append(OUTPUT_UNSET_VALUE).append(newLine);
                continue;
            }
            if (raw && !keyChecked && Crypto.isEncrypted(value)) {
                keyChecked = true;
                List<String> decryptedValues = this.askCryptoKeyAndDecrypt(crypto, value);
                if (decryptedValues != null) {
                    raw = false;
                    value = decryptedValues.get(0);
                }
            }
            if (isRegexp) {
                sb.append(string).append('=');
            }
            sb.append(value).append(newLine);
        }
        log.info(NO_NEW_LINE, sb.toString());
    }

    protected void setConfigProperties() throws ConfigurationException, IOException, GeneralSecurityException {
        Crypto crypto = this.configurationGenerator.getCrypto();
        boolean doEncrypt = this.cmdLine.hasOption(OPTION_ENCRYPT);
        String algorithm = this.cmdLine.getOptionValue(OPTION_ENCRYPT, null);
        HashMap<String, String> changedParameters = new HashMap<String, String>();
        Iterator<String> iterator = Arrays.asList(this.params).iterator();
        while (iterator.hasNext()) {
            String value;
            boolean isCryptKey;
            String key = iterator.next();
            boolean bl = isCryptKey = "server.crypt.secretkey".equals(key) || "server.crypt.keystore.pass".equals(key);
            if (iterator.hasNext()) {
                value = iterator.next();
                if (doEncrypt) {
                    value = crypto.encrypt(algorithm, value.getBytes());
                } else if (isCryptKey) {
                    value = Base64.encodeBase64String(value.getBytes());
                }
            } else {
                Console console = System.console();
                if (console != null) {
                    String fmt = "Please enter the value for %s: ";
                    value = doEncrypt ? crypto.encrypt(algorithm, Crypto.getBytes(console.readPassword("Please enter the value for %s: ", key))) : (isCryptKey ? Base64.encodeBase64String(Crypto.getBytes(console.readPassword("Please enter the value for %s: ", key))) : console.readLine("Please enter the value for %s: ", key));
                } else {
                    try {
                        value = doEncrypt ? crypto.encrypt(algorithm, IOUtils.toByteArray(System.in)) : (isCryptKey ? Base64.encodeBase64String(IOUtils.toByteArray(System.in)) : IOUtils.toString(System.in, StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        throw new NuxeoLauncherException("Reading from stdin failed", 1, e);
                    }
                }
            }
            changedParameters.put(key, value);
        }
        String template = this.cmdLine.getOptionValue(OPTION_SET);
        Map<String, String> oldValues = template == null ? this.configurationGenerator.setProperties(changedParameters) : this.configurationGenerator.setProperties(template, changedParameters);
        log.debug("Old values: {}", (Object)oldValues);
    }

    public boolean doStart() {
        if (this.doStart(false).isAlive()) {
            if (!quiet) {
                log.info("Go to {}", this::getURL);
            }
            return true;
        }
        return false;
    }

    public boolean doStartAndWait() {
        Process nuxeoProcess = this.doStart(false);
        if (nuxeoProcess.isAlive()) {
            ShutdownHook hook = new ShutdownHook(this);
            try {
                this.waitForEffectiveStart(nuxeoProcess);
                if (!quiet) {
                    log.info("Go to {}", this::getURL);
                }
                boolean bl = true;
                hook.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        hook.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    public void doConsole() {
        ShutdownHook hook = new ShutdownHook(this);
        try {
            this.doStart(true).onExit().thenAccept(p -> {
                hook.close();
                System.exit(1);
            });
        }
        catch (RuntimeException e) {
            hook.close();
            throw e;
        }
        if (!quiet) {
            log.info("Go to {}", this::getURL);
        }
    }

    protected Process doStart(boolean logProcessOutput) {
        try {
            this.configure();
            this.configurationGenerator.verifyInstallation();
            log.debug("Check if install in progress...");
            int tries = 0;
            while (this.configurationGenerator.isInstallInProgress()) {
                if (!this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, true, this.ignoreMissing) || ++tries > 9) {
                    throw new NuxeoLauncherException(String.format("Start interrupted due to failure on pending actions. You can resume with a new start or you can restore the file '%s', optionally using the '--%s' option.", this.configurationGenerator.getInstallFile().getName(), OPTION_IGNORE_MISSING), 1);
                }
                this.configurationGenerator = new ConfigurationGenerator(quiet, debug);
                this.configurationGenerator.init();
                this.configure();
                this.configurationGenerator.verifyInstallation();
            }
            return this.start(logProcessOutput);
        }
        catch (ConfigurationException e) {
            throw new NuxeoLauncherException("Could not run configuration: " + e.getMessage(), 6, e);
        }
        catch (IOException e) {
            throw new NuxeoLauncherException("Could not start process: " + e.getMessage(), 1, e);
        }
        catch (IllegalStateException e) {
            throw new NuxeoLauncherException("Could not start process: " + e.getMessage(), strict ? 6 : 1, e);
        }
    }

    protected Process start(boolean logProcessOutput) throws IOException {
        Long pid;
        ArrayList<String> startCommand = new ArrayList<String>();
        startCommand.add(this.getJavaExecutable().getPath());
        startCommand.addAll(this.getJavaOptsProperty(Function.identity()));
        startCommand.add("-cp");
        startCommand.add(this.getClassPath());
        startCommand.addAll(this.getNuxeoProperties());
        startCommand.addAll(this.getServerProperties());
        if (strict) {
            startCommand.add("-Dnuxeo.start.strict=true");
        }
        startCommand.add("org.apache.catalina.startup.Bootstrap");
        startCommand.add("start");
        startCommand.addAll(Arrays.asList(this.params));
        ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(startCommand));
        pb.directory(this.configurationGenerator.getNuxeoHome());
        if (logProcessOutput) {
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = pb::command;
        log.debug("Server command: {}", supplierArray);
        Process nuxeoProcess = pb.start();
        nuxeoProcess.onExit().thenAccept(p -> {
            int exitValue;
            if (SystemUtils.IS_OS_WINDOWS && this.configurationGenerator.getNuxeoHome().getPath().contains(" ")) {
                log.error("The server path must not contain spaces under Windows.");
            }
            if ((exitValue = p.exitValue()) != 0) {
                log.error("Server stopped with status: {}", (Object)exitValue);
            }
        });
        try {
            pid = nuxeoProcess.pid();
        }
        catch (UnsupportedOperationException e) {
            log.warn("Unable to get process ID from process: {}, please report it to Nuxeo", (Object)nuxeoProcess);
            pid = this.processManager.findPid().orElseThrow(() -> new NuxeoLauncherException("Sent server start command but could not get process ID.", 1, e));
        }
        log.info("Server started with process ID: {}", (Object)pid);
        File pidFile = new File(this.configurationGenerator.getPidDir(), "nuxeo.pid");
        try (FileWriter writer = new FileWriter(pidFile);){
            writer.write(Long.toString(pid));
        }
        return nuxeoProcess;
    }

    protected void waitForEffectiveStart(Process nuxeoProcess) throws InterruptedException {
        int startMaxWait = Integer.parseInt(this.configurationGenerator.getUserConfig().getProperty(START_MAX_WAIT_PARAM, START_MAX_WAIT_DEFAULT));
        Instant startTime = Instant.now();
        Instant waitUntil = startTime.plusSeconds(startMaxWait);
        log.debug("Will wait for effective start during {} seconds.", (Object)startMaxWait);
        StringBuilder startSummary = new StringBuilder();
        boolean servletAvailable = false;
        int n = 0;
        while (Instant.now().isBefore(waitUntil) && nuxeoProcess.isAlive()) {
            try {
                Thread.sleep(Math.min((++n / 10 + 1) * 1000, 60000));
                if (servletAvailable && this.statusServletClient.isStarted()) {
                    if (quiet) break;
                    log.info(".");
                    break;
                }
                if (!this.statusServletClient.init()) continue;
                servletAvailable = true;
                n = 0;
            }
            catch (SocketTimeoutException e) {
                if (quiet) continue;
                log.info(NO_NEW_LINE, ".");
            }
        }
        if (Instant.now().isAfter(waitUntil)) {
            throw new NuxeoLauncherException("Starting process is taking too long - giving up.", 1);
        }
        if (!nuxeoProcess.isAlive()) {
            String logs;
            try {
                logs = IOUtils.toString(nuxeoProcess.getInputStream(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                logs = "Unable to get process output, check server logs";
            }
            throw new NuxeoLauncherException("Nuxeo startup aborted, see startup logs:" + System.lineSeparator() + logs, 1);
        }
        startSummary.append(this.getStartupSummary());
        Duration duration = Duration.between(startTime, Instant.now());
        startSummary.append(String.format("Started in %dmin%02ds", duration.toMinutes(), duration.toSeconds() % 60L));
        if (this.wasStartupFine()) {
            if (!quiet) {
                log.info(startSummary);
            }
        } else {
            log.error(startSummary);
            if (strict) {
                this.doStop();
                throw new NuxeoLauncherException("Shutting down because of unstarted component in strict mode...", 1);
            }
        }
    }

    public boolean wasStartupFine() {
        return this.statusServletClient.isStartupFine();
    }

    public String getStartupSummary() {
        try {
            return this.statusServletClient.getStartupSummary();
        }
        catch (SocketTimeoutException e) {
            log.warn("Failed to contact Nuxeo for getting startup summary", (Throwable)e);
            return "";
        }
    }

    protected void printXMLOutput(CommandSetInfo cset) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(CommandSetInfo.class, CommandInfo.class, PackageInfo.class, MessageInfo.class);
            this.printXMLOutput(jaxbContext, cset, System.out);
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            throw new NuxeoLauncherException("Output serialization failed: " + e.getMessage(), 7, e);
        }
    }

    protected void printXMLOutput(JAXBContext context, Object object, OutputStream out) throws XMLStreamException, FactoryConfigurationError, JAXBException {
        XMLStreamWriter writer = this.jsonOutput ? this.jsonWriter(context, out) : this.xmlWriter(context, out);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        marshaller.marshal(object, writer);
    }

    protected XMLStreamWriter jsonWriter(JAXBContext context, OutputStream out) {
        JSONConfiguration config = JSONConfiguration.mapped().rootUnwrapping(true).attributeAsElement("key", "value").build();
        config = JSONConfiguration.createJSONConfigurationWithFormatted(config, true);
        return JsonXmlStreamWriter.createWriter(new OutputStreamWriter(out), config, "");
    }

    protected XMLStreamWriter xmlWriter(JAXBContext context, OutputStream out) throws XMLStreamException, FactoryConfigurationError {
        return XMLOutputFactory.newInstance().createXMLStreamWriter(out);
    }

    public void doStop() {
        try {
            Optional nuxeoProcessOpt = this.processManager.findPid().flatMap(ProcessHandle::of);
            if (nuxeoProcessOpt.isEmpty()) {
                log.warn("Server is not running.");
                return;
            }
            if (!quiet) {
                log.info(NO_NEW_LINE, "Stopping server...");
            }
            int stopMaxWait = Integer.parseInt(this.configurationGenerator.getUserConfig().getProperty(STOP_MAX_WAIT_PARAM, STOP_MAX_WAIT_DEFAULT));
            Instant startTime = Instant.now();
            Instant waitUntil = startTime.plusSeconds(stopMaxWait);
            ProcessHandle nuxeoProcess = (ProcessHandle)nuxeoProcessOpt.get();
            while (Instant.now().isBefore(waitUntil) && this.isAliveAndNotZombie(nuxeoProcess)) {
                Process stopProcess = this.stop();
                stopProcess.waitFor();
                if (!quiet) {
                    log.info(NO_NEW_LINE, ".");
                }
                Thread.sleep(1000L);
            }
            log.info(".");
            if (!this.isAliveAndNotZombie(nuxeoProcess)) {
                Duration duration = Duration.between(startTime, Instant.now());
                log.info(String.format("Stopped in %dmin%02ds", duration.toMinutes(), duration.toSeconds() % 60L));
            } else if (Instant.now().isAfter(waitUntil)) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = nuxeoProcess::pid;
                log.info("No answer from server, try to kill process {}...", supplierArray);
                this.processManager.kill(nuxeoProcess);
                if (!nuxeoProcess.isAlive()) {
                    log.warn("Server forcibly stopped.");
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoLauncherException("Error during process execution: " + e.getMessage(), 1, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected boolean isAliveAndNotZombie(ProcessHandle process) {
        return process.isAlive() && process.info().command().isPresent();
    }

    protected Process stop() throws IOException {
        ArrayList<String> stopCommand = new ArrayList<String>();
        stopCommand.add(this.getJavaExecutable().getPath());
        stopCommand.add("-cp");
        stopCommand.add(this.getClassPath());
        stopCommand.addAll(this.getNuxeoProperties());
        stopCommand.addAll(this.getServerProperties());
        stopCommand.add("org.apache.catalina.startup.Bootstrap");
        stopCommand.add("stop");
        stopCommand.addAll(Arrays.asList(this.params));
        ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(stopCommand));
        pb.directory(this.configurationGenerator.getNuxeoHome());
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = pb::command;
        log.debug("Server command: {}", supplierArray);
        return pb.start();
    }

    public void configure() {
        try {
            this.checkNoRunningServer();
            this.configurationGenerator.checkJavaVersion();
            this.configurationGenerator.run();
            this.overrideJavaTmpDir = Boolean.parseBoolean(this.configurationGenerator.getUserConfig().getProperty(OVERRIDE_JAVA_TMPDIR_PARAM, "true"));
        }
        catch (ConfigurationException e) {
            throw new NuxeoLauncherException("Could not run configuration: " + e.getMessage(), 6, e);
        }
    }

    public String status() {
        try {
            if (ProcessManager.class.equals(this.processManager.getClass())) {
                this.status = 4;
                return "Can't check server status on your OS.";
            }
            Optional<Long> pidOpt = this.processManager.findPid();
            if (pidOpt.isEmpty()) {
                this.status = 3;
                return "Server is not running.";
            }
            this.status = 0;
            return "Server is running with process ID " + pidOpt.get() + ".";
        }
        catch (IOException e) {
            this.status = 4;
            return "Could not check existing process (" + e.getMessage() + ").";
        }
    }

    public int getStatus() {
        return this.status;
    }

    public static NuxeoLauncher createLauncher(String[] args) throws ParseException, IOException, PackageException {
        CommandLine cmdLine = NuxeoLauncher.parseOptions(args);
        ConfigurationGenerator cg = new ConfigurationGenerator(quiet, debug);
        if (cmdLine.hasOption(OPTION_HIDE_DEPRECATION)) {
            cg.hideDeprecationWarnings(true);
        }
        NuxeoLauncher launcher = new NuxeoLauncher(cg);
        launcher.connectBroker = new ConnectBroker(launcher.configurationGenerator.getEnv());
        launcher.setArgs(cmdLine);
        launcher.initConnectBroker();
        return launcher;
    }

    private void setArgs(CommandLine cmdLine) {
        this.cmdLine = cmdLine;
        this.extractCommandAndParams(cmdLine.getArgs());
        if (cmdLine.hasOption(OPTION_GUI)) {
            this.useGui = Boolean.parseBoolean(ConnectBroker.parseAnswer(cmdLine.getOptionValue(OPTION_GUI)));
            log.debug("GUI: {} -> {}", () -> cmdLine.getOptionValue(OPTION_GUI), () -> this.useGui);
        } else if (OPTION_GUI.equalsIgnoreCase(this.command)) {
            this.useGui = true;
            this.extractCommandAndParams(this.params);
        } else if (SystemUtils.IS_OS_WINDOWS) {
            this.useGui = true;
            log.debug("GUI: option not set - platform is Windows -> start GUI");
        } else {
            this.useGui = false;
            log.debug("GUI: option not set - platform is not Windows -> do not start GUI");
        }
        if (cmdLine.hasOption(OPTION_XML)) {
            this.setXMLOutput();
        }
        if (cmdLine.hasOption(OPTION_JSON)) {
            this.setJSONOutput();
        }
        if (cmdLine.hasOption(OPTION_CLID)) {
            try {
                this.getConnectBroker().setCLID(cmdLine.getOptionValue(OPTION_CLID));
            }
            catch (LogicalInstanceIdentifier.NoCLID e) {
                throw new NuxeoLauncherException("CLID is invalid", 4, e);
            }
        }
        if (cmdLine.hasOption(OPTION_IGNORE_MISSING)) {
            this.ignoreMissing = true;
        }
    }

    private void extractCommandAndParams(String[] args) {
        if (args.length > 0) {
            this.command = args[0];
            log.debug("Launcher command: {}", (Object)this.command);
            if (args.length > 1) {
                this.params = Arrays.copyOfRange(args, 1, args.length);
                log.debug("Command parameters: {}", () -> ArrayUtils.toString(this.params));
            } else {
                this.params = new String[0];
            }
        } else {
            this.command = null;
        }
    }

    protected static void setQuiet() {
        quiet = true;
        Log4JHelper.setLevel(new String[]{""}, Level.WARN, true);
    }

    protected static void setDebug(String[] loggerNames) {
        debug = true;
        if (loggerNames == null) {
            loggerNames = new String[]{"org.nuxeo.launcher"};
        }
        Log4JHelper.setLevel(loggerNames, Level.DEBUG, true);
    }

    protected static void relaxStrict() {
        strict = false;
    }

    protected void setXMLOutput() {
        this.xmlOutput = true;
    }

    protected void setJSONOutput() {
        this.jsonOutput = true;
        this.setXMLOutput();
    }

    public static void printShortHelp() {
        System.out.println();
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("USAGE\n");
        help.setOptionComparator(null);
        help.setWidth(1000);
        help.printHelp(OPTION_HELP_USAGE, "OPTIONS", options, null);
        System.out.println(OPTION_HELP_DESC_COMMANDS);
    }

    public static void printLongHelp() {
        System.out.println();
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("USAGE\n");
        help.setOptionComparator(null);
        help.setWidth(1000);
        help.printHelp(OPTION_HELP_USAGE, OPTION_HELP_HEADER, options, null);
        System.out.println(OPTION_HELP_DESC_ENV);
        System.out.println(OPTION_HELP_DESC_COMMANDS);
        System.out.println(OPTION_HELP_FOOTER);
    }

    public boolean isRunning() {
        try {
            return this.processManager.findPid().isPresent();
        }
        catch (IOException e) {
            log.error(e);
            return false;
        }
    }

    public InstanceInfo getInfo() {
        return this.info;
    }

    public boolean isStarted() {
        boolean isStarted;
        try {
            isStarted = this.isRunning() && this.statusServletClient.isStarted();
        }
        catch (SocketTimeoutException e) {
            isStarted = false;
        }
        return isStarted;
    }

    public String getURL() {
        return this.configurationGenerator.getUserConfig().getProperty("nuxeo.url");
    }

    protected void initConnectBroker() {
        if (this.cmdLine.hasOption(OPTION_ACCEPT)) {
            this.connectBroker.setAccept(this.cmdLine.getOptionValue(OPTION_ACCEPT));
        }
        if (this.cmdLine.hasOption(OPTION_RELAX)) {
            this.connectBroker.setRelax(this.cmdLine.getOptionValue(OPTION_RELAX));
        }
        if (this.cmdLine.hasOption(OPTION_SNAPSHOT)) {
            this.connectBroker.setAllowSNAPSHOT(true);
        }
        try {
            this.clid = this.connectBroker.getCLID();
        }
        catch (LogicalInstanceIdentifier.NoCLID noCLID) {
            // empty catch block
        }
        this.info = this.configurationGenerator.getServerConfigurator().getInfo(this.clid, this.connectBroker.getPkgList());
        if (new Version(this.info.distribution.version).isSnapshot()) {
            this.connectBroker.setAllowSNAPSHOT(true);
        }
        this.connectBroker.setPendingFile(this.configurationGenerator.getInstallFile().toPath());
    }

    protected ConnectBroker getConnectBroker() {
        return this.connectBroker;
    }

    protected ConnectRegistrationBroker getConnectRegistrationBroker() {
        if (this.connectRegistrationBroker == null) {
            this.connectRegistrationBroker = new ConnectRegistrationBroker();
        }
        return this.connectRegistrationBroker;
    }

    protected void pkgList() {
        this.getConnectBroker().listPending(this.configurationGenerator.getInstallFile());
        this.getConnectBroker().pkgList();
    }

    protected void pkgListAll() {
        this.getConnectBroker().listPending(this.configurationGenerator.getInstallFile());
        this.getConnectBroker().pkgListAll();
    }

    protected boolean pkgAdd(String[] pkgNames) {
        return this.getConnectBroker().pkgAdd(Arrays.asList(pkgNames), this.ignoreMissing);
    }

    protected boolean pkgInstall(String[] pkgIDs) {
        boolean cmdOK = true;
        if (this.configurationGenerator.isInstallInProgress()) {
            cmdOK = this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, !this.cmdLine.hasOption(OPTION_NODEPS), this.ignoreMissing);
        }
        return cmdOK && this.getConnectBroker().pkgInstall(Arrays.asList(pkgIDs), this.ignoreMissing);
    }

    protected boolean pkgUninstall(String[] pkgIDs) {
        return this.getConnectBroker().pkgUninstall(Arrays.asList(pkgIDs));
    }

    protected boolean pkgRemove(String[] pkgIDs) {
        return this.getConnectBroker().pkgRemove(Arrays.asList(pkgIDs));
    }

    protected boolean pkgReset() {
        return this.getConnectBroker().pkgReset();
    }

    protected void printInstanceXMLOutput(InstanceInfo instance) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(InstanceInfo.class, DistributionInfo.class, PackageInfo.class, ConfigurationInfo.class, KeyValueInfo.class);
            this.printXMLOutput(jaxbContext, instance, System.out);
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            throw new NuxeoLauncherException("Output serialization failed: " + e.getMessage(), 7, e);
        }
    }

    protected void showConfig() {
        log.info("***** Nuxeo instance configuration *****");
        log.info("NUXEO_CONF: {}", (Object)this.info.NUXEO_CONF);
        log.info("NUXEO_HOME: {}", (Object)this.info.NUXEO_HOME);
        if (this.info.clid != null) {
            log.info("Instance CLID: {}", (Object)this.info.clid);
        }
        log.info("** Distribution");
        log.info("- name: {}", (Object)this.info.distribution.name);
        log.info("- server: {}", (Object)this.info.distribution.server);
        log.info("- version: {}", (Object)this.info.distribution.version);
        log.info("- date: {}", (Object)this.info.distribution.date);
        log.info("- packaging: {}", (Object)this.info.distribution.packaging);
        log.info("** Packages:");
        for (PackageInfo pkg : this.info.packages) {
            log.info("- {} (version: {} - id: {}} - state: {})", (Object)pkg.name, (Object)pkg.version, (Object)pkg.id, (Object)pkg.state.getLabel());
        }
        log.info("** Profiles:");
        for (String profile : this.info.config.profiles) {
            log.info("Profile: {}", (Object)profile);
        }
        log.info("** Templates:");
        log.info("Database template: {}", (Object)this.info.config.dbtemplate);
        for (String template : this.info.config.pkgtemplates) {
            log.info("Package template: {}", (Object)template);
        }
        for (String template : this.info.config.usertemplates) {
            log.info("User template: {}", (Object)template);
        }
        for (String template : this.info.config.basetemplates) {
            log.info("Base template: {}", (Object)template);
        }
        log.info("** Settings from nuxeo.conf:");
        for (KeyValueInfo keyval : this.info.config.keyvals) {
            log.info("{}={}", (Object)keyval.key, (Object)keyval.value);
        }
        log.info("****************************************");
        if (this.xmlOutput) {
            this.printInstanceXMLOutput(this.info);
        }
    }

    protected boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove) {
        boolean cmdOK = true;
        if (this.configurationGenerator.isInstallInProgress()) {
            cmdOK = this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, true, this.ignoreMissing);
        }
        return cmdOK && this.getConnectBroker().pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove, true, this.ignoreMissing);
    }

    protected boolean pkgRefreshCache() {
        this.getConnectBroker().refreshCache();
        return true;
    }

    protected boolean pkgInit() {
        log.warn("The 'mp-init' command is deprecated, no more Nuxeo Packages locally available in the distribution.");
        return true;
    }

    protected boolean pkgPurge() throws PackageException {
        return this.getConnectBroker().pkgPurge();
    }

    protected boolean pkgHotfix() {
        return this.getConnectBroker().pkgHotfix();
    }

    protected boolean pkgUpgrade() {
        return this.getConnectBroker().pkgUpgrade();
    }

    protected boolean pkgCompoundRequest(List<String> request) {
        ArrayList<String> add = new ArrayList<String>();
        ArrayList<String> install = new ArrayList<String>();
        ArrayList<String> uninstall = new ArrayList<String>();
        for (String param : request) {
            for (String subparam : param.split("[ ,]")) {
                if (subparam.charAt(0) == '-') {
                    uninstall.add(subparam.substring(1));
                    continue;
                }
                if (subparam.charAt(0) == '+') {
                    install.add(subparam.substring(1));
                    continue;
                }
                add.add(subparam);
            }
        }
        return this.pkgRequest(add, install, uninstall, null);
    }

    protected boolean pkgSetRequest(List<String> request, boolean nodeps) {
        boolean cmdOK = nodeps ? this.getConnectBroker().pkgSet(request, this.ignoreMissing) : this.getConnectBroker().pkgRequest(null, request, null, null, false, this.ignoreMissing);
        return cmdOK;
    }

    protected boolean pkgShow(String[] packages) {
        return this.getConnectBroker().pkgShow(Arrays.asList(packages));
    }

    static {
        if (System.getProperty("nuxeo.log.dir") == null) {
            System.setProperty("nuxeo.log.dir", ".");
        }
        log = LogManager.getLogger(NuxeoLauncher.class);
        NO_NEW_LINE = MarkerManager.getMarker("NO_NEW_LINE");
        options = NuxeoLauncher.initParserOptions();
        COMMANDS_NO_GUI = new String[]{"configure", "mp-purge", "mp-add", "mp-install", "mp-uninstall", "mp-request", "mp-remove", "mp-hotfix", "mp-upgrade", "mp-reset", "mp-list", "mp-listall", "mp-update", "status", "showconf", "mp-show", "mp-set", "config", OPTION_ENCRYPT, "decrypt", OPTION_HELP, "register", "register-trial"};
        COMMANDS_NO_RUNNING_SERVER = new String[]{"mp-purge", "mp-add", "mp-install", "mp-uninstall", "mp-request", "mp-remove", "mp-hotfix", "mp-upgrade", "mp-reset", "mp-update", "mp-set"};
        OPTION_HELP_DESC_ENV = "\nENVIRONMENT VARIABLES\n        NUXEO_HOME\t\tPath to server root directory.\n        NUXEO_CONF\t\tPath to {{nuxeo.conf}} file.\n        PATH\n\tJAVA\t\t\tPath to the {{java}} executable.\n        JAVA_HOME\t\tPath to the Java home directory. Can also be defined in {{nuxeo.conf}}.\n        JAVA_OPTS\t\tOptional values passed to the JVM. Can also be defined in {{nuxeo.conf}}.\n        REQUIRED_JAVA_VERSION\tNuxeo requirement on Java version.\n\nJAVA USAGE\n" + String.format("        java [-D%s=\"JVM options\"] [-D%s=\"/path/to/nuxeo\"] [-D%s=\"/path/to/nuxeo.conf\"] [-Djvmcheck=nofail] -jar \"path/to/nuxeo-launcher.jar\" \\\n        \t[options] <command> [command parameters]\n\n", JAVA_OPTS_PROPERTY, "nuxeo.home", "nuxeo.conf") + String.format("        %s\tParameters for the server JVM (default are %s).\n", JAVA_OPTS_PROPERTY, JAVA_OPTS_DEFAULT) + String.format("        %s\t\tNuxeo server root path (default is parent of called script).\n", "nuxeo.home") + String.format("        %s\t\tPath to {{%1$s}} file (default is \"$NUXEO_HOME/bin/%1$s\").\n", "nuxeo.conf") + "        jvmcheck\t\tIf set to \"nofail\", ignore JVM version validation errors.\n";
        quiet = false;
        debug = false;
        strict = true;
    }

    protected static class ShutdownHook
    extends Thread
    implements AutoCloseable {
        private final NuxeoLauncher launcher;

        public ShutdownHook(NuxeoLauncher launcher) {
            log.debug("Add shutdown hook");
            this.launcher = launcher;
            Runtime.getRuntime().addShutdownHook(this);
        }

        @Override
        public void run() {
            log.info("Shutting down...");
            if (this.launcher.isRunning()) {
                this.launcher.doStop();
            }
            log.info("Shutdown complete.");
        }

        @Override
        public void close() {
            try {
                Runtime.getRuntime().removeShutdownHook(this);
                log.debug("Removed shutdown hook");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

