/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;

public class CompositeTypeImpl
extends ComplexTypeImpl
implements CompositeType {
    private static final long serialVersionUID = 1L;
    protected Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();

    public CompositeTypeImpl(CompositeType superType, String schema, String name, List<Schema> schemaList) {
        super(superType, schema, name);
        if (schemaList == null) {
            schemaList = Collections.emptyList();
        }
        for (Schema s : schemaList) {
            this.schemas.put(s.getName(), s);
            for (Field field : s.getFields()) {
                this.addField(field);
            }
        }
    }

    @Override
    public boolean hasSchemas() {
        return !this.schemas.isEmpty();
    }

    @Override
    public Schema getSchema(String name) {
        return this.schemas.get(name);
    }

    @Override
    public boolean hasSchema(String name) {
        return this.schemas.containsKey(name);
    }

    @Override
    public String[] getSchemaNames() {
        return this.schemas.keySet().toArray(new String[0]);
    }

    @Override
    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    @Override
    public Field getField(QName name) {
        return (Field)this.fieldsByName.get(name.getPrefixedName());
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isCompositeType() {
        return true;
    }
}

