/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.time.ZonedDateTime;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.core.BucketRange;

public class BucketRangeDate
implements Bucket {
    private final BucketRange range;
    private final ZonedDateTime fromDate;
    private final ZonedDateTime toDate;

    public BucketRangeDate(String key, ZonedDateTime from, ZonedDateTime to, long docCount) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.range = new BucketRange(key, from != null ? Long.valueOf(from.toInstant().toEpochMilli()) : null, to != null ? Long.valueOf(to.toInstant().toEpochMilli()) : null, docCount);
        this.fromDate = from;
        this.toDate = to;
    }

    public String getKey() {
        return this.range.getKey();
    }

    public long getDocCount() {
        return this.range.getDocCount();
    }

    public Double getFrom() {
        return this.range.getFrom();
    }

    public ZonedDateTime getFromAsDate() {
        return this.fromDate;
    }

    public Double getTo() {
        return this.range.getTo();
    }

    public ZonedDateTime getToAsDate() {
        return this.toDate;
    }

    public String toString() {
        return String.format("BucketRangeDate(%s, %d, %s, %s)", this.getKey(), this.getDocCount(), this.fromDate, this.toDate);
    }
}

