/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.primitives;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.schema.types.Field;

public class BinaryProperty
extends ScalarProperty {
    private static final long serialVersionUID = 1L;

    public BinaryProperty(Property parent, Field field, int flags) {
        super(parent, field, flags);
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value instanceof InputStream;
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        throw new PropertyConversionException(value.getClass(), InputStream.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        if (value == null) {
            return null;
        }
        if (InputStream.class.isAssignableFrom(toType)) {
            return (T)value;
        }
        if (toType == String.class && value instanceof InputStream) {
            try (InputStream in = (InputStream)((Object)value);){
                String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                return (T)string;
            }
            catch (IOException e) {
                throw new InvalidPropertyValueException("Failed to read given input stream", e);
            }
        }
        if (toType != byte[].class) throw new PropertyConversionException(value.getClass(), toType);
        if (!(value instanceof InputStream)) throw new PropertyConversionException(value.getClass(), toType);
        try {
            return (T)IOUtils.toByteArray((InputStream)((InputStream)((Object)value)));
        }
        catch (IOException e) {
            throw new InvalidPropertyValueException("Failed to read given input stream", e);
        }
    }

    @Override
    public Object newInstance() {
        return new ByteArrayInputStream("".getBytes());
    }
}

