/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.Externalizable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogOffsetTracker;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;
import org.nuxeo.lib.stream.log.internals.LogOffsetImpl;
import org.nuxeo.lib.stream.log.internals.LogPartitionGroup;

public class ChronicleLogTailer<M extends Externalizable>
implements LogTailer<M> {
    protected static final long POLL_INTERVAL_MS = 100L;
    protected static final Set<LogPartitionGroup> tailersId = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Log log = LogFactory.getLog(ChronicleLogTailer.class);
    protected final String basePath;
    protected final ExcerptTailer cqTailer;
    protected final ChronicleLogOffsetTracker offsetTracker;
    protected final LogPartitionGroup id;
    protected final LogPartition partition;
    protected final Codec<M> codec;
    protected volatile boolean closed = false;

    public ChronicleLogTailer(Codec<M> codec, String basePath, ExcerptTailer cqTailer, LogPartition partition, Name group, ChronicleRetentionDuration retention) {
        Objects.requireNonNull(group);
        this.codec = codec;
        this.basePath = basePath;
        this.cqTailer = cqTailer;
        this.partition = partition;
        this.id = new LogPartitionGroup(group, partition.name(), partition.partition());
        this.registerTailer();
        this.offsetTracker = new ChronicleLogOffsetTracker(basePath, partition.partition(), group, retention);
        this.toLastCommitted();
    }

    protected void registerTailer() {
        if (!tailersId.add(this.id)) {
            throw new IllegalArgumentException("A tailer for this queue and namespace already exists: " + this.id);
        }
    }

    protected void unregisterTailer() {
        tailersId.remove(this.id);
    }

    @Override
    public LogRecord<M> read(Duration timeout) throws InterruptedException {
        LogRecord<M> ret = this.read();
        if (ret != null) {
            return ret;
        }
        long timeoutMs = timeout.toMillis();
        long deadline = System.currentTimeMillis() + timeoutMs;
        long delay = Math.min(100L, timeoutMs);
        while (ret == null && System.currentTimeMillis() < deadline) {
            Thread.sleep(delay);
            ret = this.read();
        }
        return ret;
    }

    protected LogRecord<M> read() {
        AtomicLong offset;
        ArrayList value;
        block6: {
            if (this.closed) {
                throw new IllegalStateException("The tailer has been closed.");
            }
            value = new ArrayList(1);
            offset = new AtomicLong();
            if (NoCodec.NO_CODEC.equals(this.codec)) {
                try {
                    if (!this.cqTailer.readDocument(w -> {
                        offset.set(this.cqTailer.index());
                        value.add((Externalizable)w.read("msg").object());
                    })) {
                        return null;
                    }
                    break block6;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (!this.cqTailer.readDocument(w -> {
                offset.set(this.cqTailer.index());
                value.add((Externalizable)this.codec.decode(w.read().bytes()));
            })) {
                return null;
            }
        }
        return new LogRecord<Externalizable>((Externalizable)value.get(0), new LogOffsetImpl(this.partition, offset.get()));
    }

    @Override
    public LogOffset commit(LogPartition partition) {
        if (!this.partition.equals(partition)) {
            throw new IllegalArgumentException("Cannot commit this partition: " + partition + " from " + this.id);
        }
        long offset = this.cqTailer.index();
        this.offsetTracker.commit(offset);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Commit %s:+%d", this.id, offset));
        }
        return new LogOffsetImpl(partition, offset);
    }

    @Override
    public void commit() {
        this.commit(this.partition);
    }

    @Override
    public void toEnd() {
        log.debug((Object)String.format("toEnd: %s", this.id));
        this.cqTailer.toEnd();
    }

    @Override
    public void toStart() {
        log.debug((Object)String.format("toStart: %s", this.id));
        this.cqTailer.toStart();
        if (!this.cqTailer.state().equals((Object)TailerState.FOUND_CYCLE)) {
            log.info((Object)("Unable to move to start because the tailer is not initialized, " + this));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void toLastCommitted() {
        long offset = this.offsetTracker.getLastCommittedOffset();
        if (offset > 0L) {
            log.debug((Object)String.format("toLastCommitted: %s, found: %d", this.id, offset));
            if (this.cqTailer.moveToIndex(offset) || this.cqTailer.index() == offset) return;
            this.toStart();
            long startOffset = this.cqTailer.index();
            if (offset >= startOffset) throw new IllegalStateException("Unable to move to the last committed offset: " + offset + " for tailer: " + this);
            log.error((Object)("The last committed offset: " + offset + " for tailer: " + this + " points to a record that has been deleted by the retention policy. Records have been lost, continuing from the beginning of the partition offset: " + startOffset));
            return;
        } else {
            log.debug((Object)String.format("toLastCommitted: %s, not found, move toStart", this.id));
            this.cqTailer.toStart();
        }
    }

    @Override
    public void seek(LogOffset offset) {
        if (!this.partition.equals(offset.partition())) {
            throw new IllegalStateException("Cannot seek, tailer " + this + " has no assignment for partition: " + offset);
        }
        log.debug((Object)("Seek to " + offset + " from tailer: " + this));
        if (!this.cqTailer.moveToIndex(offset.offset()) && this.cqTailer.index() != offset.offset()) {
            throw new IllegalStateException("Unable to seek to offset, " + this + " offset: " + offset);
        }
    }

    @Override
    public void reset() {
        this.reset(new LogPartition(this.id.name, this.id.partition));
    }

    @Override
    public void reset(LogPartition partition) {
        if (!this.partition.equals(partition)) {
            throw new IllegalArgumentException("Cannot reset this partition: " + partition + " from " + this.id);
        }
        log.info((Object)("Reset offset for partition: " + partition + " from tailer: " + this));
        this.cqTailer.toStart();
        this.commit(partition);
    }

    @Override
    public LogOffset offsetForTimestamp(LogPartition partition, long timestamp) {
        throw new UnsupportedOperationException("ChronicleLog does not support seek by timestamp");
    }

    @Override
    public Collection<LogPartition> assignments() {
        return Collections.singletonList(new LogPartition(this.id.name, this.id.partition));
    }

    @Override
    public Name group() {
        return this.id.group;
    }

    @Override
    public void close() {
        if (!this.closed) {
            log.debug((Object)("Closing: " + this.toString()));
            this.offsetTracker.close();
            this.unregisterTailer();
            this.closed = true;
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    public Codec<M> getCodec() {
        return this.codec;
    }

    public String toString() {
        return "ChronicleLogTailer{basePath='" + this.basePath + "', id=" + this.id + ", closed=" + this.closed + ", codec=" + this.codec + "}";
    }
}

