/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.nio.file.Paths;
import java.time.Duration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.tools.command.Command;
import org.nuxeo.lib.stream.tools.renderer.Renderer;

public class CatCommand
extends Command {
    protected static final String NUXEO_SCHEMA_STORE = "nxserver/data/avro";
    protected static final String NAME = "cat";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"n").longOpt("lines").desc("Render the first N records").hasArg().argName("N").build());
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"g").longOpt("group").desc("Consumer group").hasArg().argName("GROUP").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to read record, can be: java, avro, avroBinary, avroJson").hasArg().argName("CODEC").build());
        options.addOption(Option.builder().longOpt("data-size").desc("Maximum size of message data to render").hasArg().argName("L").build());
        options.addOption(Option.builder().longOpt("render").desc("Output rendering").hasArg().argName("FORMAT").build());
        options.addOption(Option.builder().longOpt("schema-store").desc("Set path of a FileAvroSchemaStore to load Avro schemas").hasArg().argName("SCHEMA_STORE_PATH").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        int limit = Integer.parseInt(cmd.getOptionValue("lines", "-1"));
        int dataSize = Integer.parseInt(cmd.getOptionValue("data-size", "256"));
        Name name = Name.ofUrn(cmd.getOptionValue("log-name"));
        String render = cmd.getOptionValue("render", "default");
        Name group = Name.ofUrn(cmd.getOptionValue("group", "admin/tools"));
        String codec = cmd.getOptionValue("codec");
        String avroSchemaStorePath = cmd.getOptionValue("schema-store");
        if (avroSchemaStorePath == null && Paths.get(NUXEO_SCHEMA_STORE, new String[0]).toFile().exists()) {
            avroSchemaStorePath = NUXEO_SCHEMA_STORE;
        }
        this.cat(manager, name, group, limit, this.getRecordRenderer(render, avroSchemaStorePath, dataSize), codec);
        return true;
    }

    protected void cat(LogManager manager, Name name, Name group, int limit, Renderer render, String codec) throws InterruptedException {
        render.header();
        try (LogTailer<Record> tailer = manager.createTailer(group, name, this.getRecordCodec(codec));){
            int count = 0;
            do {
                LogRecord<Record> record;
                if ((record = tailer.read(Duration.ofMillis(1000L))) == null) {
                    break;
                }
                render.accept(record);
            } while (limit < 0 || ++count < limit);
        }
        render.footer();
    }
}

