/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog.transport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.coursera.metrics.datadog.model.DatadogCounter;
import org.coursera.metrics.datadog.model.DatadogGauge;
import org.coursera.metrics.datadog.transport.Transport;
import org.coursera.metrics.serializer.JsonSerializer;
import org.coursera.metrics.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransport.class);
    private static final String BASE_URL = "https://app.datadoghq.com/api/v1";
    private final String seriesUrl;
    private final int connectTimeout;
    private final int socketTimeout;
    private final HttpHost proxy;
    private final Executor executor;
    private final boolean useCompression;

    private HttpTransport(String apiKey, int connectTimeout, int socketTimeout, HttpHost proxy, Executor executor, boolean useCompression) {
        this.seriesUrl = String.format("%s/series?api_key=%s", BASE_URL, apiKey);
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.proxy = proxy;
        this.useCompression = useCompression;
        this.executor = executor != null ? executor : Executor.newInstance();
    }

    @Override
    public Transport.Request prepare() throws IOException {
        return new HttpRequest(this);
    }

    @Override
    public void close() throws IOException {
    }

    public static class HttpRequest
    implements Transport.Request {
        protected final Serializer serializer;
        protected final HttpTransport transport;

        public HttpRequest(HttpTransport transport) throws IOException {
            this.transport = transport;
            this.serializer = new JsonSerializer();
            this.serializer.startObject();
        }

        @Override
        public void addGauge(DatadogGauge gauge) throws IOException {
            this.serializer.appendGauge(gauge);
        }

        @Override
        public void addCounter(DatadogCounter counter) throws IOException {
            this.serializer.appendCounter(counter);
        }

        @Override
        public void send() throws Exception {
            this.serializer.endObject();
            String postBody = this.serializer.getAsString();
            if (LOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Sending HTTP POST request to ");
                sb.append(this.transport.seriesUrl);
                sb.append(", uncompressed POST body length is: ");
                sb.append(postBody.length());
                LOG.debug(sb.toString());
                StringBuilder bodyMsgBuilder = new StringBuilder();
                bodyMsgBuilder.append("Uncompressed POST body is: \n").append(postBody);
                LOG.debug(bodyMsgBuilder.toString());
            }
            long start = System.currentTimeMillis();
            Request request = Request.Post((String)this.transport.seriesUrl).useExpectContinue().connectTimeout(this.transport.connectTimeout).socketTimeout(this.transport.socketTimeout);
            if (this.transport.useCompression) {
                request.addHeader("Content-Encoding", "deflate").addHeader("Content-MD5", DigestUtils.md5Hex((String)postBody)).bodyStream(HttpRequest.deflated(postBody), ContentType.APPLICATION_JSON);
            } else {
                request.bodyString(postBody, ContentType.APPLICATION_JSON);
            }
            if (this.transport.proxy != null) {
                request.viaProxy(this.transport.proxy);
            }
            Response response = this.transport.executor.execute(request);
            final long elapsed = System.currentTimeMillis() - start;
            if (LOG.isWarnEnabled()) {
                response.handleResponse((ResponseHandler)new ResponseHandler<Void>(){

                    public Void handleResponse(HttpResponse response) throws IOException {
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode >= 400) {
                            LOG.warn(this.getLogMessage("Failure sending metrics to Datadog: ", response));
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug(this.getLogMessage("Sent metrics to Datadog: ", response));
                        }
                        return null;
                    }

                    private String getLogMessage(String headline, HttpResponse response) throws IOException {
                        StringBuilder sb = new StringBuilder();
                        sb.append(headline);
                        sb.append("\n");
                        sb.append("  Timing: ").append(elapsed).append(" ms\n");
                        sb.append("  Status: ").append(response.getStatusLine().getStatusCode()).append("\n");
                        String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                        sb.append("  Content: ").append(content);
                        return sb.toString();
                    }
                });
            } else {
                response.discardContent();
            }
        }

        private static InputStream deflated(String str) throws IOException {
            if (str == null || str.length() == 0) {
                return new ByteArrayInputStream(new byte[0]);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(str.getBytes("UTF-8"));
            return new DeflaterInputStream(inputStream){

                @Override
                public void close() throws IOException {
                    if (LOG.isDebugEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        long bytesWritten = this.def.getBytesWritten();
                        long bytesRead = this.def.getBytesRead();
                        sb.append("POST body length compressed / uncompressed / compression ratio: ");
                        sb.append(bytesWritten);
                        sb.append(" / ");
                        sb.append(bytesRead);
                        sb.append(" / ");
                        sb.append(String.format("%.2f", (double)bytesRead / (double)bytesWritten));
                        LOG.debug(sb.toString());
                    }
                    super.close();
                }
            };
        }
    }

    public static class Builder {
        String apiKey;
        int connectTimeout = 5000;
        int socketTimeout = 5000;
        HttpHost proxy;
        Executor executor;
        boolean useCompression = false;

        public Builder withApiKey(String key) {
            this.apiKey = key;
            return this;
        }

        public Builder withConnectTimeout(int milliseconds) {
            this.connectTimeout = milliseconds;
            return this;
        }

        public Builder withSocketTimeout(int milliseconds) {
            this.socketTimeout = milliseconds;
            return this;
        }

        public Builder withProxy(String proxyHost, int proxyPort) {
            this.proxy = new HttpHost(proxyHost, proxyPort);
            return this;
        }

        public Builder withExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder withCompression(boolean compression) {
            this.useCompression = compression;
            return this;
        }

        public HttpTransport build() {
            return new HttpTransport(this.apiKey, this.connectTimeout, this.socketTimeout, this.proxy, this.executor, this.useCompression);
        }
    }
}

