/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.extensions;

import java.util.List;
import org.dom4j.Element;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.io.ExportExtension;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;

public class VersionInfoExportExtension
implements ExportExtension {
    @Override
    public void updateExport(DocumentModel docModel, ExportedDocumentImpl result) throws Exception {
        Element versionElement = result.getDocument().getRootElement().addElement("version");
        if (docModel.isVersion()) {
            versionElement.addElement("isVersion").setText("true");
            versionElement.addElement("ecm:versionLabel".substring(4)).setText(docModel.getVersionLabel());
            String sourceId = docModel.getSourceId();
            versionElement.addElement("ecm:versionableId".substring(4)).setText(sourceId);
            DocumentModel liveDocument = docModel.getCoreSession().getSourceDocument(docModel.getRef());
            List versions = docModel.getCoreSession().getVersionsForDocument(liveDocument.getRef());
            for (VersionModel version : versions) {
                if (!docModel.getVersionLabel().equals(version.getLabel())) continue;
                String description = version.getDescription();
                if (description != null) {
                    versionElement.addElement("ecm:versionDescription".substring(4)).setText(description);
                }
                if (version.getCreated() == null) break;
                String created = new DateType().encode((Object)version.getCreated());
                versionElement.addElement("ecm:versionCreated".substring(4)).setText(created);
                break;
            }
        }
    }
}

