/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentWriter;

public class XMLDirectoryWriter
extends AbstractDocumentWriter {
    private File destination;
    protected boolean skipBlobs = false;

    public XMLDirectoryWriter(String destinationPath) {
        this(new File(destinationPath));
    }

    public XMLDirectoryWriter(File destination) {
        this.destination = destination;
    }

    public boolean skipBlobs() {
        return this.skipBlobs;
    }

    public void setSkipBlobs(boolean skipBlobs) {
        this.skipBlobs = skipBlobs;
    }

    public Object getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    @Override
    public void close() {
        this.destination = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentTranslationMap write(ExportedDocument doc) throws IOException {
        File file = new File(this.getDestination() + File.separator + doc.getPath().toString());
        if (!file.mkdirs()) {
            throw new IOException("Cannot create target directory: " + file.getAbsolutePath());
        }
        OutputFormat format = AbstractDocumentWriter.createPrettyPrint();
        try (XMLWriter writer = null;){
            writer = new XMLWriter((OutputStream)new FileOutputStream(file.getAbsolutePath() + File.separator + "document.xml"), format);
            writer.write(doc.getDocument());
        }
        if (!this.skipBlobs) {
            Map<String, Blob> blobs = doc.getBlobs();
            for (Map.Entry<String, Blob> entry : blobs.entrySet()) {
                String blobPath = file.getAbsolutePath() + File.separator + entry.getKey();
                entry.getValue().transferTo(new File(blobPath));
            }
        }
        for (Map.Entry<String, Document> entry : doc.getDocuments().entrySet()) {
            writer = null;
            try {
                writer = new XMLWriter((OutputStream)new FileOutputStream(file.getAbsolutePath() + File.separator + entry.getKey() + ".xml"), format);
                writer.write(entry.getValue());
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
        return null;
    }
}

