/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.multi.FieldDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectoryExpressionEvaluator;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class MultiDirectorySession
extends BaseSession {
    private static final Log log = LogFactory.getLog(MultiDirectorySession.class);
    private final DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
    private final String schemaIdField;
    private List<SourceInfo> sourceInfos;

    public MultiDirectorySession(MultiDirectory directory) {
        super((Directory)directory, null);
        MultiDirectoryDescriptor descriptor = directory.getDescriptor();
        this.schemaIdField = descriptor.idField;
    }

    public MultiDirectory getDirectory() {
        return (MultiDirectory)this.directory;
    }

    private void init() {
        if (this.sourceInfos == null) {
            this.recomputeSourceInfos();
        }
    }

    private void recomputeSourceInfos() {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Schema schema = schemaManager.getSchema(this.schemaName);
        if (schema == null) {
            throw new DirectoryException(String.format("Directory '%s' has unknown schema '%s'", this.getName(), this.schemaName));
        }
        HashSet<String> sourceFields = new HashSet<String>();
        for (Field f : schema.getFields()) {
            sourceFields.add(f.getName().getLocalName());
        }
        if (!sourceFields.contains(this.schemaIdField)) {
            throw new DirectoryException(String.format("Directory '%s' schema '%s' has no id field '%s'", this.getName(), this.schemaName, this.schemaIdField));
        }
        ArrayList<SourceInfo> newSourceInfos = new ArrayList<SourceInfo>(2);
        for (SourceDescriptor source : this.getDirectory().getDescriptor().sources) {
            int ndirs = source.subDirectories.length;
            if (ndirs == 0) {
                throw new DirectoryException(String.format("Directory '%s' source '%s' has no subdirectories", this.getName(), source.name));
            }
            ArrayList<SubDirectoryInfo> subDirectoryInfos = new ArrayList<SubDirectoryInfo>(ndirs);
            SubDirectoryInfo authDirectoryInfo = null;
            boolean hasRequiredDir = false;
            for (SubDirectoryDescriptor subDir : source.subDirectories) {
                String dirName = subDir.name;
                String dirSchemaName = this.directoryService.getDirectorySchema(dirName);
                String dirIdField = this.directoryService.getDirectoryIdField(dirName);
                boolean dirIsAuth = this.directoryService.getDirectoryPasswordField(dirName) != null;
                HashMap<String, String> fromSource = new HashMap<String, String>();
                HashMap<String, String> toSource = new HashMap<String, String>();
                HashMap<String, Serializable> defaultEntry = new HashMap<String, Serializable>();
                boolean dirIsOptional = subDir.isOptional;
                Schema dirSchema = schemaManager.getSchema(dirSchemaName);
                if (dirSchema == null) {
                    throw new DirectoryException(String.format("Directory '%s' source '%s' subdirectory '%s' has unknown schema '%s'", this.getName(), source.name, dirName, dirSchemaName));
                }
                HashSet<String> dirSchemaFields = new HashSet<String>();
                for (Field f : dirSchema.getFields()) {
                    String fieldName = f.getName().getLocalName();
                    dirSchemaFields.add(fieldName);
                    if (sourceFields.contains(fieldName)) {
                        fromSource.put(fieldName, fieldName);
                        toSource.put(fieldName, fieldName);
                    }
                    defaultEntry.put(fieldName, (Serializable)f.getDefaultValue());
                }
                for (FieldDescriptor field : subDir.fields) {
                    String sourceFieldName = field.forField;
                    String fieldName = field.name;
                    if (!sourceFields.contains(sourceFieldName)) {
                        throw new DirectoryException(String.format("Directory '%s' source '%s' subdirectory '%s' has mapping for unknown field '%s'", this.getName(), source.name, dirName, sourceFieldName));
                    }
                    if (!dirSchemaFields.contains(fieldName)) {
                        throw new DirectoryException(String.format("Directory '%s' source '%s' subdirectory '%s' has mapping of unknown field' '%s'", this.getName(), source.name, dirName, fieldName));
                    }
                    fromSource.put(sourceFieldName, fieldName);
                    toSource.put(fieldName, sourceFieldName);
                }
                SubDirectoryInfo subDirectoryInfo = new SubDirectoryInfo(dirName, dirSchemaName, dirIdField, dirIsAuth, fromSource, toSource, defaultEntry, dirIsOptional);
                subDirectoryInfos.add(subDirectoryInfo);
                if (dirIsAuth) {
                    if (authDirectoryInfo != null) {
                        throw new DirectoryException(String.format("Directory '%s' source '%s' has two subdirectories with a password field, '%s' and '%s'", this.getName(), source.name, authDirectoryInfo.dirName, dirName));
                    }
                    authDirectoryInfo = subDirectoryInfo;
                }
                if (dirIsOptional) continue;
                hasRequiredDir = true;
            }
            if (this.isAuthenticating() && authDirectoryInfo == null) {
                throw new DirectoryException(String.format("Directory '%s' source '%s' has no subdirectory with a password field", this.getName(), source.name));
            }
            if (!hasRequiredDir) {
                throw new DirectoryException(String.format("Directory '%s' source '%s' only has optional subdirectories: no directory can be used has a reference.", this.getName(), source.name));
            }
            newSourceInfos.add(new SourceInfo(source, subDirectoryInfos, authDirectoryInfo));
        }
        this.sourceInfos = newSourceInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.sourceInfos == null) {
                return;
            }
            DirectoryException exc = null;
            for (SourceInfo sourceInfo : this.sourceInfos) {
                for (SubDirectoryInfo subDirectoryInfo : sourceInfo.subDirectoryInfos) {
                    Session session = subDirectoryInfo.session;
                    subDirectoryInfo.session = null;
                    if (session == null) continue;
                    try {
                        session.close();
                    }
                    catch (DirectoryException e) {
                        if (exc == null) {
                            exc = e;
                            continue;
                        }
                        log.error((Object)("Error closing directory " + subDirectoryInfo.dirName), (Throwable)e);
                    }
                }
                if (exc == null) continue;
                throw exc;
            }
        }
        finally {
            this.getDirectory().removeSession((Session)this);
        }
    }

    public String getName() {
        return this.directory.getName();
    }

    public boolean authenticate(String username, String password) {
        this.init();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                String passwordField;
                String defaultPassword;
                if (!dirInfo.isAuthenticating) continue;
                if (dirInfo.getSession().authenticate(username, password)) {
                    return true;
                }
                if (!dirInfo.isOptional || dirInfo.getSession().getEntry(username) != null || (defaultPassword = (String)((Object)dirInfo.defaultEntry.get(passwordField = dirInfo.getSession().getPasswordField()))) == null || !defaultPassword.equals(password)) continue;
                return true;
            }
        }
        return false;
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) {
        if (!this.hasPermission("Read")) {
            return null;
        }
        this.init();
        String entryId = id;
        block4: for (SourceInfo sourceInfo : this.sourceInfos) {
            boolean isReadOnlyEntry = true;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                DocumentModel entry = dirInfo.getSession().getEntry(id, fetchReferences);
                boolean isOptional = dirInfo.isOptional;
                if (entry == null && !isOptional) continue block4;
                if (entry != null && !MultiDirectorySession.isReadOnlyEntry((DocumentModel)entry)) {
                    isReadOnlyEntry = false;
                }
                if (entry == null && isOptional && !dirInfo.getSession().isReadOnly()) {
                    isReadOnlyEntry = false;
                }
                if (entry != null && StringUtils.isNotBlank((CharSequence)entry.getId())) {
                    entryId = entry.getId();
                }
                String passwordField = dirInfo.getSession().getPasswordField();
                for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                    String dirProp = e.getKey();
                    if (dirProp.equals(passwordField)) continue;
                    String prop = e.getValue();
                    if (entry != null) {
                        try {
                            map.put(prop, entry.getProperty(dirInfo.dirSchemaName, dirProp));
                            continue;
                        }
                        catch (PropertyException e1) {
                            throw new DirectoryException((Throwable)e1);
                        }
                    }
                    if (map.containsKey(prop)) continue;
                    map.put(prop, dirInfo.defaultEntry.get(dirProp));
                }
            }
            if (this.isReadOnly()) {
                isReadOnlyEntry = true;
            }
            try {
                return BaseSession.createEntryModel(null, (String)this.schemaName, (String)entryId, map, (boolean)isReadOnlyEntry);
            }
            catch (PropertyException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        return null;
    }

    public DocumentModelList getEntries() {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        this.init();
        DocumentModelListImpl results = new DocumentModelListImpl();
        HashMap<String, String> seen = new HashMap<String, String>();
        HashSet<String> readOnlyEntries = new HashSet<String>();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            Map<String, Serializable> map;
            DocumentModelList entries;
            HashMap maps = new HashMap();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (SubDirectoryInfo dirInfo : sourceInfo.requiredSubDirectoryInfos) {
                entries = dirInfo.getSession().getEntries();
                for (Object entry : entries) {
                    String id = entry.getId();
                    map = (HashMap)maps.get(id);
                    if (map == null) {
                        map = new HashMap();
                        maps.put(id, map);
                        counts.put(id, 1);
                    } else {
                        counts.put(id, (Integer)counts.get(id) + 1);
                    }
                    for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                        map.put((String)e.getValue(), (Serializable)entry.getProperty(dirInfo.dirSchemaName, e.getKey()));
                    }
                    if (!BaseSession.isReadOnlyEntry((DocumentModel)entry)) continue;
                    readOnlyEntries.add(id);
                }
            }
            for (SubDirectoryInfo dirInfo : sourceInfo.optionalSubDirectoryInfos) {
                Object entry;
                entries = dirInfo.getSession().getEntries();
                HashSet<String> existingIds = new HashSet<String>();
                for (DocumentModel entry2 : entries) {
                    String id = entry2.getId();
                    Map map2 = (Map)maps.get(id);
                    if (map2 != null) {
                        Map.Entry<String, String> e;
                        existingIds.add(id);
                        e = dirInfo.toSource.entrySet().iterator();
                        while (e.hasNext()) {
                            Map.Entry e2 = (Map.Entry)e.next();
                            map2.put((String)e2.getValue(), entry2.getProperty(dirInfo.dirSchemaName, (String)e2.getKey()));
                        }
                        continue;
                    }
                    log.warn((Object)String.format("Entry '%s' for source '%s' is present in optional directory '%s' but not in any required one. It will be skipped.", id, sourceInfo.source.name, dirInfo.dirName));
                }
                entry = maps.entrySet().iterator();
                while (entry.hasNext()) {
                    Map.Entry mapEntry = (Map.Entry)entry.next();
                    if (existingIds.contains(mapEntry.getKey())) continue;
                    map = (Map)mapEntry.getValue();
                    for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                        if (map.containsKey(e.getValue())) continue;
                        map.put(e.getValue(), dirInfo.defaultEntry.get(e.getKey()));
                    }
                }
            }
            int numdirs = sourceInfo.requiredSubDirectoryInfos.size();
            ((ArrayList)results).ensureCapacity(results.size() + maps.size());
            for (Map.Entry e : maps.entrySet()) {
                DocumentModel entry2;
                String id = (String)e.getKey();
                if (seen.containsKey(id)) {
                    log.warn((Object)String.format("Entry '%s' is present in source '%s' but also in source '%s'. The second one will be ignored.", id, seen.get(id), sourceInfo.source.name));
                    continue;
                }
                Map map3 = (Map)e.getValue();
                if ((Integer)counts.get(id) != numdirs) {
                    log.warn((Object)String.format("Entry '%s' for source '%s' is not present in all directories. It will be skipped.", id, sourceInfo.source.name));
                    continue;
                }
                seen.put(id, sourceInfo.source.name);
                entry2 = BaseSession.createEntryModel(null, (String)this.schemaName, (String)id, (Map)map3, (boolean)readOnlyEntries.contains(id));
                results.add((Object)entry2);
            }
        }
        return results;
    }

    public DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) {
        this.init();
        Object rawid = fieldMap.get(this.schemaIdField);
        if (rawid == null) {
            throw new DirectoryException(String.format("Entry is missing id field '%s'", this.schemaIdField));
        }
        String id = String.valueOf(rawid);
        for (SourceInfo sourceInfo : this.sourceInfos) {
            if (!sourceInfo.source.creation) continue;
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(dirInfo.idField, id);
                for (Map.Entry<String, String> e : dirInfo.fromSource.entrySet()) {
                    map.put(e.getValue(), fieldMap.get(e.getKey()));
                }
                dirInfo.getSession().createEntry(map);
            }
            return this.getEntry(id);
        }
        throw new DirectoryException(String.format("Directory '%s' has no source allowing creation", this.getName()));
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) {
        throw new UnsupportedOperationException();
    }

    protected void deleteEntryWithoutReferences(String id) {
        throw new UnsupportedOperationException();
    }

    public void deleteEntry(DocumentModel docModel) {
        this.deleteEntry(docModel.getId());
    }

    public void deleteEntry(String id) {
        this.checkPermission("Write");
        this.checkDeleteConstraints(id);
        this.init();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                if (dirInfo.getSession().isReadOnly()) continue;
                if (!sourceInfo.source.creation) {
                    DocumentModel docModel = dirInfo.getSession().getEntry(id);
                    if (docModel == null) {
                        log.warn((Object)String.format("MultiDirectory '%s' : The entry id '%s' could not be deleted on subdirectory '%s' because it does not exist", this.getName(), id, dirInfo.dirName));
                        continue;
                    }
                    dirInfo.getSession().deleteEntry(id);
                    continue;
                }
                dirInfo.getSession().deleteEntry(id);
            }
        }
    }

    public void deleteEntry(String id, Map<String, String> map) {
        log.warn((Object)"Calling deleteEntry extended on multi directory");
        this.deleteEntry(id);
    }

    private static void updateSubDirectoryEntry(SubDirectoryInfo dirInfo, Map<String, Object> fieldMap, String id, boolean canCreateIfOptional) {
        DocumentModel dirEntry = dirInfo.getSession().getEntry(id);
        if (dirInfo.getSession().isReadOnly() || dirEntry != null && MultiDirectorySession.isReadOnlyEntry((DocumentModel)dirEntry)) {
            return;
        }
        if (dirEntry == null && !canCreateIfOptional) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(dirInfo.idField, id);
        for (Map.Entry<String, String> e : dirInfo.fromSource.entrySet()) {
            map.put(e.getValue(), fieldMap.get(e.getKey()));
        }
        if (map.size() > 1) {
            if (canCreateIfOptional && dirInfo.isOptional && dirEntry == null) {
                dirInfo.getSession().createEntry(map);
            } else {
                DocumentModel entry = BaseSession.createEntryModel(null, (String)dirInfo.dirSchemaName, (String)id, null);
                entry.setProperties(dirInfo.dirSchemaName, map);
                dirInfo.getSession().updateEntry(entry);
            }
        }
    }

    public void updateEntry(DocumentModel docModel) {
        this.checkPermission("Write");
        if (MultiDirectorySession.isReadOnlyEntry((DocumentModel)docModel)) {
            return;
        }
        this.init();
        String id = docModel.getId();
        Map fieldMap = docModel.getProperties(this.schemaName);
        for (SourceInfo sourceInfo : this.sourceInfos) {
            boolean canCreateIfOptional = false;
            for (SubDirectoryInfo dirInfo : sourceInfo.requiredSubDirectoryInfos) {
                if (!canCreateIfOptional) {
                    canCreateIfOptional = dirInfo.getSession().getEntry(id) != null;
                }
                MultiDirectorySession.updateSubDirectoryEntry(dirInfo, fieldMap, id, false);
            }
            for (SubDirectoryInfo dirInfo : sourceInfo.optionalSubDirectoryInfos) {
                MultiDirectorySession.updateSubDirectoryEntry(dirInfo, fieldMap, id, canCreateIfOptional);
            }
        }
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        this.init();
        HashMap<String, String> seen = new HashMap<String, String>();
        if (fulltext == null) {
            fulltext = Collections.emptySet();
        }
        HashSet<String> readOnlyEntries = new HashSet<String>();
        DocumentModelListImpl results = new DocumentModelListImpl();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            HashMap maps = new HashMap();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            ArrayList<SubDirectoryInfo> optionalDirsMatching = new ArrayList<SubDirectoryInfo>();
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                HashMap<String, Serializable> dirFilter = new HashMap<String, Serializable>();
                for (Map.Entry<String, Serializable> entry : filter.entrySet()) {
                    String string = dirInfo.fromSource.get(entry.getKey());
                    if (string == null) continue;
                    dirFilter.put(string, entry.getValue());
                }
                if (dirInfo.isOptional) {
                    boolean matches = true;
                    for (Map.Entry entry : dirFilter.entrySet()) {
                        Serializable defaultValue = dirInfo.defaultEntry.get(entry.getKey());
                        Object filterValue = entry.getValue();
                        if (defaultValue == null && filterValue != null) {
                            matches = false;
                            continue;
                        }
                        if (defaultValue == null || defaultValue.equals(filterValue)) continue;
                        matches = false;
                    }
                    if (matches) {
                        optionalDirsMatching.add(dirInfo);
                    }
                }
                HashSet dirFulltext = new HashSet();
                for (String string : fulltext) {
                    String fieldName = dirInfo.fromSource.get(string);
                    if (fieldName == null) continue;
                    dirFulltext.add(fieldName);
                }
                DocumentModelList documentModelList = dirInfo.getSession().query(dirFilter, (Set)dirFulltext, null, fetchReferences);
                for (DocumentModel entry : documentModelList) {
                    String id2 = entry.getId();
                    HashMap<String, Object> map = (HashMap<String, Object>)maps.get(id2);
                    if (map == null) {
                        map = new HashMap<String, Object>();
                        maps.put(id2, map);
                        counts.put(id2, 1);
                    } else {
                        counts.put(id2, (Integer)counts.get(id2) + 1);
                    }
                    for (Map.Entry<String, String> e3 : dirInfo.toSource.entrySet()) {
                        map.put(e3.getValue(), entry.getProperty(dirInfo.dirSchemaName, e3.getKey()));
                    }
                    if (!BaseSession.isReadOnlyEntry((DocumentModel)entry)) continue;
                    readOnlyEntries.add(id2);
                }
            }
            for (SubDirectoryInfo dirInfo : optionalDirsMatching) {
                HashSet existingIds = new HashSet(dirInfo.getSession().getProjection(Collections.emptyMap(), dirInfo.idField));
                for (Map.Entry entry : maps.entrySet()) {
                    String string = (String)entry.getKey();
                    if (existingIds.contains(string)) continue;
                    counts.put(string, (Integer)counts.get(string) + 1);
                    Map map = (Map)entry.getValue();
                    for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                        String value = e.getValue();
                        if (map.containsKey(value)) continue;
                        map.put(value, dirInfo.defaultEntry.get(e.getKey()));
                    }
                }
            }
            int numdirs = sourceInfo.subDirectoryInfos.size();
            maps.keySet().removeIf(id -> (Integer)counts.get(id) != numdirs);
            ((ArrayList)results).ensureCapacity(results.size() + maps.size());
            for (Map.Entry e : maps.entrySet()) {
                String id4 = (String)e.getKey();
                if (seen.containsKey(id4)) {
                    log.warn((Object)String.format("Entry '%s' is present in source '%s' but also in source '%s'. The second one will be ignored.", id4, seen.get(id4), sourceInfo.source.name));
                    continue;
                }
                Map map = (Map)e.getValue();
                seen.put(id4, sourceInfo.source.name);
                DocumentModel documentModel = BaseSession.createEntryModel(null, (String)this.schemaName, (String)id4, (Map)map, (boolean)readOnlyEntries.contains(id4));
                results.add((Object)documentModel);
            }
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.getDirectory().orderEntries((List)results, orderBy);
        }
        return this.applyQueryLimits((DocumentModelList)results, limit, offset);
    }

    public DocumentModelList query(QueryBuilder queryBuilder, boolean fetchReferences) {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField())) {
            throw new DirectoryException("Cannot filter on password");
        }
        this.init();
        HashMap<String, String> sources = new HashMap<String, String>();
        DocumentModelListImpl results = new DocumentModelListImpl();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            MultiDirectoryExpressionEvaluator evaluator = new MultiDirectoryExpressionEvaluator(sourceInfo, this.schemaIdField, this.getName());
            Set<String> ids = evaluator.eval((Expression)queryBuilder.predicate());
            ((ArrayList)results).ensureCapacity(results.size() + ids.size());
            for (String id : ids) {
                String otherSource = sources.putIfAbsent(id, sourceInfo.source.name);
                if (otherSource != null) {
                    log.warn((Object)String.format("Entry '%s' is present in source '%s' but also in source '%s'. The second one will be ignored.", id, otherSource, sourceInfo.source.name));
                    continue;
                }
                DocumentModel entry = this.getEntry(id, fetchReferences);
                results.add((Object)entry);
            }
        }
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        boolean countTotal = queryBuilder.countTotal();
        OrderByList orders = queryBuilder.orders();
        Map orderBy = AbstractDirectory.makeOrderBy((OrderByList)orders);
        if (!orderBy.isEmpty()) {
            this.getDirectory().orderEntries((List)results, orderBy);
        }
        results = this.applyQueryLimits((DocumentModelList)results, limit, offset);
        if (!(limit == 0 && offset == 0 || countTotal)) {
            results.setTotalSize(-2L);
        }
        return results;
    }

    public List<String> queryIds(QueryBuilder queryBuilder) {
        if (!this.hasPermission("Read")) {
            return Collections.emptyList();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField())) {
            throw new DirectoryException("Cannot filter on password");
        }
        this.init();
        HashMap<String, String> sources = new HashMap<String, String>();
        DocumentModelListImpl entries = new DocumentModelListImpl();
        ArrayList<String> ids = new ArrayList<String>();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        OrderByList orders = queryBuilder.orders();
        boolean order = !orders.isEmpty();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            MultiDirectoryExpressionEvaluator evaluator = new MultiDirectoryExpressionEvaluator(sourceInfo, this.schemaIdField, this.getName());
            Set<String> sourceIds = evaluator.eval((Expression)queryBuilder.predicate());
            for (String id : sourceIds) {
                String otherSource = sources.putIfAbsent(id, sourceInfo.source.name);
                if (otherSource != null) {
                    log.warn((Object)String.format("Entry '%s' is present in source '%s' but also in source '%s'. The second one will be ignored.", id, otherSource, sourceInfo.source.name));
                    continue;
                }
                if (order) {
                    entries.add((Object)this.getEntry(id, false));
                    continue;
                }
                ids.add(id);
            }
        }
        if (order) {
            this.getDirectory().orderEntries((List)entries, AbstractDirectory.makeOrderBy((OrderByList)orders));
            entries.forEach(doc -> ids.add(doc.getId()));
        }
        return this.applyQueryLimits(ids, limit, offset);
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) {
        DocumentModelList entries = this.query(filter, fulltext);
        ArrayList<String> results = new ArrayList<String>(entries.size());
        for (DocumentModel entry : entries) {
            Object value = entry.getProperty(this.schemaName, columnName);
            if (value == null) {
                results.add(null);
                continue;
            }
            results.add(value.toString());
        }
        return results;
    }

    public DocumentModel createEntry(DocumentModel entry) {
        Map fieldMap = entry.getProperties(this.schemaName);
        return this.createEntry(fieldMap);
    }

    public boolean hasEntry(String id) {
        this.init();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                Session session = dirInfo.getSession();
                if (!session.hasEntry(id)) continue;
                return true;
            }
        }
        return false;
    }

    protected static class SourceInfo {
        final SourceDescriptor source;
        final List<SubDirectoryInfo> subDirectoryInfos;
        final List<SubDirectoryInfo> requiredSubDirectoryInfos;
        final List<SubDirectoryInfo> optionalSubDirectoryInfos;
        final SubDirectoryInfo authDirectoryInfo;

        SourceInfo(SourceDescriptor source, List<SubDirectoryInfo> subDirectoryInfos, SubDirectoryInfo authDirectoryInfo) {
            this.source = source;
            this.subDirectoryInfos = subDirectoryInfos;
            this.requiredSubDirectoryInfos = new ArrayList<SubDirectoryInfo>();
            this.optionalSubDirectoryInfos = new ArrayList<SubDirectoryInfo>();
            for (SubDirectoryInfo subDirInfo : subDirectoryInfos) {
                if (subDirInfo.isOptional) {
                    this.optionalSubDirectoryInfos.add(subDirInfo);
                    continue;
                }
                this.requiredSubDirectoryInfos.add(subDirInfo);
            }
            this.authDirectoryInfo = authDirectoryInfo;
        }

        public String toString() {
            return String.format("{source=%s infos=%s}", this.source.name, this.subDirectoryInfos);
        }
    }

    protected class SubDirectoryInfo {
        final String dirName;
        final String dirSchemaName;
        final String idField;
        final boolean isAuthenticating;
        final Map<String, String> fromSource;
        final Map<String, String> toSource;
        final Map<String, Serializable> defaultEntry;
        final boolean isOptional;
        Session session;

        SubDirectoryInfo(String dirName, String dirSchemaName, String idField, boolean isAuthenticating, Map<String, String> fromSource, Map<String, String> toSource, Map<String, Serializable> defaultEntry, boolean isOptional) {
            this.dirName = dirName;
            this.dirSchemaName = dirSchemaName;
            this.idField = idField;
            this.isAuthenticating = isAuthenticating;
            this.fromSource = fromSource;
            this.toSource = toSource;
            this.defaultEntry = defaultEntry;
            this.isOptional = isOptional;
        }

        Session getSession() {
            if (this.session == null) {
                this.session = MultiDirectorySession.this.directoryService.open(this.dirName);
            }
            return this.session;
        }

        public String toString() {
            return String.format("{directory=%s fromSource=%s toSource=%s}", this.dirName, this.fromSource, this.toSource);
        }
    }
}

