/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.Environment;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.launcher.config.ConfigurationChecker;
import org.nuxeo.launcher.config.ConfigurationConstants;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationHolder;
import org.nuxeo.launcher.config.ConfigurationLoader;
import org.nuxeo.launcher.config.ConfigurationMarshaller;
import org.nuxeo.log4j.Log4JHelper;

public class ConfigurationGenerator {
    private static final Logger log = LogManager.getLogger(ConfigurationGenerator.class);
    public static final String TEMPLATE_SEPARATOR = ",";
    public static final String NUXEO_ENVIRONMENT_CONF_FORMAT = "nuxeo.%s";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    protected static final Pattern JAVA_OPTS_PATTERN = Pattern.compile("[ ]+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    public static final String JAVA_OPTS_PROP = "launcher.java.opts";
    public static final String VERSIONED_REGEX = "(-\\d+(\\.\\d+)*)?";
    public static final String BOOTSTRAP_JAR_REGEX = "bootstrap(-\\d+(\\.\\d+)*)?.jar";
    public static final String JULI_JAR_REGEX = "tomcat-juli(-\\d+(\\.\\d+)*)?.jar";
    protected static final Path DEFAULT_NUXEO_CONF_PATH = Path.of("bin", "nuxeo.conf");
    private final Map<String, String> environment;
    protected final Properties systemProperties;
    private final ConfigurationHolder configHolder;
    private final ConfigurationLoader configLoader;
    private final ConfigurationMarshaller configMarshaller;
    private final ConfigurationChecker configChecker;
    private final Level logLevel;
    private Environment env;

    @Deprecated(since="11.5")
    public ConfigurationGenerator() {
        this(ConfigurationGenerator.builder());
    }

    @Deprecated(since="11.5")
    public ConfigurationGenerator(boolean quiet, boolean debug) {
        this(ConfigurationGenerator.builder().quiet(quiet));
    }

    protected ConfigurationGenerator(Builder builder) {
        this.logLevel = builder.quiet ? Level.DEBUG : Level.INFO;
        this.environment = builder.environment;
        this.systemProperties = builder.systemProperties;
        this.configHolder = new ConfigurationHolder(builder.nuxeoHome, builder.nuxeoConf);
        this.configLoader = new ConfigurationLoader(builder.environment, builder.parametersMigration, builder.hideDeprecationWarnings);
        this.configMarshaller = new ConfigurationMarshaller(this.systemProperties);
        this.configChecker = new ConfigurationChecker(this.systemProperties);
        this.systemProperties.setProperty("nuxeo.conf", this.configHolder.getNuxeoConfPath().toString());
        ConfigurationGenerator.initLogsIfNeeded(this.configHolder);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.configHolder::getHomePath;
        log.log(this.logLevel, "Nuxeo home:          {}", supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.configHolder::getNuxeoConfPath;
        log.log(this.logLevel, "Nuxeo configuration: {}", supplierArray2);
        String nuxeoProfiles = this.environment.get("NUXEO_PROFILES");
        if (StringUtils.isNotBlank((CharSequence)nuxeoProfiles)) {
            log.log(this.logLevel, "Nuxeo profiles:      {}", (Object)nuxeoProfiles);
        }
    }

    public static ConfigurationGenerator build() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static void initLogsIfNeeded(ConfigurationHolder configHolder) {
        if (LoggerContext.getContext((boolean)false).getRootLogger().getAppenders().isEmpty()) {
            Path logConfigPath = configHolder.getLogConfigPath();
            if (Files.notExists(logConfigPath, new LinkOption[0])) {
                System.out.println("No logs configuration, will setup a basic one.");
                Configurator.initialize((Configuration)new DefaultConfiguration());
            } else {
                System.out.println("Try to configure logs with configuration: " + logConfigPath);
                Configurator.initialize((Configuration)Log4JHelper.newConfiguration(logConfigPath.toFile()));
            }
            log.info("Logs successfully configured.");
        }
    }

    public CryptoProperties getUserConfig() {
        return this.configHolder.userConfig;
    }

    public void run() throws ConfigurationException {
        if (this.init()) {
            if (!this.configChecker.isConfigured(this.configHolder)) {
                log.info("No current configuration, generating files...");
                this.generateFiles();
            } else if (this.configHolder.isForceGeneration()) {
                log.info("Configuration files generation (nuxeo.force.generation={})...", new Supplier[]{() -> this.configHolder.getProperty("nuxeo.force.generation")});
                this.generateFiles();
            } else {
                log.info("Server already configured (set nuxeo.force.generation=true to force configuration files generation).");
            }
        }
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean init(boolean forceReload) {
        if (Files.notExists(this.configHolder.getNuxeoConfPath(), new LinkOption[0])) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.configHolder::getNuxeoConfPath;
            log.info("Missing {}", supplierArray);
            return false;
        }
        if (!this.configHolder.isLoaded() || forceReload) {
            try {
                this.loadConfiguration(true);
            }
            catch (ConfigurationException e) {
                log.warn("Error reading basic configuration.", (Throwable)e);
                return false;
            }
        }
        return this.configHolder.isLoaded();
    }

    private void loadConfiguration(boolean evalDynamicProperties) throws ConfigurationException {
        Map<String, String> newParametersToSave;
        this.configHolder.clear();
        Path templatesPath = this.configHolder.getTemplatesPath();
        if (Files.notExists(templatesPath.resolve("nuxeo.defaults"), new LinkOption[0])) {
            throw new ConfigurationException("Missing nuxeo.defaults configuration in: " + templatesPath);
        }
        this.configHolder.putDefaultAll(this.configLoader.loadNuxeoDefaults(templatesPath));
        this.configHolder.putDefaultAll(this.systemProperties);
        this.configHolder.putAll(this.configLoader.loadProperties(this.configHolder.getNuxeoConfPath()));
        this.includeTemplates();
        if (evalDynamicProperties && (newParametersToSave = this.evalDynamicProperties()) != null && !newParametersToSave.isEmpty()) {
            this.saveConfiguration(newParametersToSave, false, false);
        }
        if (this.configHolder.getPropertyAsBoolean("org.nuxeo.dev")) {
            log.warn("Nuxeo Dev mode is enabled");
        }
    }

    protected void includeTemplates() throws ConfigurationException {
        String profiles;
        Object templates = this.configHolder.getProperty("nuxeo.templates");
        if (StringUtils.isBlank((CharSequence)templates)) {
            log.warn("No template found in configuration! Fallback on 'default'.");
            templates = "default";
            this.configHolder.put("nuxeo.templates", (String)templates);
        }
        String templatesWildcard = this.configHolder.stringPropertyNames().stream().filter(k -> k.startsWith("nuxeo.append.templates.")).sorted().map(this.configHolder::getProperty).collect(Collectors.joining(TEMPLATE_SEPARATOR));
        if (StringUtils.isNotBlank((CharSequence)templatesWildcard)) {
            templates = (String)templates + TEMPLATE_SEPARATOR + templatesWildcard;
        }
        if (StringUtils.isNotBlank((CharSequence)(profiles = this.environment.get("NUXEO_PROFILES")))) {
            templates = (String)templates + TEMPLATE_SEPARATOR + profiles;
        }
        this.includeTemplates((String)templates, new HashSet<Path>());
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.configHolder::getIncludedTemplates;
        log.debug("Templates included: {}", supplierArray);
    }

    protected Map<String, String> evalDynamicProperties() throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        this.evalLoopbackURL();
        this.evalServerStatusKey(newParametersToSave);
        return newParametersToSave;
    }

    private void evalServerStatusKey(Map<String, String> newParametersToSave) {
        if (this.configHolder.getOptProperty("server.status.key").isEmpty()) {
            newParametersToSave.put("server.status.key", UUID.randomUUID().toString().substring(0, 8));
        }
    }

    private void evalLoopbackURL() throws ConfigurationException {
        Object loopbackURL = this.configHolder.getProperty("nuxeo.loopback.url");
        if (loopbackURL != null) {
            log.debug("Using configured loop back url: {}", loopbackURL);
            return;
        }
        InetAddress bindAddress = this.configChecker.getBindAddress(this.configHolder);
        String httpPort = this.configHolder.getProperty("nuxeo.server.http.port");
        String contextPath = this.configHolder.getProperty("org.nuxeo.ecm.contextPath");
        loopbackURL = bindAddress instanceof Inet6Address ? "http://[" + bindAddress.getHostAddress() + "]:" + httpPort + contextPath : "http://" + bindAddress.getHostAddress() + ":" + httpPort + contextPath;
        log.debug("Set as loop back URL: {}", loopbackURL);
        this.configHolder.putDefault("nuxeo.loopback.url", (String)loopbackURL);
    }

    protected void generateFiles() throws ConfigurationException {
        this.configMarshaller.dumpConfiguration(this.configHolder);
        log.info("Configuration files generated.");
        if (this.configHolder.isForceGenerationOnce()) {
            this.configHolder.put("nuxeo.force.generation", "false");
            this.configMarshaller.persistNuxeoConf(this.configHolder);
        }
    }

    private List<Path> includeTemplates(String templatesList, Set<Path> includedTemplates) throws ConfigurationException {
        ArrayList<Path> orderedTemplates = new ArrayList<Path>();
        StringTokenizer st = new StringTokenizer(templatesList, TEMPLATE_SEPARATOR);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            Path chosenTemplate = Path.of(nextToken, new String[0]);
            if (!chosenTemplate.isAbsolute() || Files.notExists(chosenTemplate, new LinkOption[0])) {
                chosenTemplate = this.configHolder.getTemplatesPath().resolve(nextToken);
            }
            if (includedTemplates.contains(chosenTemplate)) {
                log.debug("Already included {}", (Object)nextToken);
                continue;
            }
            if (Files.notExists(chosenTemplate, new LinkOption[0])) {
                log.error("Template '{}' not found with relative or absolute path ({}). Check your {} parameter, and {} for included files.", (Object)nextToken, (Object)chosenTemplate, (Object)"nuxeo.templates", (Object)PARAM_INCLUDED_TEMPLATES);
                continue;
            }
            includedTemplates.add(chosenTemplate);
            if (Files.notExists(chosenTemplate.resolve("nuxeo.defaults"), new LinkOption[0])) {
                log.warn("Ignore template (no default configuration): {}", (Object)nextToken);
                continue;
            }
            Properties templateProperties = this.configLoader.loadNuxeoDefaults(chosenTemplate);
            String subTemplatesList = templateProperties.getProperty(PARAM_INCLUDED_TEMPLATES);
            if (StringUtils.isNotBlank((CharSequence)subTemplatesList)) {
                orderedTemplates.addAll(this.includeTemplates(subTemplatesList, includedTemplates));
            }
            this.configHolder.putTemplateAll(chosenTemplate, templateProperties);
            orderedTemplates.add(chosenTemplate);
            log.log(this.logLevel, "Include template: {}", (Object)chosenTemplate);
        }
        return orderedTemplates;
    }

    public void saveConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.saveConfiguration(changedParameters, false, true);
    }

    public void saveConfiguration(Map<String, String> changedParameters, boolean setGenerationOnceToFalse, boolean setGenerationFalseToOnce) throws ConfigurationException {
        if (setGenerationOnceToFalse && this.configHolder.isForceGenerationOnce()) {
            this.configHolder.put("nuxeo.force.generation", "false");
        } else if (setGenerationFalseToOnce && !this.configHolder.isForceGeneration()) {
            this.configHolder.put("nuxeo.force.generation", "once");
        }
        if (changedParameters.containsValue(null) || changedParameters.containsValue("")) {
            HashSet<String> propertiesToUnset = new HashSet<String>();
            for (Map.Entry<String, String> entry : changedParameters.entrySet()) {
                if (!StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
                propertiesToUnset.add(entry.getKey());
            }
            for (String key : propertiesToUnset) {
                changedParameters.remove(key);
                this.configHolder.userConfig.remove((Object)key);
            }
        }
        this.configHolder.userConfig.putAll(changedParameters);
        this.configMarshaller.persistNuxeoConf(this.configHolder);
    }

    public void saveFilteredConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        Map<String, String> filteredParameters = this.getChangedParameters(changedParameters);
        this.saveConfiguration(filteredParameters);
    }

    public Map<String, String> getChangedParameters(Map<String, String> changedParameters) {
        HashMap<String, String> filteredChangedParameters = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : changedParameters.entrySet()) {
            String key = entry.getKey();
            if ("nuxeo.force.generation".equals(key)) continue;
            String oldParam = this.configHolder.getProperty(key);
            String newParam = StringUtils.trim((String)entry.getValue());
            if ((oldParam != null || !StringUtils.isNotEmpty((CharSequence)newParam)) && (oldParam == null || oldParam.trim().equals(newParam))) continue;
            if ("nuxeo.templates".equals(key)) {
                newParam = (String)StringUtils.defaultIfEmpty((CharSequence)newParam, (CharSequence)"default");
            }
            filteredChangedParameters.put(key, newParam);
        }
        return filteredChangedParameters;
    }

    public void verifyInstallation() throws ConfigurationException {
        try {
            Files.createDirectories(this.configHolder.getLogPath(), new FileAttribute[0]);
            Files.createDirectories(this.configHolder.getPidDirPath(), new FileAttribute[0]);
            Files.createDirectories(this.configHolder.getDataPath(), new FileAttribute[0]);
            Files.createDirectories(this.configHolder.getTmpPath(), new FileAttribute[0]);
            Files.createDirectories(this.configHolder.getPackagesPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to create server directories", e);
        }
        this.configChecker.verify(this.configHolder);
    }

    public void addTemplate(String templatesToAdd) throws ConfigurationException {
        String newTemplatesStr = Stream.concat(Stream.of(this.configHolder.getProperty("nuxeo.templates").split(TEMPLATE_SEPARATOR)), Stream.of(templatesToAdd.split(TEMPLATE_SEPARATOR))).distinct().collect(Collectors.joining(TEMPLATE_SEPARATOR));
        this.saveFilteredConfiguration(Map.of("nuxeo.templates", newTemplatesStr));
        this.loadConfiguration(false);
    }

    public void rmTemplate(String templatesToRm) throws ConfigurationException {
        Set<String> templatesToRmSet = Set.of(templatesToRm.split(TEMPLATE_SEPARATOR));
        String newTemplatesStr = Stream.of(this.configHolder.getProperty("nuxeo.templates").split(TEMPLATE_SEPARATOR)).filter(Predicate.not(templatesToRmSet::contains)).collect(Collectors.joining(TEMPLATE_SEPARATOR));
        this.saveFilteredConfiguration(Map.of("nuxeo.templates", newTemplatesStr));
        this.loadConfiguration(false);
    }

    public String setProperty(String key, String value) throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        newParametersToSave.put(key, value);
        return this.setProperties(newParametersToSave).get(key);
    }

    public Map<String, String> setProperties(Map<String, String> newParametersToSave) throws ConfigurationException {
        HashMap<String, String> oldValues = new HashMap<String, String>();
        for (String key : newParametersToSave.keySet()) {
            oldValues.put(key, this.configHolder.getProperty(key));
        }
        this.saveFilteredConfiguration(newParametersToSave);
        this.loadConfiguration(true);
        return oldValues;
    }

    public Map<String, String> setProperties(String template, Map<String, String> newParametersToSave) throws ConfigurationException {
        String nuxeoEnv;
        Path templatePath = Path.of(template, new String[0]);
        if (!templatePath.isAbsolute()) {
            templatePath = this.configHolder.getTemplatesPath().resolve(template);
        }
        Path templateConf = StringUtils.isBlank((CharSequence)(nuxeoEnv = this.environment.get("NUXEO_ENVIRONMENT"))) ? templatePath.resolve("nuxeo.defaults") : templatePath.resolve(String.format(NUXEO_ENVIRONMENT_CONF_FORMAT, nuxeoEnv));
        Map<String, String> oldValues = this.configMarshaller.persistNuxeoDefaults(templateConf, newParametersToSave);
        this.loadConfiguration(true);
        return oldValues;
    }

    public Environment getEnv() {
        if (this.env == null) {
            this.env = new Environment(this.configHolder.getRuntimeHomePath().toFile());
            Path distribPath = this.configHolder.getTemplatesPath().resolve(ConfigurationConstants.FILE_TEMPLATE_DISTRIBUTION_PROPS);
            if (Files.exists(distribPath, new LinkOption[0])) {
                try {
                    this.env.loadProperties(this.configLoader.loadProperties(distribPath));
                }
                catch (ConfigurationException e) {
                    log.error((Object)e);
                }
            }
            this.env.loadProperties((Properties)this.configHolder.userConfig);
            this.env.setServerHome(this.configHolder.getHomePath().toFile());
            this.env.init();
            this.env.setData(this.configHolder.getDataPath().toFile());
            this.env.setLog(this.configHolder.getLogPath().toFile());
            this.env.setTemp(this.configHolder.getTmpPath().toFile());
            this.env.setPath("nuxeo.mp.dir", this.configHolder.getPackagesPath().toFile(), this.env.getServerHome());
        }
        return this.env;
    }

    public Crypto getCrypto() {
        return this.configHolder.userConfig.getCrypto();
    }

    public List<String> getJavaOpts(Function<String, String> mapper) {
        return Arrays.stream(JAVA_OPTS_PATTERN.split(this.systemProperties.getProperty(JAVA_OPTS_PROP, ""))).map(option -> StringSubstitutor.replace((Object)option, (Properties)this.getUserConfig())).map(mapper).collect(Collectors.toList());
    }

    public ConfigurationHolder getConfigurationHolder() {
        return this.configHolder;
    }

    public static class Builder {
        protected Path nuxeoHome;
        protected Path nuxeoConf;
        protected Map<String, String> environment = System.getenv();
        protected Properties systemProperties = System.getProperties();
        protected boolean quiet = true;
        protected Map<String, String> parametersMigration = Map.ofEntries(Map.entry("nuxeo.templates.parsing.extensions", "nuxeo.plaintext_parsing_extensions"), Map.entry("nuxeo.db.user.separator.key", "nuxeo.db.user_separator_key"), Map.entry("mail.pop3.host", "mail.store.host"), Map.entry("mail.pop3.port", "mail.store.port"), Map.entry("mail.smtp.host", "mail.transport.host"), Map.entry("mail.smtp.port", "mail.transport.port"), Map.entry("mail.smtp.username", "mail.transport.username"), Map.entry("mail.transport.username", "mail.transport.user"), Map.entry("mail.smtp.password", "mail.transport.password"), Map.entry("mail.smtp.usetls", "mail.transport.usetls"), Map.entry("mail.smtp.auth", "mail.transport.auth"), Map.entry("nuxeo.server.tomcat-admin.port", "nuxeo.server.tomcat_admin.port"));
        protected boolean hideDeprecationWarnings;
        protected boolean init;

        protected Builder() {
        }

        protected Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        protected Builder systemProperties(Properties systemProperties) {
            this.systemProperties = systemProperties;
            return this;
        }

        protected Builder putSystemProperty(String key, String value) {
            this.systemProperties.put(key, value);
            return this;
        }

        public Builder quiet(boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public Builder hideDeprecationWarnings(boolean hideDeprecationWarnings) {
            this.hideDeprecationWarnings = hideDeprecationWarnings;
            return this;
        }

        public Builder init(boolean init) {
            this.init = init;
            return this;
        }

        public ConfigurationGenerator build() {
            if (this.nuxeoHome == null) {
                Environment nuxeoEnvironment = Environment.getDefault((Properties)this.systemProperties);
                if (nuxeoEnvironment != null && nuxeoEnvironment.getServerHome() != null) {
                    this.nuxeoHome = nuxeoEnvironment.getServerHome().toPath();
                } else {
                    this.nuxeoHome = Path.of(this.systemProperties.getProperty("user.dir"), new String[0]);
                    if ("bin".equalsIgnoreCase(this.nuxeoHome.getFileName().toString())) {
                        this.nuxeoHome = this.nuxeoHome.getParent();
                    }
                }
            }
            if (this.nuxeoConf == null) {
                String nuxeoConfProperty = this.systemProperties.getProperty("nuxeo.conf");
                this.nuxeoConf = nuxeoConfProperty == null ? this.nuxeoHome.resolve(DEFAULT_NUXEO_CONF_PATH) : Path.of(nuxeoConfProperty, new String[0]);
            }
            ConfigurationGenerator generator = new ConfigurationGenerator(this);
            if (this.init) {
                generator.init();
            }
            return generator;
        }
    }
}

